/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.awt.geom.Point2D;
import java.util.List;
import net.sourceforge.plantuml.geom.LineSegmentDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.hector.Box2D;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;

class SmartConnection {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private final List<Box2D> forbidden;

    public SmartConnection(double x1, double y1, double x2, double y2, List<Box2D> forbidden) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.forbidden = forbidden;
    }

    public SmartConnection(Point2D p1, Point2D p2, List<Box2D> b) {
        this(p1.getX(), p1.getY(), p2.getX(), p2.getY(), b);
    }

    public void draw(UGraphic ug, HtmlColor color) {
        LineSegmentDouble seg = new LineSegmentDouble(this.x1, this.y1, this.x2, this.y2);
        boolean clash = this.intersect(seg);
        ug = clash ? ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UStroke(1.0)) : ug.apply(new UChangeColor(color)).apply(new UStroke(1.5));
        seg.draw(ug);
    }

    private boolean intersect(LineSegmentDouble seg) {
        for (Box2D box2 : this.forbidden) {
            if (!box2.doesIntersect(seg)) continue;
            return true;
        }
        return false;
    }

    public void drawEx1(UGraphic ug, HtmlColor color) {
        ug = ug.apply(new UChangeColor(color)).apply(new UStroke(1.5));
        double orthoX = -(this.y2 - this.y1);
        double orthoY = this.x2 - this.x1;
        for (int i = -10; i <= 10; ++i) {
            for (int j = -10; j <= 10; ++j) {
                double d1x = orthoX * (double)i / 10.0;
                double d1y = orthoY * (double)i / 10.0;
                double c1x = (this.x1 + this.x2) / 2.0 + d1x;
                double c1y = (this.y1 + this.y2) / 2.0 + d1y;
                double d2x = orthoX * (double)j / 10.0;
                double d2y = orthoY * (double)j / 10.0;
                double c2x = (this.x1 + this.x2) / 2.0 + d2x;
                double c2y = (this.y1 + this.y2) / 2.0 + d2y;
                UPath path2 = new UPath();
                path2.moveTo(this.x1, this.y1);
                path2.cubicTo(c1x, c1y, c2x, c2y, this.x2, this.y2);
                ug.draw(path2);
            }
        }
    }
}

