/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbolActor;
import net.sourceforge.plantuml.graphic.USymbolArtifact;
import net.sourceforge.plantuml.graphic.USymbolBoundary;
import net.sourceforge.plantuml.graphic.USymbolCard;
import net.sourceforge.plantuml.graphic.USymbolCloud;
import net.sourceforge.plantuml.graphic.USymbolCollections;
import net.sourceforge.plantuml.graphic.USymbolComponent1;
import net.sourceforge.plantuml.graphic.USymbolComponent2;
import net.sourceforge.plantuml.graphic.USymbolControl;
import net.sourceforge.plantuml.graphic.USymbolDatabase;
import net.sourceforge.plantuml.graphic.USymbolEntityDomain;
import net.sourceforge.plantuml.graphic.USymbolFile;
import net.sourceforge.plantuml.graphic.USymbolFolder;
import net.sourceforge.plantuml.graphic.USymbolFrame;
import net.sourceforge.plantuml.graphic.USymbolInterface;
import net.sourceforge.plantuml.graphic.USymbolNode;
import net.sourceforge.plantuml.graphic.USymbolQueue;
import net.sourceforge.plantuml.graphic.USymbolRect;
import net.sourceforge.plantuml.graphic.USymbolStack;
import net.sourceforge.plantuml.graphic.USymbolStorage;
import net.sourceforge.plantuml.graphic.USymbolTogether;

public abstract class USymbol {
    private static final Map<String, USymbol> all = new HashMap<String, USymbol>();
    public static final USymbol STORAGE = USymbol.record("STORAGE", SkinParameter.STORAGE, new USymbolStorage());
    public static final USymbol DATABASE = USymbol.record("DATABASE", SkinParameter.DATABASE, new USymbolDatabase());
    public static final USymbol CLOUD = USymbol.record("CLOUD", SkinParameter.CLOUD, new USymbolCloud());
    public static final USymbol CARD = USymbol.record("CARD", SkinParameter.CARD, new USymbolCard(SkinParameter.CARD));
    public static final USymbol FRAME = USymbol.record("FRAME", SkinParameter.FRAME, new USymbolFrame());
    public static final USymbol NODE = USymbol.record("NODE", SkinParameter.NODE, new USymbolNode());
    public static final USymbol ARTIFACT = USymbol.record("ARTIFACT", SkinParameter.ARTIFACT, new USymbolArtifact());
    public static final USymbol PACKAGE = USymbol.record("PACKAGE", SkinParameter.PACKAGE, new USymbolFolder(SkinParameter.PACKAGE));
    public static final USymbol FOLDER = USymbol.record("FOLDER", SkinParameter.FOLDER, new USymbolFolder(SkinParameter.FOLDER));
    public static final USymbol FILE = USymbol.record("FILE", SkinParameter.FILE, new USymbolFile());
    public static final USymbol RECTANGLE = USymbol.record("RECTANGLE", SkinParameter.RECTANGLE, new USymbolRect(SkinParameter.RECTANGLE, HorizontalAlignment.CENTER));
    public static final USymbol COLLECTIONS = USymbol.record("COLLECTIONS", SkinParameter.COLLECTIONS, new USymbolCollections(SkinParameter.RECTANGLE, HorizontalAlignment.CENTER));
    public static final USymbol AGENT = USymbol.record("AGENT", SkinParameter.AGENT, new USymbolRect(SkinParameter.AGENT, HorizontalAlignment.CENTER));
    public static final USymbol ACTOR = USymbol.record("ACTOR", SkinParameter.ACTOR, new USymbolActor());
    public static final USymbol USECASE = null;
    public static final USymbol COMPONENT1 = USymbol.record("COMPONENT1", SkinParameter.COMPONENT1, new USymbolComponent1());
    public static final USymbol COMPONENT2 = USymbol.record("COMPONENT2", SkinParameter.COMPONENT2, new USymbolComponent2());
    public static final USymbol BOUNDARY = USymbol.record("BOUNDARY", SkinParameter.BOUNDARY, new USymbolBoundary());
    public static final USymbol ENTITY_DOMAIN = USymbol.record("ENTITY_DOMAIN", SkinParameter.ENTITY_DOMAIN, new USymbolEntityDomain(2.0));
    public static final USymbol CONTROL = USymbol.record("CONTROL", SkinParameter.CONTROL, new USymbolControl(2.0));
    public static final USymbol INTERFACE = USymbol.record("INTERFACE", SkinParameter.INTERFACE, new USymbolInterface());
    public static final USymbol QUEUE = USymbol.record("QUEUE", SkinParameter.QUEUE, new USymbolQueue());
    public static final USymbol STACK = USymbol.record("STACK", SkinParameter.STACK, new USymbolStack());
    public static final USymbol TOGETHER = USymbol.record("TOGETHER", SkinParameter.QUEUE, new USymbolTogether());

    public abstract SkinParameter getSkinParameter();

    public USymbol withStereoAlignment(HorizontalAlignment alignment) {
        return this;
    }

    public FontParam getFontParam() {
        return this.getSkinParameter().getFontParam();
    }

    public FontParam getFontParamStereotype() {
        return this.getSkinParameter().getFontParamStereotype();
    }

    public ColorParam getColorParamBack() {
        return this.getSkinParameter().getColorParamBack();
    }

    public ColorParam getColorParamBorder() {
        return this.getSkinParameter().getColorParamBorder();
    }

    public static USymbol getFromString(String s) {
        if (s == null) {
            return null;
        }
        USymbol result = all.get(StringUtils.goUpperCase(s.replaceAll("\\W", "")));
        if (result == null) {
            if (s.equalsIgnoreCase("component")) {
                return COMPONENT2;
            }
            if (s.equalsIgnoreCase("entity")) {
                return ENTITY_DOMAIN;
            }
            return null;
        }
        return result;
    }

    private static USymbol record(String code, SkinParameter skinParameter, USymbol symbol) {
        all.put(StringUtils.goUpperCase(code), symbol);
        return symbol;
    }

    public abstract TextBlock asSmall(TextBlock var1, TextBlock var2, TextBlock var3, SymbolContext var4);

    public abstract TextBlock asBig(TextBlock var1, HorizontalAlignment var2, TextBlock var3, double var4, double var6, SymbolContext var8);

    public boolean manageHorizontalLine() {
        return false;
    }

    public int suppHeightBecauseOfShape() {
        return 0;
    }

    public int suppWidthBecauseOfShape() {
        return 0;
    }

    final Stencil getRectangleStencil(final Dimension2D dim) {
        return new Stencil(){

            @Override
            public double getStartingX(StringBounder stringBounder, double y) {
                return 0.0;
            }

            @Override
            public double getEndingX(StringBounder stringBounder, double y) {
                return dim.getWidth();
            }
        };
    }

    public static USymbol getFromString(String symbol, boolean useUml2ForComponent) {
        USymbol usymbol = null;
        if (symbol.equalsIgnoreCase("artifact")) {
            usymbol = ARTIFACT;
        } else if (symbol.equalsIgnoreCase("folder")) {
            usymbol = FOLDER;
        } else if (symbol.equalsIgnoreCase("file")) {
            usymbol = FILE;
        } else if (symbol.equalsIgnoreCase("package")) {
            usymbol = PACKAGE;
        } else if (symbol.equalsIgnoreCase("rectangle")) {
            usymbol = RECTANGLE;
        } else if (symbol.equalsIgnoreCase("collections")) {
            usymbol = COLLECTIONS;
        } else if (symbol.equalsIgnoreCase("node")) {
            usymbol = NODE;
        } else if (symbol.equalsIgnoreCase("frame")) {
            usymbol = FRAME;
        } else if (symbol.equalsIgnoreCase("cloud")) {
            usymbol = CLOUD;
        } else if (symbol.equalsIgnoreCase("database")) {
            usymbol = DATABASE;
        } else if (symbol.equalsIgnoreCase("queue")) {
            usymbol = QUEUE;
        } else if (symbol.equalsIgnoreCase("stack")) {
            usymbol = STACK;
        } else if (symbol.equalsIgnoreCase("storage")) {
            usymbol = STORAGE;
        } else if (symbol.equalsIgnoreCase("agent")) {
            usymbol = AGENT;
        } else if (symbol.equalsIgnoreCase("actor")) {
            usymbol = ACTOR;
        } else if (symbol.equalsIgnoreCase("component")) {
            usymbol = useUml2ForComponent ? COMPONENT2 : COMPONENT1;
        } else if (symbol.equalsIgnoreCase("boundary")) {
            usymbol = BOUNDARY;
        } else if (symbol.equalsIgnoreCase("control")) {
            usymbol = CONTROL;
        } else if (symbol.equalsIgnoreCase("entity")) {
            usymbol = ENTITY_DOMAIN;
        } else if (symbol.equalsIgnoreCase("card")) {
            usymbol = CARD;
        } else if (symbol.equalsIgnoreCase("interface")) {
            usymbol = INTERFACE;
        } else if (symbol.equalsIgnoreCase("()")) {
            usymbol = INTERFACE;
        }
        return usymbol;
    }

    static class Margin {
        private final double x1;
        private final double x2;
        private final double y1;
        private final double y2;

        Margin(double x1, double x2, double y1, double y2) {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
        }

        double getWidth() {
            return this.x1 + this.x2;
        }

        double getHeight() {
            return this.y1 + this.y2;
        }

        public Dimension2D addDimension(Dimension2D dim) {
            return new Dimension2DDouble(dim.getWidth() + this.x1 + this.x2, dim.getHeight() + this.y1 + this.y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }
    }
}

