/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.sprite.SpriteGrayLevel;

public final class FactorySpriteCommand
implements SingleMultiFactoryCommand<UmlDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("sprite[%s]+\\$?"), new RegexLeaf("NAME", "([\\p{L}0-9_]+)[%s]*"), new RegexLeaf("DIM", "(?:\\[(\\d+)x(\\d+)/(\\d+)(z)?\\])?"), new RegexLeaf("[%s]*\\{"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("sprite[%s]+\\$?"), new RegexLeaf("NAME", "([\\p{L}0-9_]+)[%s]*"), new RegexLeaf("DIM", "(?:\\[(\\d+)x(\\d+)/(\\d+)(z)\\])?"), new RegexLeaf("[%s]+"), new RegexLeaf("DATA", "([-_A-Za-z0-9]+)"), new RegexLeaf("$"));
    }

    @Override
    public Command<UmlDiagram> createSingleLine() {
        return new SingleLineCommand2<UmlDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(UmlDiagram system, RegexResult arg) {
                return FactorySpriteCommand.this.executeInternal(system, arg, Arrays.asList(arg.get("DATA", 0)));
            }
        };
    }

    @Override
    public Command<UmlDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<UmlDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.REMOVE_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?sprite|\\}$";
            }

            @Override
            public CommandExecutionResult executeNow(UmlDiagram system, BlocLines lines) {
                lines = lines.trim(true);
                RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
                lines = lines.subExtract(1, 1);
                if ((lines = lines.removeEmptyColumns()).size() == 0) {
                    return CommandExecutionResult.error("No sprite defined.");
                }
                return FactorySpriteCommand.this.executeInternal(system, line0, lines.getLines());
            }
        };
    }

    private CommandExecutionResult executeInternal(UmlDiagram system, RegexResult line0, List<CharSequence> strings) {
        try {
            Sprite sprite;
            if (line0.get("DIM", 0) == null) {
                sprite = SpriteGrayLevel.GRAY_16.buildSprite(-1, -1, strings);
            } else {
                int width = Integer.parseInt(line0.get("DIM", 0));
                int height = Integer.parseInt(line0.get("DIM", 1));
                int nbColor = Integer.parseInt(line0.get("DIM", 2));
                if (nbColor != 4 && nbColor != 8 && nbColor != 16) {
                    return CommandExecutionResult.error("Only 4, 8 or 16 graylevel are allowed.");
                }
                SpriteGrayLevel level = SpriteGrayLevel.get(nbColor);
                sprite = line0.get("DIM", 3) == null ? level.buildSprite(width, height, strings) : level.buildSpriteZ(width, height, this.concat(strings));
            }
            system.addSprite(line0.get("NAME", 0), sprite);
            return CommandExecutionResult.ok();
        }
        catch (IOException e) {
            return CommandExecutionResult.error("Cannot decode sprite.");
        }
    }

    private String concat(List<? extends CharSequence> strings) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence charSequence : strings) {
            sb.append(StringUtils.trin(charSequence));
        }
        return sb.toString();
    }
}

