/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileCircleStop
extends AbstractFtile {
    private static final int SIZE = 20;
    private final HtmlColor backColor;
    private final Swimlane swimlane;

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    public FtileCircleStop(ISkinParam skinParam, HtmlColor backColor, Swimlane swimlane) {
        super(skinParam);
        this.backColor = backColor;
        this.swimlane = swimlane;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        double xTheoricalPosition = 0.0;
        double yTheoricalPosition = 0.0;
        xTheoricalPosition = Math.round(xTheoricalPosition);
        yTheoricalPosition = Math.round(yTheoricalPosition);
        UEllipse circle = new UEllipse(20.0, 20.0);
        if (this.skinParam().shadowing()) {
            circle.setDeltaShadow(3.0);
        }
        ug.apply(new UChangeColor(this.backColor)).apply(new UChangeBackColor(null)).apply(new UTranslate(xTheoricalPosition, yTheoricalPosition)).draw(circle);
        double delta = 4.0;
        UEllipse circleSmall = new UEllipse(12.0, 12.0);
        if (this.skinParam().shadowing()) {
            circleSmall.setDeltaShadow(3.0);
        }
        ug.apply(new UChangeColor(null)).apply(new UChangeBackColor(this.backColor)).apply(new UTranslate(xTheoricalPosition + 4.0 + 0.5, yTheoricalPosition + 4.0 + 0.5)).draw(circleSmall);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        return new FtileGeometry(20.0, 20.0, 10.0, 0.0);
    }
}

