/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import jcckit.graphic.BasicGraphicalElement;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.Rectangle;

public class ClippingRectangle
implements ClippingShape {
    private final double _minX;
    private final double _minY;
    private final double _maxX;
    private final double _maxY;

    public ClippingRectangle(double x1, double y1, double x2, double y2) {
        this._minX = Math.min(x1, x2);
        this._minY = Math.min(y1, y2);
        this._maxX = Math.max(x1, x2);
        this._maxY = Math.max(y1, y2);
    }

    @Override
    public boolean isInside(GraphPoint point2) {
        double x = point2.getX();
        double y = point2.getY();
        return this._minX <= x && x <= this._maxX && this._minY <= y && y <= this._maxY;
    }

    public double getMinX() {
        return this._minX;
    }

    public double getMaxX() {
        return this._maxX;
    }

    public double getMinY() {
        return this._minY;
    }

    public double getMaxY() {
        return this._maxY;
    }

    @Override
    public ClippingRectangle getBoundingBox() {
        return this;
    }

    @Override
    public BasicGraphicalElement getGraphicalElement() {
        return new Rectangle(new GraphPoint(0.5 * (this._minX + this._maxX), 0.5 * (this._minY + this._maxY)), this._maxX - this._minX, this._maxY - this._minY, null);
    }
}

