/*
 * Decompiled with CFR 0.152.
 */
package jsci.util;

import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.ExtraMath;
import jsci.maths.Mapping;

public final class RandomMap
implements Mapping,
ComplexMapping {
    private final double min;
    private final double max;
    public static final RandomMap MAP = new RandomMap();

    public RandomMap() {
        this(0.0, 1.0);
    }

    public RandomMap(double minimum, double maximum) {
        this.min = minimum;
        this.max = maximum;
    }

    @Override
    public double map(double x) {
        return ExtraMath.random(this.min, this.max);
    }

    @Override
    public Complex map(Complex z) {
        return new Complex(this.map(z.real()), this.map(z.imag()));
    }

    @Override
    public Complex map(double real, double imag) {
        return new Complex(this.map(real), this.map(imag));
    }
}

