/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.quantum;

import jsci.maths.AbstractMath;
import jsci.maths.Complex;
import jsci.physics.quantum.DensityMatrix;
import jsci.physics.quantum.KetVector;
import jsci.physics.quantum.Operator;
import jsci.physics.quantum.Projector;

public final class QuantumMath
extends AbstractMath {
    private QuantumMath() {
    }

    public static Operator commutator(Operator A, Operator B) {
        return A.multiply(B).subtract(B.multiply(A));
    }

    public static Operator anticommutator(Operator A, Operator B) {
        return A.multiply(B).add(B.multiply(A));
    }

    public static Complex expectation(Operator op, KetVector ket) {
        return ket.toBraVector().multiply(op).multiply(ket);
    }

    public static Complex expectation(DensityMatrix dm, Operator op) {
        return dm.multiply(op).trace();
    }

    public static Complex probability(Projector p, KetVector ket) {
        return ket.toBraVector().multiply(p).multiply(ket);
    }

    public static Complex probability(DensityMatrix dm, Projector p) {
        return dm.multiply(p).trace();
    }
}

