/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.quantum;

import jsci.maths.Complex;
import jsci.maths.DimensionException;
import jsci.maths.algebras.Module;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.ComplexVector;
import jsci.maths.vectors.MathVector;
import jsci.maths.vectors.VectorDimensionException;
import jsci.physics.quantum.KetVector;
import jsci.physics.quantum.Operator;

public final class BraVector
extends MathVector {
    private AbstractComplexVector representation;

    public BraVector(AbstractComplexVector rep) {
        super(rep.dimension());
        this.representation = rep;
    }

    public boolean equals(Object a) {
        return this.representation.equals(((BraVector)a).representation);
    }

    public String toString() {
        return this.representation.toString();
    }

    public int hashCode() {
        return this.representation.hashCode();
    }

    public KetVector toKetVector() {
        return new KetVector(this.representation.conjugate());
    }

    public AbstractComplexVector getRepresentation() {
        return this.representation;
    }

    @Override
    public double norm() {
        return this.representation.norm();
    }

    @Override
    public Object getSet() {
        return this.representation.getSet();
    }

    @Override
    public AbelianGroup.Member negate() {
        return this.representation.negate();
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member v) {
        if (v instanceof BraVector) {
            return this.add((BraVector)v);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public BraVector add(BraVector v) {
        return new BraVector(this.representation.add(v.representation));
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member v) {
        if (v instanceof BraVector) {
            return this.subtract((BraVector)v);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public BraVector subtract(BraVector v) {
        return new BraVector(this.representation.subtract(v.representation));
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        return this.representation.scalarMultiply(x);
    }

    public Complex multiply(KetVector ket) {
        int braDim = this.dimension();
        if (braDim == ket.dimension()) {
            AbstractComplexVector ketRep = ket.getRepresentation();
            Complex answer = this.representation.getComponent(0).multiply(ketRep.getComponent(0));
            for (int i = 1; i < braDim; ++i) {
                answer = answer.add(this.representation.getComponent(i).multiply(ketRep.getComponent(i)));
            }
            return answer;
        }
        throw new VectorDimensionException("Vectors have different dimensions.");
    }

    public BraVector multiply(Operator op) {
        int braDim = this.dimension();
        if (braDim == op.dimension()) {
            AbstractComplexSquareMatrix opRep = op.getRepresentation();
            Complex[] array = new Complex[braDim];
            for (int i = 0; i < braDim; ++i) {
                Complex tmp = this.representation.getComponent(0).multiply(opRep.getElement(0, i));
                for (int j = 1; j < braDim; ++j) {
                    tmp = tmp.add(this.representation.getComponent(j).multiply(opRep.getElement(j, i)));
                }
                array[i] = tmp;
            }
            return new BraVector(new ComplexVector(array));
        }
        throw new DimensionException("Operator and vector have different dimensions.");
    }
}

