/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiElectronNeutrino;
import jsci.physics.particles.AntiLepton;
import jsci.physics.particles.Electron;
import jsci.physics.particles.Photon;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class Positron
extends AntiLepton {
    @Override
    public double restMass() {
        return 0.510998902;
    }

    @Override
    public int charge() {
        return 1;
    }

    @Override
    public int eLeptonQN() {
        return -1;
    }

    @Override
    public int muLeptonQN() {
        return 0;
    }

    @Override
    public int tauLeptonQN() {
        return 0;
    }

    @Override
    public QuantumParticle anti() {
        return new Electron();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof Electron;
    }

    public String toString() {
        return new String("Positron");
    }

    public Positron emit(Photon y) {
        this.momentum = this.momentum.subtract(y.momentum);
        return this;
    }

    public Positron absorb(Photon y) {
        this.momentum = this.momentum.add(y.momentum);
        return this;
    }

    public AntiElectronNeutrino emit(WPlus w) {
        AntiElectronNeutrino n = new AntiElectronNeutrino();
        n.momentum = this.momentum.subtract(w.momentum);
        return n;
    }

    public AntiElectronNeutrino absorb(WMinus w) {
        AntiElectronNeutrino n = new AntiElectronNeutrino();
        n.momentum = this.momentum.add(w.momentum);
        return n;
    }

    public Positron emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public Positron absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

