/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics;

import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.Double3Vector;
import jsci.physics.AbstractClassicalParticle;

public class ClassicalParticle3D
extends AbstractClassicalParticle {
    protected double mass;
    protected double x;
    protected double y;
    protected double z;
    protected double vx;
    protected double vy;
    protected double vz;

    public void setMass(double m) {
        this.mass = m;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    public void setPosition(double xPos, double yPos, double zPos) {
        this.x = xPos;
        this.y = yPos;
        this.z = zPos;
    }

    @Override
    public AbstractDoubleVector getPosition() {
        return new Double3Vector(this.x, this.y, this.z);
    }

    public void setXPosition(double xPos) {
        this.x = xPos;
    }

    public double getXPosition() {
        return this.x;
    }

    public void setYPosition(double yPos) {
        this.y = yPos;
    }

    public double getYPosition() {
        return this.y;
    }

    public void setZPosition(double zPos) {
        this.z = zPos;
    }

    public double getZPosition() {
        return this.z;
    }

    public void setVelocity(double xVel, double yVel, double zVel) {
        this.vx = xVel;
        this.vy = yVel;
        this.vz = zVel;
    }

    @Override
    public AbstractDoubleVector getVelocity() {
        return new Double3Vector(this.vx, this.vy, this.vz);
    }

    public double getXVelocity() {
        return this.vx;
    }

    public double getYVelocity() {
        return this.vy;
    }

    public double getZVelocity() {
        return this.vz;
    }

    @Override
    public double speed() {
        return Math.sqrt(this.vx * this.vx + this.vy * this.vy + this.vz * this.vz);
    }

    public void setMomentum(double xMom, double yMom, double zMom) {
        this.vx = xMom / this.mass;
        this.vy = yMom / this.mass;
        this.vz = zMom / this.mass;
    }

    @Override
    public AbstractDoubleVector getMomentum() {
        return new Double3Vector(this.mass * this.vx, this.mass * this.vy, this.mass * this.vz);
    }

    public double getXMomentum() {
        return this.mass * this.vx;
    }

    public double getYMomentum() {
        return this.mass * this.vy;
    }

    public double getZMomentum() {
        return this.mass * this.vz;
    }

    @Override
    public double energy() {
        return this.mass * (this.vx * this.vx + this.vy * this.vy + this.vz * this.vz) / 2.0;
    }

    public ClassicalParticle3D move(double dt) {
        return this.translate(dt);
    }

    public ClassicalParticle3D translate(double dt) {
        this.x += this.vx * dt;
        this.y += this.vy * dt;
        this.z += this.vz * dt;
        return this;
    }

    public ClassicalParticle3D accelerate(double ax, double ay, double az, double dt) {
        this.vx += ax * dt;
        this.vy += ay * dt;
        this.vz += az * dt;
        return this;
    }

    public ClassicalParticle3D applyForce(double Fx, double Fy, double Fz, double dt) {
        return this.accelerate(Fx / this.mass, Fy / this.mass, Fz / this.mass, dt);
    }

    public ClassicalParticle3D gravitate(ClassicalParticle3D p, double dt) {
        double dx = p.x - this.x;
        double dy = p.y - this.y;
        double dz = p.z - this.z;
        double rr = dx * dx + dy * dy + dz * dz;
        double r = Math.sqrt(rr);
        double g = p.mass / rr;
        double pg = this.mass / rr;
        this.vx -= g * dx * dt / r;
        this.vy -= g * dy * dt / r;
        this.vz -= g * dz * dt / r;
        p.vx += pg * dx * dt / r;
        p.vy += pg * dy * dt / r;
        p.vz += pg * dz * dt / r;
        return this;
    }
}

