/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics;

import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;
import jsci.physics.AbstractClassicalParticle;

public class ClassicalParticle
extends AbstractClassicalParticle {
    protected double mass;
    protected AbstractDoubleVector x;
    protected AbstractDoubleVector v;

    public ClassicalParticle(int n) {
        this.x = new DoubleVector(n);
        this.v = new DoubleVector(n);
    }

    public void setMass(double m) {
        this.mass = m;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    public void setPosition(AbstractDoubleVector pos) {
        this.x = pos;
    }

    @Override
    public AbstractDoubleVector getPosition() {
        return this.x;
    }

    public void setVelocity(AbstractDoubleVector vel) {
        this.v = vel;
    }

    @Override
    public AbstractDoubleVector getVelocity() {
        return this.v;
    }

    private double speedSqr() {
        return this.v.scalarProduct(this.v);
    }

    @Override
    public double speed() {
        return this.v.norm();
    }

    public void setMomentum(AbstractDoubleVector momentum) {
        this.v = momentum.scalarDivide(this.mass);
    }

    @Override
    public AbstractDoubleVector getMomentum() {
        return this.v.scalarMultiply(this.mass);
    }

    @Override
    public double energy() {
        return this.mass * this.speedSqr() / 2.0;
    }

    public ClassicalParticle move(double dt) {
        this.x = this.x.add(this.v.scalarMultiply(dt));
        return this;
    }

    public ClassicalParticle accelerate(AbstractDoubleVector a, double dt) {
        this.v = this.v.add(a.scalarMultiply(dt));
        return this;
    }

    public ClassicalParticle applyForce(AbstractDoubleVector F, double dt) {
        return this.accelerate(F.scalarDivide(this.mass), dt);
    }
}

