/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.splines;

import jsci.maths.ArrayMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.splines.Spline;

public class SumOfDiracs
extends Spline
implements Filter,
Cloneable {
    protected static final int filtretype = -1;
    private double[] vecteur;

    @Override
    public int getFilterType() {
        return -1;
    }

    @Override
    public String toString() {
        return ArrayMath.toString(this.vecteur);
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof SumOfDiracs && this.vecteur.length == ((SumOfDiracs)a).dimension()) {
            SumOfDiracs iv = (SumOfDiracs)a;
            for (int i = 0; i < this.vecteur.length; ++i) {
                if (this.vecteur[i] == iv.getValue(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        SumOfDiracs sod = (SumOfDiracs)super.clone();
        if (this.vecteur != null) {
            sod.vecteur = ArrayMath.copy(this.vecteur);
        }
        return sod;
    }

    @Override
    public int previousDimension(int k) {
        int i = (int)Math.round((double)(k + 1) / 2.0);
        if (2 * i - 1 == k) {
            return i;
        }
        throw new IllegalArgumentException("Even number of values into an odd Filter! Change the number of data values/of iterations.");
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 2) {
            throw new IllegalArgumentException("The array is not long enough : " + gete.length + " < 2");
        }
        double[] data = Cascades.oversample(gete);
        int dl = data.length - 1;
        double[] sortie = new double[2 * gete.length - 1];
        double[] vg = new double[]{0.0, 1.0, 0.0};
        double[] v0 = new double[]{1.0, 0.0};
        for (int k = 1; k <= dl - 1; ++k) {
            sortie[k] = ArrayMath.scalarProduct(ArrayMath.extract(k - 1, k + 1, data), vg);
        }
        sortie[0] = ArrayMath.scalarProduct(ArrayMath.extract(0, 1, data), v0);
        sortie[dl] = ArrayMath.scalarProduct(ArrayMath.extract(dl, dl - 1, data), v0);
        return sortie;
    }

    @Override
    public double[] highpass(double[] gete) {
        return this.lowpass(gete);
    }

    public SumOfDiracs(double[] v) {
        this.vecteur = v;
    }

    public SumOfDiracs() {
    }

    public double getValue(int i) {
        if (i < 0 || i > this.vecteur.length - 1) {
            throw new IllegalArgumentException("Incorrect parameters : " + i + ", " + this.vecteur.length);
        }
        return this.vecteur[i];
    }

    public void setValues(double[] v) {
        this.vecteur = v;
    }

    public double mass(double a, double b) {
        double mass = 0.0;
        for (int i = 0; i < this.vecteur.length; ++i) {
            mass += this.vecteur[i];
        }
        mass = mass * Math.abs(b - a) / (double)this.vecteur.length;
        return mass;
    }

    public void setValue(int i, double d) {
        if (i < 0) {
            throw new IllegalArgumentException("The parameter must be positive : " + i);
        }
        this.vecteur[i] = d;
    }

    @Override
    public int dimension() {
        return this.vecteur.length;
    }

    @Override
    public int dimension(int j) {
        return Cascades.dimension(this.vecteur.length, j);
    }

    @Override
    public double[] interpolate(int j) {
        if (j < 0) {
            throw new IllegalArgumentException("This parameter must be postive : " + j);
        }
        return Cascades.evaluation(this, j, this.vecteur);
    }

    @Override
    public double[] evaluate(int j) {
        return this.interpolate(j);
    }
}

