/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.splines;

import jsci.maths.ArrayMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.splines.LinearSpline;
import jsci.maths.wavelet.splines.Spline;

public class QuadraticSpline
extends Spline
implements Filter,
Cloneable {
    protected static final int filtretype = 2;
    private double[] vecteur;
    static final double[] vg = new double[]{0.25, 0.75, 0.75, 0.25};
    static final double[] v0 = new double[]{0.75, 0.25};

    @Override
    public String toString() {
        return ArrayMath.toString(this.vecteur);
    }

    @Override
    public int getFilterType() {
        return 2;
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof QuadraticSpline && this.vecteur.length == ((QuadraticSpline)a).dimension()) {
            QuadraticSpline iv = (QuadraticSpline)a;
            for (int i = 0; i < this.vecteur.length; ++i) {
                if (this.vecteur[i] == iv.getValue(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int previousDimension(int k) {
        return Cascades.previousDimension(2, k);
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 3) {
            throw new IllegalArgumentException("The array is not long enough : " + gete.length + " < 3");
        }
        double[] sortie = new double[2 * gete.length - 2];
        for (int k = 1; k < gete.length - 1; ++k) {
            int n = 2 * k - 2;
            sortie[n] = sortie[n] + gete[k] * vg[0];
            int n2 = 2 * k - 1;
            sortie[n2] = sortie[n2] + gete[k] * vg[1];
            int n3 = 2 * k;
            sortie[n3] = sortie[n3] + gete[k] * vg[2];
            int n4 = 2 * k + 1;
            sortie[n4] = sortie[n4] + gete[k] * vg[3];
        }
        sortie[0] = sortie[0] + v0[0] * gete[0];
        sortie[1] = sortie[1] + v0[1] * gete[0];
        int n = sortie.length - 1;
        sortie[n] = sortie[n] + v0[0] * gete[gete.length - 1];
        int n5 = sortie.length - 2;
        sortie[n5] = sortie[n5] + v0[1] * gete[gete.length - 1];
        return sortie;
    }

    @Override
    public double[] highpass(double[] gete) {
        return this.lowpass(gete);
    }

    public QuadraticSpline(double[] v) {
        this.vecteur = v;
    }

    public QuadraticSpline() {
    }

    @Override
    public Object clone() {
        QuadraticSpline sod = (QuadraticSpline)super.clone();
        if (this.vecteur != null) {
            sod.vecteur = ArrayMath.copy(this.vecteur);
        }
        return sod;
    }

    public double getValue(int i) {
        if (i < 0 || i > this.vecteur.length - 1) {
            throw new IllegalArgumentException("Parameter incorrect : " + i + ", " + this.vecteur.length);
        }
        return this.vecteur[i];
    }

    public void setValue(int i, double d) {
        if (i < 0) {
            throw new IllegalArgumentException("The parameter must be positive : " + i);
        }
        this.vecteur[i] = d;
    }

    public void setValues(double[] v) {
        this.vecteur = v;
    }

    public LinearSpline derive() {
        return this.derive(0.0, 1.0);
    }

    public LinearSpline derive(double a, double b) {
        double[] v = new double[this.vecteur.length - 1];
        for (int i = 0; i < this.vecteur.length - 1; ++i) {
            v[i] = 2.0 * (this.vecteur[i + 1] - this.vecteur[i]) * (double)this.vecteur.length / Math.abs(b - a);
        }
        return new LinearSpline(v);
    }

    @Override
    public int dimension() {
        return this.vecteur.length;
    }

    @Override
    public int dimension(int j) {
        return Cascades.dimension(this.vecteur.length, j, 2);
    }

    @Override
    public double[] interpolate(int j) {
        if (j < 0) {
            throw new IllegalArgumentException("This parameter must be postive : " + j);
        }
        return Cascades.evaluation(this, j, this.vecteur);
    }

    @Override
    public double[] evaluate(int j) {
        return this.interpolate(j);
    }
}

