/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.splines;

import jsci.maths.ArrayMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.splines.PiecewiseConstant;
import jsci.maths.wavelet.splines.Spline;

public class LinearSpline
extends Spline
implements Filter,
Cloneable {
    protected static final int filtretype = 1;
    private double[] vecteur;
    static final double[] vg = new double[]{0.5, 1.0, 0.5};
    static final double[] v0 = new double[]{1.0, 0.5};

    @Override
    public int getFilterType() {
        return 1;
    }

    @Override
    public String toString() {
        return ArrayMath.toString(this.vecteur);
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof LinearSpline && this.vecteur.length == ((LinearSpline)a).dimension()) {
            LinearSpline iv = (LinearSpline)a;
            for (int i = 0; i < this.vecteur.length; ++i) {
                if (this.vecteur[i] == iv.getValue(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int previousDimension(int k) {
        int i = (int)Math.round((double)(k + 1) / 2.0);
        if (2 * i - 1 == k) {
            return i;
        }
        throw new IllegalArgumentException("Even number of values into an odd Filter! Change the number of data values/of iterations.");
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] donnee) {
        if (donnee.length < 2) {
            throw new IllegalArgumentException("The array is not long enough : " + donnee.length + " < 2");
        }
        double[] sortie = new double[2 * donnee.length - 1];
        for (int k = 1; k < donnee.length - 1; ++k) {
            int n = 2 * k - 1;
            sortie[n] = sortie[n] + donnee[k] * vg[0];
            int n2 = 2 * k;
            sortie[n2] = sortie[n2] + donnee[k] * vg[1];
            int n3 = 2 * k + 1;
            sortie[n3] = sortie[n3] + donnee[k] * vg[2];
        }
        sortie[0] = sortie[0] + v0[0] * donnee[0];
        sortie[1] = sortie[1] + v0[1] * donnee[0];
        int n = sortie.length - 1;
        sortie[n] = sortie[n] + v0[0] * donnee[donnee.length - 1];
        int n4 = sortie.length - 2;
        sortie[n4] = sortie[n4] + v0[1] * donnee[donnee.length - 1];
        return sortie;
    }

    @Override
    public double[] highpass(double[] donnee) {
        return this.lowpass(donnee);
    }

    public LinearSpline(double[] v) {
        this.vecteur = v;
    }

    public LinearSpline() {
    }

    @Override
    public Object clone() {
        LinearSpline sod = (LinearSpline)super.clone();
        if (this.vecteur != null) {
            sod.vecteur = ArrayMath.copy(this.vecteur);
        }
        return sod;
    }

    public double getValue(int i) {
        if (i < 0 || i > this.vecteur.length - 1) {
            throw new IllegalArgumentException("Incorrect parameter : " + i + ", " + this.vecteur.length);
        }
        return this.vecteur[i];
    }

    public void setValue(int i, double d) {
        if (i < 0) {
            throw new IllegalArgumentException("The parameter must be positive: " + i);
        }
        this.vecteur[i] = d;
    }

    public void setValues(double[] v) {
        this.vecteur = v;
    }

    public PiecewiseConstant derive() {
        return this.derive(0.0, 1.0);
    }

    public PiecewiseConstant derive(double a, double b) {
        double[] v = new double[this.vecteur.length - 1];
        for (int i = 0; i < this.vecteur.length - 1; ++i) {
            v[i] = (this.vecteur[i + 1] - this.vecteur[i]) * (double)(this.vecteur.length - 1) / Math.abs(b - a);
        }
        PiecewiseConstant d = new PiecewiseConstant(v);
        return d;
    }

    @Override
    public int dimension() {
        return this.vecteur.length;
    }

    @Override
    public int dimension(int j) {
        return Cascades.dimension(this.vecteur.length, j);
    }

    @Override
    public double[] interpolate(int j) {
        if (j < 0) {
            throw new IllegalArgumentException("This parameter must be postive : " + j);
        }
        return Cascades.evaluation(this, j, this.vecteur);
    }

    @Override
    public double[] evaluate(int j) {
        return this.interpolate(j);
    }
}

