/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.haar;

import jsci.maths.wavelet.FWT;

public class FastHaar
extends FWT {
    static final float[] scale = new float[]{(float)(1.0 / Math.sqrt(2.0)), (float)(1.0 / Math.sqrt(2.0))};
    static final float[] wavelet = new float[]{-scale[1], scale[0]};

    private static void transform(float[] v, int last) {
        float[] ans = new float[last];
        int half = last / 2;
        try {
            int k = 0;
            while (true) {
                ans[k + half] = v[2 * k + 0] * wavelet[0] + v[2 * k + 1] * wavelet[1];
                ans[k] = v[2 * k + 0] * scale[0] + v[2 * k + 1] * scale[1];
                ++k;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.arraycopy(ans, 0, v, 0, last);
            return;
        }
    }

    @Override
    public void transform(float[] v) {
        int last;
        for (last = v.length; last > 2; last /= 2) {
            FastHaar.transform(v, last);
        }
        if (last != 2) {
            System.err.println("Careful! this should be a power of 2 : " + v.length);
        }
    }

    @Override
    public void invTransform(float[] v) {
        int last = 2;
        while (2 * last <= v.length) {
            FastHaar.invTransform(v, last);
            last *= 2;
        }
        if (last != v.length) {
            System.err.println("Careful! this should be a power of 2 : " + v.length);
        }
    }

    private static void invTransform(float[] v, int last) {
        int ResultingLength = 2 * last;
        float[] ans = new float[ResultingLength];
        try {
            int k = 0;
            while (true) {
                int n = 2 * k + 1;
                ans[n] = ans[n] + (scale[1] * v[k] + wavelet[1] * v[k + last]);
                int n2 = 2 * k + 0;
                ans[n2] = ans[n2] + (scale[0] * v[k] + wavelet[0] * v[k + last]);
                ++k;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.arraycopy(ans, 0, v, 0, ans.length);
            return;
        }
    }
}

