/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.daubechies7;

import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.daubechies7.Daubechies7;

public final class Scaling7
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies7 cdf = new Daubechies7();

    public Scaling7(int N0, int K) {
        this.setParameters(N0, K);
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof Scaling7) {
            Scaling7 iv = (Scaling7)a;
            return this.dimension(0) == iv.dimension(0) && this.position() == iv.position();
        }
        return false;
    }

    @Override
    public String toString() {
        String ans = new String("[n0=");
        ans.concat(Integer.toString(this.n0));
        ans.concat("][k=");
        ans.concat(Integer.toString(this.k));
        ans.concat("]");
        return ans;
    }

    public Scaling7() {
    }

    @Override
    public int getFilterType() {
        return 12;
    }

    public void setParameters(int N0, int K) {
        if (N0 < 24) {
            throw new IllegalScalingException(N0, 24);
        }
        this.n0 = N0;
        this.k = K;
    }

    @Override
    public Object clone() {
        Scaling7 s = (Scaling7)super.clone();
        s.n0 = this.n0;
        s.k = this.k;
        return s;
    }

    @Override
    public double[] evaluate(int j) {
        return cdf.evalScaling(this.n0, this.k, j);
    }

    @Override
    public int dimension(int jfin) {
        return Cascades.dimension(this.n0, jfin, 12);
    }

    @Override
    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

