/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.daubechies5;

import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.daubechies5.Daubechies5;

public final class Wavelet5
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies5 cdf = new Daubechies5();

    public Wavelet5(int N0, int K) {
        this.setParameters(N0, K);
    }

    public Wavelet5() {
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof Wavelet5) {
            Wavelet5 iv = (Wavelet5)a;
            return this.dimension(0) == iv.dimension(0) && this.position() == iv.position();
        }
        return false;
    }

    @Override
    public String toString() {
        String ans = new String("[n0=");
        ans.concat(Integer.toString(this.n0));
        ans.concat("][k=");
        ans.concat(Integer.toString(this.k));
        ans.concat("]");
        return ans;
    }

    @Override
    public int getFilterType() {
        return 8;
    }

    public void setParameters(int N0, int K) {
        if (N0 < 16) {
            throw new IllegalScalingException(N0, 16);
        }
        this.n0 = N0;
        this.k = K;
    }

    @Override
    public Object clone() {
        Wavelet5 w = (Wavelet5)super.clone();
        w.n0 = this.n0;
        w.k = this.k;
        return w;
    }

    @Override
    public double[] evaluate(int j) {
        return cdf.evalWavelet(this.n0, this.k, j);
    }

    @Override
    public int dimension(int jfin) {
        return Cascades.dimension(this.n0, jfin + 1, 8);
    }

    @Override
    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

