/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.daubechies2;

import jsci.maths.ArrayMath;
import jsci.maths.NumericalConstants;
import jsci.maths.WaveletMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.Multiresolution;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.daubechies2.Scaling2;
import jsci.maths.wavelet.daubechies2.Wavelet2;

public final class Daubechies2
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 2;
    protected static final int minlength = 4;
    static final double[] vgtemp = new double[]{0.482962913145, 0.836516303738, 0.224143868042, -0.129409522551};
    static final double[] v0temp = new double[]{0.848528137424, -0.529150262213};
    static final double[] v1temp = new double[]{0.132287565553, 0.212132034356, 0.838525491562, -0.484122918276};
    static final double[] vd0temp = new double[]{0.848528137424, 0.529150262213};
    static final double[] vd1temp = new double[]{-0.132287565553, 0.212132034356, 0.838525491562, 0.484122918276};
    static final double[] vg = ArrayMath.scalarMultiply(1.4142135623730951, vgtemp);
    static final double[] vd0 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd0temp));
    static final double[] vd1 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd1temp));
    static final double[] v0 = ArrayMath.scalarMultiply(1.4142135623730951, v0temp);
    static final double[] v1 = ArrayMath.scalarMultiply(1.4142135623730951, v1temp);
    static final double[] phvg = WaveletMath.lowToHigh(vgtemp);
    static final double[] phv0 = new double[]{-0.512347538298, -0.821583836258, 0.216506350947, -0.125};
    static final double[] phvd0temp = new double[]{0.512347538298, -0.821583836258, 0.216506350946, 0.125};
    static final double[] phvd0 = ArrayMath.invert(phvd0temp);

    @Override
    public int getFilterType() {
        return 2;
    }

    @Override
    public MultiscaleFunction primaryScaling(int n0, int k) {
        return new Scaling2(n0, k);
    }

    @Override
    public MultiscaleFunction dualScaling(int n0, int k) {
        return new Scaling2(n0, k);
    }

    @Override
    public MultiscaleFunction primaryWavelet(int n0, int k) {
        return new Wavelet2(n0, k);
    }

    @Override
    public MultiscaleFunction dualWavelet(int n0, int k) {
        return new Wavelet2(n0, k);
    }

    @Override
    public int previousDimension(int k) {
        return Cascades.previousDimension(2, k);
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 4) {
            throw new IllegalScalingException("The array is not long enough: " + gete.length + " < " + 4);
        }
        double[] sortie = new double[2 * gete.length - 2];
        int dl0 = gete.length - 1;
        for (int k = 2; k <= dl0 - 2; ++k) {
            for (int L = -2; L < 2; ++L) {
                int n = 2 * k + L;
                sortie[n] = sortie[n] + vg[L + 2] * gete[k];
            }
        }
        sortie = ArrayMath.add(sortie, gete[0], v0, 0);
        sortie = ArrayMath.add(sortie, gete[1], v1, 0);
        int p0 = sortie.length - vd0.length;
        int p1 = sortie.length - vd1.length;
        sortie = ArrayMath.add(sortie, gete[dl0], vd0, p0);
        sortie = ArrayMath.add(sortie, gete[dl0 - 1], vd1, p1);
        return sortie;
    }

    @Override
    public double[] highpass(double[] gete) {
        double[] sortie = new double[2 * gete.length + 2];
        int dl0 = gete.length - 1;
        for (int k = 1; k <= dl0 - 1; ++k) {
            for (int L = -2; L < 2; ++L) {
                int n = 2 * k + L + 2;
                sortie[n] = sortie[n] + phvg[L + 2] * gete[k];
            }
        }
        sortie = ArrayMath.add(sortie, gete[0], phv0, 0);
        int p0 = sortie.length - phvd0.length;
        sortie = ArrayMath.add(sortie, gete[dl0], phvd0, p0);
        return sortie;
    }

    public double[] evalScaling(int n0, int k, int j1) {
        return Cascades.evalScaling(this, n0, j1, k);
    }

    public double[] evalWavelet(int n0, int k, int j1) {
        return Cascades.evalWavelet(this, 2, n0, j1, k);
    }
}

