/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet;

import jsci.maths.ArrayMath;
import jsci.maths.EngineerMath;
import jsci.maths.NumericalConstants;
import jsci.maths.wavelet.FWTCoef;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.Signal;

public final class FWTPacketCoef
implements NumericalConstants,
Cloneable {
    protected double[][] coefs;
    protected boolean[] StandardChoice;
    static final double normalisation = 0.7071067811865475;

    public FWTPacketCoef() {
    }

    public FWTPacketCoef(double[][] v, boolean[] b) {
        this.coefs = v;
        this.StandardChoice = b;
        if (b.length != v.length - 1) {
            throw new IllegalArgumentException("boolean[].length must be exactly double[][].length -1: boolean[].length=" + b.length + " and double[][].length=" + v.length);
        }
    }

    public Object clone() {
        try {
            FWTPacketCoef fwtp = (FWTPacketCoef)super.clone();
            if (this.coefs != null) {
                fwtp.coefs = ArrayMath.copy(this.coefs);
            }
            if (this.StandardChoice != null) {
                fwtp.StandardChoice = new boolean[this.StandardChoice.length];
                System.arraycopy(this.StandardChoice, 0, fwtp.StandardChoice, 0, this.StandardChoice.length);
            }
            return fwtp;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    public int getJ() {
        return this.coefs.length;
    }

    public int dimension(int i) {
        if (i < 0 || i >= this.coefs.length) {
            throw new IllegalArgumentException("This scale doesn't exist : " + i + ", " + this.coefs.length);
        }
        return this.coefs[i].length;
    }

    public double[][] getCoefs() {
        return this.coefs;
    }

    public double[] norm() {
        double[] ans = new double[this.coefs.length];
        for (int j = 0; j < this.coefs.length; ++j) {
            ans[j] = ArrayMath.norm(this.coefs[j]);
        }
        return ans;
    }

    public double norm(int i) {
        if (i < 0 || i >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + i + " should be between 0 and " + (this.coefs.length - 1));
        }
        double ans = ArrayMath.norm(this.coefs[i]);
        return ans;
    }

    private double[] sumSquares() {
        double[] ans = new double[this.coefs.length];
        for (int j = 0; j < this.coefs.length; ++j) {
            ans[j] = ArrayMath.sumSquares(this.coefs[j]);
        }
        return ans;
    }

    public double sumSquares(int i) {
        if (i < 0 || i >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + i + " must be between 0 et " + (this.coefs.length - 1));
        }
        double ans = ArrayMath.sumSquares(this.coefs[i]);
        return ans;
    }

    public double mass(int i) {
        if (i < 0 || i >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + i + " should be between 0 and " + (this.coefs.length - 1));
        }
        double ans = ArrayMath.mass(this.coefs[i]);
        return ans;
    }

    private double[] variance() {
        double[] ans = new double[this.coefs.length];
        for (int j = 0; j < this.coefs.length; ++j) {
            ans[j] = ArrayMath.variance(this.coefs[j]);
        }
        return ans;
    }

    public double variance(int i) {
        if (i < 0 || i >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + i + " should be between 0 and " + (this.coefs.length - 1));
        }
        double ans = ArrayMath.variance(this.coefs[i]);
        return ans;
    }

    public double sumEnergies() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] energies = this.sumSquares();
        double ans = 0.0;
        for (int k = 0; k < energies.length; ++k) {
            ans += energies[k];
        }
        return ans;
    }

    public double entropy() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double sumEnergies = this.sumEnergies();
        int nombreDeCoefficients = 0;
        for (int k = 0; k < this.coefs.length; ++k) {
            nombreDeCoefficients += this.coefs[k].length;
        }
        double[] pourcentageDEnergie = new double[nombreDeCoefficients];
        int pos = 0;
        for (int k = 0; k < this.coefs.length; ++k) {
            for (int l = 0; l < this.coefs[k].length; ++l) {
                pourcentageDEnergie[pos] = this.coefs[k][l] * this.coefs[k][l] / sumEnergies;
                ++pos;
            }
        }
        return EngineerMath.icf(pourcentageDEnergie);
    }

    public double sumVariance() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] variances = this.variance();
        double ans = 0.0;
        for (int k = 0; k < variances.length; ++k) {
            ans += variances[k];
        }
        return ans;
    }

    public double energyRatio(int i) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (i < 0 || i >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + i + " should be between 0 and " + (this.coefs.length - 1));
        }
        if (this.sumEnergies() == 0.0) {
            if (this.coefs.length != 0) {
                return 1 / this.coefs.length;
            }
            throw new IllegalArgumentException("No energy!");
        }
        return this.sumSquares(i) / this.sumEnergies();
    }

    public double varianceRatio(int i) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (i < 0 || i >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parament " + i + " should be between 0 and " + (this.coefs.length - 1));
        }
        if (this.sumVariance() == 0.0) {
            if (this.coefs.length != 0) {
                return 1 / this.coefs.length;
            }
            throw new IllegalArgumentException("No variance!");
        }
        return this.variance(i) / this.sumVariance();
    }

    public double icf() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] pe = new double[this.coefs.length - 1];
        for (int j = 0; j < this.coefs.length; ++j) {
            pe[j] = this.energyRatio(j);
        }
        return EngineerMath.icf(pe);
    }

    public double varianceICF() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] pv = new double[this.coefs.length - 1];
        for (int j = 0; j < this.coefs.length; ++j) {
            pv[j] = this.varianceRatio(j);
        }
        return EngineerMath.icf(pv);
    }

    public void setCoefs(double[][] v) {
        this.coefs = v;
    }

    public void setPacket(boolean[] b) {
        this.StandardChoice = b;
    }

    public void setCoefs(double[] v, int i) {
        if (i < 0 || i >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + i + " should be between 0 and " + (this.coefs.length - 1));
        }
        this.coefs[i] = v;
    }

    public void synthesize(Filter filtreprimaire, double[] param) {
        double[] W0;
        double[] V0;
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No synthesis left to do: " + this.coefs.length);
        }
        if (this.StandardChoice[this.StandardChoice.length - 1]) {
            V0 = filtreprimaire.lowpass(this.coefs[this.coefs.length - 1], param);
            V0 = ArrayMath.scalarMultiply(0.7071067811865475, V0);
            W0 = filtreprimaire.highpass(this.coefs[this.coefs.length - 2], param);
        } else {
            V0 = filtreprimaire.lowpass(this.coefs[this.coefs.length - 2], param);
            V0 = ArrayMath.scalarMultiply(0.7071067811865475, V0);
            W0 = filtreprimaire.highpass(this.coefs[this.coefs.length - 1], param);
        }
        if (V0.length != W0.length) {
            throw new IllegalArgumentException("Synthesis is impossible : bad data/multiresolution? " + this.coefs[0].length + ", " + this.coefs[this.coefs.length - 1].length + ", " + V0.length + ", " + W0.length);
        }
        V0 = ArrayMath.add(V0, W0);
        double[][] c = new double[this.coefs.length - 1][];
        for (int j = 0; j < this.coefs.length - 2; ++j) {
            c[j] = this.coefs[j];
        }
        c[this.coefs.length - 1] = V0;
        this.coefs = c;
        boolean[] b = new boolean[c.length - 1];
        for (int j = 0; j < b.length; ++j) {
            b[j] = this.StandardChoice[j];
        }
        this.StandardChoice = b;
    }

    public void synthesize(Filter filtreprimaire, double[] param, int jmax) {
        if (jmax < 0 || jmax > this.coefs.length - 1) {
            throw new IllegalArgumentException("The integer parameter " + jmax + " must be between 0 and " + (this.coefs.length - 1));
        }
        for (int j = 0; j < jmax; ++j) {
            this.synthesize(filtreprimaire, param);
        }
    }

    public void synthesizeTout(Filter filtreprimaire, double[] param) {
        this.synthesize(filtreprimaire, param, this.coefs.length - 1);
    }

    public void synthesize(Filter filtreprimaire) {
        double[] W0;
        double[] V0;
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No synthesis left to do: " + this.coefs.length);
        }
        if (this.StandardChoice[this.StandardChoice.length - 1]) {
            V0 = filtreprimaire.lowpass(this.coefs[this.coefs.length - 1]);
            V0 = ArrayMath.scalarMultiply(0.7071067811865475, V0);
            W0 = filtreprimaire.highpass(this.coefs[this.coefs.length - 2]);
        } else {
            V0 = filtreprimaire.lowpass(this.coefs[this.coefs.length - 2]);
            V0 = ArrayMath.scalarMultiply(0.7071067811865475, V0);
            W0 = filtreprimaire.highpass(this.coefs[this.coefs.length - 1]);
        }
        if (V0.length != W0.length) {
            throw new IllegalArgumentException("Synthesis is impossible : bad data/multiresolution? " + this.coefs[0].length + ", " + this.coefs[this.coefs.length - 1].length + ", " + V0.length + ", " + W0.length);
        }
        V0 = ArrayMath.add(V0, W0);
        double[][] c = new double[this.coefs.length - 1][];
        for (int j = 0; j < this.coefs.length - 2; ++j) {
            c[j] = this.coefs[j];
        }
        c[this.coefs.length - 1] = V0;
        this.coefs = c;
        boolean[] b = new boolean[c.length - 1];
        for (int j = 0; j < b.length; ++j) {
            b[j] = this.StandardChoice[j];
        }
        this.StandardChoice = b;
    }

    public void synthesize(Filter filtreprimaire, int jmax) {
        if (jmax < 0 || jmax > this.coefs.length - 1) {
            throw new IllegalArgumentException("The integer parameter " + jmax + " must be between 0 and " + (this.coefs.length - 1));
        }
        for (int j = 0; j < jmax; ++j) {
            this.synthesize(filtreprimaire);
        }
    }

    public void synthesizeAll(Filter filtreprimaire) {
        this.synthesize(filtreprimaire, this.coefs.length - 1);
    }

    public Signal rebuildSignal(Filter filtreprimaire) {
        FWTCoef fwt = new FWTCoef(this.coefs);
        fwt.synthesizeAll(filtreprimaire);
        return new Signal(fwt.getCoefs()[0]);
    }

    public Signal rebuildSignal(Filter filtreprimaire, double[] param) {
        FWTCoef fwt = new FWTCoef(this.coefs);
        fwt.synthesizeAll(filtreprimaire, param);
        return new Signal(fwt.getCoefs()[0]);
    }

    public void denoise(double p) {
        for (int k = 1; k < this.coefs.length; ++k) {
            this.coefs[k] = FWTPacketCoef.denoise(this.coefs[k], p);
        }
    }

    public void denoise(double p, int k) {
        this.coefs[k] = FWTPacketCoef.denoise(this.coefs[k], p);
    }

    public static double[] denoise(double[] v, double p) {
        if (p == 0.0) {
            return v;
        }
        double[] ans = v;
        double seuil = ArrayMath.percentile(ArrayMath.abs(ans), 1.0 - p);
        for (int k = 0; k < ans.length; ++k) {
            if (!(Math.abs(ans[k]) >= seuil)) continue;
            ans[k] = 0.0;
        }
        return ans;
    }

    public void compress(double p) {
        for (int k = 0; k < this.coefs.length; ++k) {
            this.coefs[k] = FWTPacketCoef.compress(this.coefs[k], p);
        }
    }

    public void compress(double p, int k) {
        this.coefs[k] = FWTPacketCoef.compress(this.coefs[k], p);
    }

    public static double[] compress(double[] v, double p) {
        if (p == 0.0) {
            return v;
        }
        double[] ans = v;
        double seuil = ArrayMath.percentile(ArrayMath.abs(ans), p);
        for (int k = 0; k < ans.length; ++k) {
            if (!(Math.abs(ans[k]) <= seuil)) continue;
            ans[k] = 0.0;
        }
        return ans;
    }

    public void denoiseHard(double p) {
        for (int k = 0; k < this.coefs.length; ++k) {
            this.coefs[k] = FWTPacketCoef.denoiseHard(this.coefs[k], p);
        }
    }

    public void denoiseHard(double p, int k) {
        this.coefs[k] = FWTPacketCoef.denoiseHard(this.coefs[k], p);
    }

    public static double[] denoiseHard(double[] v, double seuil) {
        if (seuil < 0.0) {
            throw new IllegalArgumentException("The cutoff value must be positive.");
        }
        double[] ans = v;
        for (int k = 0; k < ans.length; ++k) {
            if (!(Math.abs(ans[k]) >= seuil)) continue;
            ans[k] = 0.0;
        }
        return ans;
    }

    public void compressHard(double p) {
        for (int k = 0; k < this.coefs.length; ++k) {
            this.coefs[k] = FWTPacketCoef.compressHard(this.coefs[k], p);
        }
    }

    public void compressHard(double p, int k) {
        this.coefs[k] = FWTPacketCoef.compressHard(this.coefs[k], p);
    }

    public static double[] compressHard(double[] v, double seuil) {
        if (seuil < 0.0) {
            throw new IllegalArgumentException("The cutoff value must be positive.");
        }
        double[] ans = v;
        for (int k = 0; k < ans.length; ++k) {
            if (!(Math.abs(ans[k]) <= seuil)) continue;
            ans[k] = 0.0;
        }
        return ans;
    }
}

