/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet;

import jsci.maths.ArrayMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Cosine;
import jsci.maths.wavelet.DiscreteFunction;
import jsci.maths.wavelet.DiscreteHilbertSpace;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.Multiresolution;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.Sine;
import jsci.maths.wavelet.SparseDiscreteFunction;

public class BasisFunctionLibrary
implements Cloneable {
    private double MorseThreshold = 0.5;
    protected DiscreteFunction[] Fprimary;
    protected DiscreteFunction[] Fdual;
    protected DiscreteFunction DFunction;

    public Object clone() {
        try {
            BasisFunctionLibrary c = (BasisFunctionLibrary)super.clone();
            c.MorseThreshold = this.MorseThreshold;
            c.DFunction = (DiscreteFunction)this.DFunction.clone();
            c.Fprimary = BasisFunctionLibrary.cloneArrayDiscreteFunction(this.Fprimary);
            c.Fdual = BasisFunctionLibrary.cloneArrayDiscreteFunction(this.Fdual);
            return c;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    public void setMorseThreshold(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("The threshold must be between 0 and 1 :" + p);
        }
        this.MorseThreshold = p;
    }

    public double getMorseThreshold() {
        return this.MorseThreshold;
    }

    public void includeFourier() {
        int k = 0;
        while ((double)k <= Math.floor((double)this.DFunction.dimension() / 2.0)) {
            this.add(new Cosine(this.DFunction.dimension(), k));
            ++k;
        }
        k = 1;
        while ((double)k < Math.ceil((double)this.DFunction.dimension() / 2.0)) {
            this.add(new Sine(this.DFunction.dimension(), k));
            ++k;
        }
    }

    public void includeMasslessFourier() {
        int k = 1;
        while ((double)k <= Math.floor((double)this.DFunction.dimension() / 2.0)) {
            this.add(new Cosine(this.DFunction.dimension(), k));
            ++k;
        }
        k = 1;
        while ((double)k < Math.ceil((double)this.DFunction.dimension() / 2.0)) {
            this.add(new Sine(this.DFunction.dimension(), k));
            ++k;
        }
    }

    public DiscreteFunction getPrimary(int k) {
        return this.Fprimary[k];
    }

    public DiscreteFunction getDual(int k) {
        return this.Fdual[k];
    }

    protected BasisFunctionLibrary() {
    }

    public BasisFunctionLibrary(DiscreteFunction f) {
        this.setData(f);
    }

    public void setData(DiscreteFunction f) {
        if (this.DFunction != null && f.dimension() != this.DFunction.dimension()) {
            throw new IllegalArgumentException("You cannot change the dimension of the data object. Please create a new object.");
        }
        this.DFunction = (DiscreteFunction)f.clone();
    }

    public DiscreteFunction getData() {
        return (DiscreteFunction)this.DFunction.clone();
    }

    protected static DiscreteFunction[] cloneArrayDiscreteFunction(MultiscaleFunction[] a) {
        if (a != null) {
            DiscreteFunction[] b = new DiscreteFunction[a.length];
            for (int k = 0; k < a.length; ++k) {
                if (a[k] == null) continue;
                b[k] = (DiscreteFunction)a[k].clone();
            }
            return b;
        }
        return null;
    }

    private DiscreteFunction toDiscreteFunction(MultiscaleFunction f) {
        int j = 0;
        while (f.dimension(j) < this.DFunction.dimension()) {
            if (++j <= 20) continue;
            throw new IllegalScalingException("Could not match the added object with internal data object in 20 iterations.");
        }
        if (f.dimension(j) != this.DFunction.dimension()) {
            throw new IllegalScalingException("Could not match the added object with internal data object.");
        }
        double[] eval = ArrayMath.scalarMultiply(1.0 / Math.sqrt(Cascades.PowerOf2(j)), f.evaluate(j));
        int nonzero = 0;
        for (int k = 0; k < eval.length; ++k) {
            if (eval[k] == 0.0) continue;
            ++nonzero;
        }
        if ((double)nonzero > this.MorseThreshold * (double)eval.length) {
            return new DiscreteFunction(eval);
        }
        return new SparseDiscreteFunction(eval);
    }

    public void add(MultiscaleFunction fprimary, MultiscaleFunction fdual) {
        DiscreteFunction[] backup;
        if (fprimary == null || fdual == null) {
            throw new NullPointerException("You cannot add a null object to the internal arrays.");
        }
        if (this.Fprimary != null) {
            backup = this.Fprimary;
            this.Fprimary = new DiscreteFunction[backup.length + 1];
            System.arraycopy(backup, 0, this.Fprimary, 0, backup.length);
            this.Fprimary[backup.length] = this.toDiscreteFunction((MultiscaleFunction)fprimary.clone());
        } else {
            this.Fprimary = new DiscreteFunction[1];
            this.Fprimary[0] = this.toDiscreteFunction((MultiscaleFunction)fprimary.clone());
        }
        if (this.Fdual != null) {
            backup = this.Fdual;
            this.Fdual = new DiscreteFunction[backup.length + 1];
            System.arraycopy(backup, 0, this.Fdual, 0, backup.length);
            this.Fdual[backup.length] = this.toDiscreteFunction((MultiscaleFunction)fdual.clone());
        } else {
            this.Fdual = new DiscreteFunction[1];
            this.Fdual[0] = this.toDiscreteFunction((MultiscaleFunction)fdual.clone());
        }
    }

    public void add(MultiscaleFunction f) {
        this.add(f, f);
    }

    public void add(MultiscaleFunction[] f) {
        for (int k = 0; k < f.length; ++k) {
            this.add(f[k], f[k]);
        }
    }

    public void add(Multiresolution mr) {
        int n = this.DFunction.dimension();
        try {
            block2: while (true) {
                int k;
                n = mr.previousDimension(n);
                for (k = 0; k < n; ++k) {
                    this.add(mr.primaryScaling(n, k), mr.dualScaling(n, k));
                }
                k = 0;
                while (true) {
                    if (k >= n - mr.getFilterType()) continue block2;
                    this.add(mr.primaryWavelet(n, k), mr.dualWavelet(n, k));
                    ++k;
                }
                break;
            }
        }
        catch (IllegalScalingException illegalScalingException) {
            return;
        }
    }

    public double[] getResidues() {
        double[] coef = this.getWeigths();
        double[] ans = new double[coef.length];
        for (int k = 0; k < ans.length; ++k) {
            ans[k] = ArrayMath.norm(DiscreteHilbertSpace.add(this.DFunction, -coef[k], this.Fprimary[k]));
        }
        return ans;
    }

    public double getResidue(int k) {
        return ArrayMath.norm(DiscreteHilbertSpace.add(this.DFunction, -this.getWeigth(k), this.Fprimary[k]));
    }

    public double[] getWeigths() {
        double[] ans = new double[this.getSize()];
        for (int k = 0; k < this.getSize(); ++k) {
            ans[k] = DiscreteHilbertSpace.integrate(this.DFunction, this.Fdual[k]);
        }
        return ans;
    }

    public double getWeigth(int k) {
        return DiscreteHilbertSpace.integrate(this.DFunction, this.Fdual[k]);
    }

    public double norm() {
        return ArrayMath.norm(this.DFunction.evaluate(0));
    }

    public int getSize() {
        if (this.Fprimary == null) {
            return 0;
        }
        return this.Fprimary.length;
    }

    protected static double norm(double a, double b) {
        return Math.sqrt(a * a + b * b);
    }

    private double[][] scalarMultiply(double[][] v, double a) {
        double[][] ans = new double[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = new double[v[k].length];
            for (int l = 0; l < v[k].length; ++l) {
                ans[k][l] = a * v[k][l];
            }
        }
        return ans;
    }

    public double[] checkBiorthogonality() {
        double[] ans = new double[this.getSize()];
        for (int k = 0; k < this.getSize(); ++k) {
            ans[k] = DiscreteHilbertSpace.integrate(this.Fprimary[k], this.Fdual[k]);
        }
        return ans;
    }

    protected static double[][] add(double[][] v, double[][] w) {
        if (v.length != w.length) {
            throw new IllegalArgumentException("Incompatible types " + v.length + ", " + w.length);
        }
        double[][] ans = new double[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = new double[v[k].length];
            if (v[k].length != w[k].length) {
                throw new IllegalArgumentException("Incompatible types " + v.length + ", " + w.length + " : " + v[k].length + ", " + w[k].length);
            }
            for (int l = 0; l < v[k].length; ++l) {
                ans[k][l] = v[k][l] + w[k][l];
            }
        }
        return ans;
    }
}

