/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.maths.ExtraMath;
import jsci.maths.Mapping;
import jsci.maths.MathDouble;
import jsci.maths.MathInteger;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.ComplexVector;
import jsci.maths.vectors.IntegerVector;
import jsci.maths.vectors.VectorDimensionException;

public class DoubleVector
extends AbstractDoubleVector {
    protected double[] vector;

    public DoubleVector(int dim) {
        super(dim);
        this.vector = new double[dim];
    }

    public DoubleVector(double[] array) {
        super(array.length);
        this.vector = array;
    }

    @Override
    public boolean equals(Object a, double tol) {
        if (a != null && a instanceof AbstractDoubleVector && this.N == ((AbstractDoubleVector)a).N) {
            AbstractDoubleVector dv = (AbstractDoubleVector)a;
            double sumSqr = 0.0;
            for (int i = 0; i < this.N; ++i) {
                double delta = this.vector[i] - dv.getComponent(i);
                sumSqr += delta * delta;
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(8 * this.N);
        for (i = 0; i < this.N - 1; ++i) {
            buf.append(this.vector[i]);
            buf.append(',');
        }
        buf.append(this.vector[i]);
        return buf.toString();
    }

    public AbstractIntegerVector toIntegerVector() {
        int[] array = new int[this.N];
        for (int i = 0; i < this.N; ++i) {
            array[i] = Math.round((float)this.vector[i]);
        }
        return new IntegerVector(array);
    }

    public AbstractComplexVector toComplexVector() {
        return new ComplexVector(this.vector, new double[this.N]);
    }

    @Override
    public double getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vector[n];
        }
        throw new VectorDimensionException(DoubleVector.getInvalidComponentMsg(n));
    }

    @Override
    public void setComponent(int n, double x) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(DoubleVector.getInvalidComponentMsg(n));
        }
        this.vector[n] = x;
    }

    @Override
    public double norm(int n) {
        double answer = Math.pow(Math.abs(this.vector[0]), n);
        for (int i = 1; i < this.N; ++i) {
            answer += Math.pow(Math.abs(this.vector[i]), n);
        }
        return Math.pow(answer, 1.0 / (double)n);
    }

    @Override
    public double norm() {
        double answer = this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            answer = ExtraMath.hypot(answer, this.vector[i]);
        }
        return answer;
    }

    @Override
    public double infNorm() {
        double infNorm = Math.abs(this.vector[0]);
        for (int i = 1; i < this.N; ++i) {
            double abs = Math.abs(this.vector[i]);
            if (!(abs > infNorm)) continue;
            infNorm = abs;
        }
        return infNorm;
    }

    @Override
    public AbelianGroup.Member negate() {
        double[] array = new double[this.N];
        array[0] = -this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            array[i] = -this.vector[i];
        }
        return new DoubleVector(array);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member v) {
        if (v instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)v);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector add(AbstractDoubleVector v) {
        if (v instanceof DoubleVector) {
            return this.add((DoubleVector)v);
        }
        if (this.N == v.N) {
            double[] array = new double[this.N];
            array[0] = this.vector[0] + v.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                array[i] = this.vector[i] + v.getComponent(i);
            }
            return new DoubleVector(array);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public DoubleVector add(DoubleVector v) {
        if (this.N == v.N) {
            double[] array = new double[this.N];
            array[0] = this.vector[0] + v.vector[0];
            for (int i = 1; i < this.N; ++i) {
                array[i] = this.vector[i] + v.vector[i];
            }
            return new DoubleVector(array);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member v) {
        if (v instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)v);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector subtract(AbstractDoubleVector v) {
        if (v instanceof DoubleVector) {
            return this.subtract((DoubleVector)v);
        }
        if (this.N == v.N) {
            double[] array = new double[this.N];
            array[0] = this.vector[0] - v.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                array[i] = this.vector[i] - v.getComponent(i);
            }
            return new DoubleVector(array);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public DoubleVector subtract(DoubleVector v) {
        if (this.N == v.N) {
            double[] array = new double[this.N];
            array[0] = this.vector[0] - v.vector[0];
            for (int i = 1; i < this.N; ++i) {
                array[i] = this.vector[i] - v.vector[i];
            }
            return new DoubleVector(array);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector scalarMultiply(double x) {
        double[] array = new double[this.N];
        array[0] = x * this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            array[i] = x * this.vector[i];
        }
        return new DoubleVector(array);
    }

    @Override
    public VectorSpace.Member scalarDivide(Field.Member x) {
        if (x instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector scalarDivide(double x) {
        double[] array = new double[this.N];
        array[0] = this.vector[0] / x;
        for (int i = 1; i < this.N; ++i) {
            array[i] = this.vector[i] / x;
        }
        return new DoubleVector(array);
    }

    @Override
    public double scalarProduct(AbstractDoubleVector v) {
        if (v instanceof DoubleVector) {
            return this.scalarProduct((DoubleVector)v);
        }
        if (this.N == v.N) {
            double answer = this.vector[0] * v.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                answer += this.vector[i] * v.getComponent(i);
            }
            return answer;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public double scalarProduct(DoubleVector v) {
        if (this.N == v.N) {
            double answer = this.vector[0] * v.vector[0];
            for (int i = 1; i < this.N; ++i) {
                answer += this.vector[i] * v.vector[i];
            }
            return answer;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbstractDoubleVector mapComponents(Mapping f) {
        double[] array = new double[this.N];
        array[0] = f.map(this.vector[0]);
        for (int i = 1; i < this.N; ++i) {
            array[i] = f.map(this.vector[i]);
        }
        return new DoubleVector(array);
    }
}

