/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.GlobalSettings;
import jsci.maths.Mapping;
import jsci.maths.MathDouble;
import jsci.maths.MathInteger;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.DoubleSparseMatrix;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;
import jsci.maths.vectors.VectorDimensionException;

public final class DoubleSparseVector
extends AbstractDoubleVector {
    private double[] vector;
    private int[] pos;

    public DoubleSparseVector(int dim) {
        super(dim);
        this.vector = new double[0];
        this.pos = new int[0];
    }

    public DoubleSparseVector(double[] array) {
        super(array.length);
        int i;
        int n = 0;
        for (i = 0; i < this.N; ++i) {
            if (array[i] == 0.0) continue;
            ++n;
        }
        this.vector = new double[n];
        this.pos = new int[n];
        n = 0;
        for (i = 0; i < this.N; ++i) {
            if (array[i] == 0.0) continue;
            this.vector[n] = array[i];
            this.pos[n] = i;
            ++n;
        }
    }

    @Override
    public boolean equals(Object obj, double tol) {
        if (obj != null && obj instanceof DoubleSparseVector && this.N == ((DoubleSparseVector)obj).N) {
            DoubleSparseVector v = (DoubleSparseVector)obj;
            if (this.pos.length != v.pos.length) {
                return false;
            }
            double sumSqr = 0.0;
            for (int i = 0; i < this.pos.length; ++i) {
                if (this.pos[i] != v.pos[i]) {
                    return false;
                }
                double delta = this.vector[i] - v.vector[i];
                sumSqr += delta * delta;
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public double getComponent(int n) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(DoubleSparseVector.getInvalidComponentMsg(n));
        }
        for (int k = 0; k < this.pos.length; ++k) {
            if (this.pos[k] != n) continue;
            return this.vector[k];
        }
        return 0.0;
    }

    @Override
    public void setComponent(int n, double x) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(DoubleSparseVector.getInvalidComponentMsg(n));
        }
        if (Math.abs(x) <= GlobalSettings.ZERO_TOL) {
            return;
        }
        for (int k = 0; k < this.pos.length; ++k) {
            if (n != this.pos[k]) continue;
            this.vector[k] = x;
            return;
        }
        int[] newPos = new int[this.pos.length + 1];
        double[] newVector = new double[this.vector.length + 1];
        System.arraycopy(this.pos, 0, newPos, 0, this.pos.length);
        System.arraycopy(this.vector, 0, newVector, 0, this.pos.length);
        newPos[this.pos.length] = n;
        newVector[this.vector.length] = x;
        this.pos = newPos;
        this.vector = newVector;
    }

    @Override
    public double norm() {
        return Math.sqrt(this.sumSquares());
    }

    public double sumSquares() {
        double norm = 0.0;
        for (int k = 0; k < this.pos.length; ++k) {
            norm += this.vector[k] * this.vector[k];
        }
        return norm;
    }

    @Override
    public double mass() {
        double mass = 0.0;
        for (int k = 0; k < this.pos.length; ++k) {
            mass += this.vector[k];
        }
        return mass;
    }

    @Override
    public AbelianGroup.Member negate() {
        DoubleSparseVector ans = new DoubleSparseVector(this.N);
        ans.vector = new double[this.vector.length];
        ans.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, ans.pos, 0, this.pos.length);
        for (int i = 0; i < this.pos.length; ++i) {
            ans.vector[i] = -this.vector[i];
        }
        return ans;
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member v) {
        if (v instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)v);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector add(AbstractDoubleVector v) {
        int i;
        if (v instanceof DoubleSparseVector) {
            return this.add((DoubleSparseVector)v);
        }
        if (v instanceof DoubleVector) {
            return this.add((DoubleVector)v);
        }
        if (this.N != v.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] array = new double[this.N];
        array[0] = v.getComponent(0);
        for (i = 1; i < this.N; ++i) {
            array[i] = v.getComponent(i);
        }
        for (i = 0; i < this.pos.length; ++i) {
            int n = this.pos[i];
            array[n] = array[n] + this.vector[i];
        }
        return new DoubleVector(array);
    }

    public DoubleVector add(DoubleVector v) {
        if (this.N != v.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] array = new double[this.N];
        System.arraycopy(v.vector, 0, array, 0, this.N);
        for (int i = 0; i < this.pos.length; ++i) {
            int n = this.pos[i];
            array[n] = array[n] + this.vector[i];
        }
        return new DoubleVector(array);
    }

    public DoubleSparseVector add(DoubleSparseVector v) {
        if (this.N != v.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] array = new double[this.N];
        for (int i = 0; i < this.pos.length; ++i) {
            array[this.pos[i]] = this.vector[i] + v.getComponent(this.pos[i]);
        }
        for (int i = 0; i < v.pos.length; ++i) {
            int m = v.pos[i];
            array[m] = this.getComponent(m) + v.vector[i];
        }
        return new DoubleSparseVector(array);
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member v) {
        if (v instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)v);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector subtract(AbstractDoubleVector v) {
        int i;
        if (v instanceof DoubleSparseVector) {
            return this.subtract((DoubleSparseVector)v);
        }
        if (v instanceof DoubleVector) {
            return this.subtract((DoubleVector)v);
        }
        if (this.N != v.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] array = new double[this.N];
        array[0] = -v.getComponent(0);
        for (i = 1; i < this.N; ++i) {
            array[i] = -v.getComponent(i);
        }
        for (i = 0; i < this.pos.length; ++i) {
            int n = this.pos[i];
            array[n] = array[n] + this.vector[i];
        }
        return new DoubleVector(array);
    }

    public DoubleVector subtract(DoubleVector v) {
        int i;
        if (this.N != v.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] array = new double[this.N];
        array[0] = -v.vector[0];
        for (i = 1; i < this.N; ++i) {
            array[i] = -v.vector[i];
        }
        for (i = 0; i < this.pos.length; ++i) {
            int n = this.pos[i];
            array[n] = array[n] + this.vector[i];
        }
        return new DoubleVector(array);
    }

    public DoubleSparseVector subtract(DoubleSparseVector v) {
        if (this.N != v.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] array = new double[this.N];
        for (int i = 0; i < this.pos.length; ++i) {
            array[this.pos[i]] = this.vector[i] - v.getComponent(this.pos[i]);
        }
        for (int i = 0; i < v.pos.length; ++i) {
            int m = v.pos[i];
            array[m] = this.getComponent(m) - v.vector[i];
        }
        return new DoubleSparseVector(array);
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector scalarMultiply(double x) {
        DoubleSparseVector ans = new DoubleSparseVector(this.N);
        ans.vector = new double[this.vector.length];
        ans.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, ans.pos, 0, this.pos.length);
        for (int i = 0; i < this.pos.length; ++i) {
            ans.vector[i] = x * this.vector[i];
        }
        return ans;
    }

    @Override
    public VectorSpace.Member scalarDivide(Field.Member x) {
        if (x instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector scalarDivide(double x) {
        DoubleSparseVector ans = new DoubleSparseVector(this.N);
        ans.vector = new double[this.vector.length];
        ans.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, ans.pos, 0, this.pos.length);
        for (int i = 0; i < this.pos.length; ++i) {
            ans.vector[i] = this.vector[i] / x;
        }
        return ans;
    }

    @Override
    public double scalarProduct(AbstractDoubleVector v) {
        if (v instanceof DoubleSparseVector) {
            return this.scalarProduct((DoubleSparseVector)v);
        }
        if (v instanceof DoubleVector) {
            return this.scalarProduct((DoubleVector)v);
        }
        if (this.N != v.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double ps = 0.0;
        for (int i = 0; i < this.pos.length; ++i) {
            ps += this.vector[i] * v.getComponent(this.pos[i]);
        }
        return ps;
    }

    public double scalarProduct(DoubleVector v) {
        if (this.N != v.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double ps = 0.0;
        for (int i = 0; i < this.pos.length; ++i) {
            ps += this.vector[i] * v.vector[this.pos[i]];
        }
        return ps;
    }

    public double scalarProduct(DoubleSparseVector v) {
        if (this.N != v.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double ps = 0.0;
        if (this.pos.length <= v.pos.length) {
            for (int i = 0; i < this.pos.length; ++i) {
                ps += this.vector[i] * v.getComponent(this.pos[i]);
            }
        } else {
            for (int i = 0; i < v.pos.length; ++i) {
                ps += this.getComponent(v.pos[i]) * v.vector[i];
            }
        }
        return ps;
    }

    public DoubleSparseMatrix tensorProduct(DoubleSparseVector v) {
        DoubleSparseMatrix ans = new DoubleSparseMatrix(this.N, v.N);
        for (int i = 0; i < this.pos.length; ++i) {
            for (int j = 0; j < v.pos.length; ++j) {
                ans.setElement(this.pos[i], v.pos[j], this.vector[i] * v.vector[j]);
            }
        }
        return ans;
    }

    @Override
    public AbstractDoubleVector mapComponents(Mapping f) {
        double zeroValue = f.map(0.0);
        if (Math.abs(zeroValue) <= GlobalSettings.ZERO_TOL) {
            return this.sparseMap(f);
        }
        return this.generalMap(f, zeroValue);
    }

    private AbstractDoubleVector sparseMap(Mapping f) {
        DoubleSparseVector ans = new DoubleSparseVector(this.N);
        ans.vector = new double[this.vector.length];
        ans.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, ans.pos, 0, this.pos.length);
        for (int i = 0; i < this.pos.length; ++i) {
            ans.vector[i] = f.map(this.vector[i]);
        }
        return ans;
    }

    private AbstractDoubleVector generalMap(Mapping f, double zeroValue) {
        int i;
        double[] array = new double[this.N];
        for (i = 0; i < this.N; ++i) {
            array[i] = zeroValue;
        }
        for (i = 0; i < this.pos.length; ++i) {
            array[i] = f.map(this.vector[this.pos[i]]);
        }
        return new DoubleVector(array);
    }
}

