/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.maths.ExtraMath;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;
import jsci.maths.vectors.MathVector;

public abstract class AbstractIntegerVector
extends MathVector {
    protected AbstractIntegerVector(int dim) {
        super(dim);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof AbstractIntegerVector) {
            AbstractIntegerVector vec = (AbstractIntegerVector)obj;
            return this.dimension() == vec.dimension() && this.subtract(vec).norm() == 0.0;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(8 * this.N);
        for (i = 0; i < this.N - 1; ++i) {
            buf.append(this.getComponent(i));
            buf.append(',');
        }
        buf.append(this.getComponent(i));
        return buf.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public AbstractDoubleVector toDoubleVector() {
        double[] array = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            array[i] = this.getComponent(i);
        }
        return new DoubleVector(array);
    }

    public abstract int getComponent(int var1);

    public abstract void setComponent(int var1, int var2);

    @Override
    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    public double norm(int n) {
        double answer = Math.pow(Math.abs(this.getComponent(0)), n);
        for (int i = 1; i < this.N; ++i) {
            answer += Math.pow(Math.abs(this.getComponent(i)), n);
        }
        return Math.pow(answer, 1.0 / (double)n);
    }

    @Override
    public double norm() {
        double answer = this.getComponent(0);
        for (int i = 1; i < this.N; ++i) {
            answer = ExtraMath.hypot(answer, this.getComponent(i));
        }
        return answer;
    }

    public double infNorm() {
        int infNorm = Math.abs(this.getComponent(0));
        for (int i = 1; i < this.N; ++i) {
            int abs = Math.abs(this.getComponent(i));
            if (abs <= infNorm) continue;
            infNorm = abs;
        }
        return infNorm;
    }

    public abstract AbstractIntegerVector add(AbstractIntegerVector var1);

    public abstract AbstractIntegerVector subtract(AbstractIntegerVector var1);

    public abstract AbstractIntegerVector scalarMultiply(int var1);

    public abstract int scalarProduct(AbstractIntegerVector var1);
}

