/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.symbolic;

import jsci.maths.MathDouble;
import jsci.maths.analysis.Exponential;
import jsci.maths.analysis.RealFunction;
import jsci.maths.fields.RealField;
import jsci.maths.symbolic.Constant;
import jsci.maths.symbolic.Expression;
import jsci.maths.symbolic.Variable;

public class Evaluation
extends Expression {
    private final RealFunction fn;
    private final Expression arg;

    public Evaluation(RealFunction n, Expression a) {
        this.fn = n;
        this.arg = a;
    }

    public String toString() {
        return "f<" + this.fn + ">" + "(" + this.arg + ")";
    }

    @Override
    public int getPriority() {
        return 15;
    }

    @Override
    public Expression differentiate(Variable x) {
        return Expression.product(new Evaluation(this.fn.differentiate(), this.arg), this.arg.differentiate(x));
    }

    public boolean equals(Object o) {
        if (!Evaluation.class.isInstance(o)) {
            return false;
        }
        Evaluation f = (Evaluation)o;
        return this.fn.equals(f.fn) && this.arg.equals(f.arg);
    }

    @Override
    public Object getSet() {
        return RealField.getInstance();
    }

    @Override
    public Expression evaluate() {
        Expression sarg = this.arg.evaluate();
        if (sarg instanceof Constant) {
            MathDouble a = (MathDouble)((Constant)sarg).getValue();
            return new Constant(new MathDouble(this.fn.map(a.doubleValue())));
        }
        return new Evaluation(this.fn, sarg);
    }

    public static void main(String[] args) {
        Variable xVar = new Variable("x", RealField.getInstance());
        Evaluation expr = new Evaluation(new Exponential(1.0, 1.0, 0.0), xVar);
        System.out.println("expr = " + expr);
        xVar.setValue(new MathDouble(1.0));
        System.out.println("x = 1");
        System.out.println("expr = " + ((Expression)expr).evaluate());
        xVar.setValue(null);
        System.out.println("d/dx expr = " + ((Expression)expr).differentiate(xVar).evaluate());
    }
}

