/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.polynomials;

import jsci.maths.Complex;
import jsci.maths.fields.Field;
import jsci.maths.polynomials.ComplexPolynomial;
import jsci.maths.polynomials.ComplexPolynomialRing;
import jsci.maths.polynomials.Polynomial;
import jsci.maths.polynomials.PolynomialBasis;

public class ComplexLagrangeBasis
implements PolynomialBasis {
    private ComplexPolynomial[] _basis;
    private Complex[] _samplingsX;
    private int _dim;

    public ComplexLagrangeBasis(Field.Member[] samplings) {
        if (samplings == null) {
            throw new NullPointerException();
        }
        this._dim = samplings.length;
        this._samplingsX = ComplexPolynomialRing.toComplex(samplings);
        this.buildBasis();
    }

    @Override
    public Polynomial getBasisVector(int k) {
        return this._basis[k];
    }

    @Override
    public int dimension() {
        return this._dim;
    }

    @Override
    public Field.Member[] getSamplingPoints() {
        return this._samplingsX;
    }

    @Override
    public Polynomial superposition(Field.Member[] coeff) {
        if (coeff == null) {
            throw new NullPointerException();
        }
        if (coeff.length != this._dim) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        Complex[] d = ComplexPolynomialRing.toComplex(coeff);
        return this.superposition(d);
    }

    public ComplexPolynomial superposition(Complex[] c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.length != this._dim) {
            throw new IllegalArgumentException("Dimension of basis is " + this._dim + ". Got " + c.length + " coefficients");
        }
        ComplexPolynomial rp = (ComplexPolynomial)ComplexPolynomialRing.getInstance().zero();
        for (int k = 0; k < this._dim; ++k) {
            ComplexPolynomial b = (ComplexPolynomial)this.getBasisVector(k);
            ComplexPolynomial ba = b.scalarMultiply(c[k]);
            rp = (ComplexPolynomial)rp.add(ba);
        }
        return rp;
    }

    private void buildBasis() {
        this._basis = new ComplexPolynomial[this._dim];
        for (int k = 0; k < this._dim; ++k) {
            this._basis[k] = (ComplexPolynomial)ComplexPolynomialRing.getInstance().one();
            Complex fac = Complex.ONE;
            for (int j = 0; j < this._dim; ++j) {
                if (j == k) continue;
                ComplexPolynomial n = new ComplexPolynomial(new Complex[]{(Complex)this._samplingsX[j].negate(), Complex.ONE});
                this._basis[k] = (ComplexPolynomial)this._basis[k].multiply(n);
                Complex a = this._samplingsX[k];
                Complex b = this._samplingsX[j];
                Complex dif = a.subtract(b);
                fac = fac.multiply(dif);
            }
            this._basis[k] = this._basis[k].scalarDivide(fac);
        }
    }
}

