/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.maths.ArrayMath;
import jsci.maths.DimensionException;
import jsci.maths.ExtraMath;
import jsci.maths.LinearMath;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractDoubleSquareMatrix;
import jsci.maths.matrices.AbstractIntegerMatrix;
import jsci.maths.matrices.AbstractIntegerSquareMatrix;
import jsci.maths.matrices.ComplexTridiagonalMatrix;
import jsci.maths.matrices.DoubleDiagonalMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.DoubleTridiagonalMatrix;
import jsci.maths.matrices.IntegerSquareMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.matrices.TridiagonalMatrix;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.IntegerVector;

public class IntegerTridiagonalMatrix
extends AbstractIntegerSquareMatrix
implements TridiagonalMatrix {
    protected final int[] ldiag;
    protected final int[] diag;
    protected final int[] udiag;

    public IntegerTridiagonalMatrix(int size) {
        super(size);
        this.ldiag = new int[size];
        this.diag = new int[size];
        this.udiag = new int[size];
    }

    public IntegerTridiagonalMatrix(int[][] array) {
        this(array.length);
        int i;
        if (!ArrayMath.isSquare(array)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.diag[0] = array[0][0];
        this.udiag[0] = array[0][1];
        for (i = 1; i < array.length - 1; ++i) {
            this.ldiag[i] = array[i][i - 1];
            this.diag[i] = array[i][i];
            this.udiag[i] = array[i][i + 1];
        }
        this.ldiag[i] = array[i][i - 1];
        this.diag[i] = array[i][i];
    }

    @Override
    public boolean equals(AbstractIntegerMatrix m, double tol) {
        if (m instanceof TridiagonalMatrix) {
            int ldelta;
            int i;
            if (this.numRows != m.rows() || this.numCols != m.columns()) {
                return false;
            }
            int sumSqr = 0;
            int delta = this.diag[0] - m.getElement(0, 0);
            int udelta = this.udiag[0] - m.getElement(0, 1);
            sumSqr += delta * delta + udelta * udelta;
            for (i = 1; i < this.numRows - 1; ++i) {
                ldelta = this.ldiag[i] - m.getElement(i, i - 1);
                delta = this.diag[i] - m.getElement(i, i);
                udelta = this.udiag[i] - m.getElement(i, i + 1);
                sumSqr += ldelta * ldelta + delta * delta + udelta * udelta;
            }
            ldelta = this.ldiag[i] - m.getElement(i, i - 1);
            return (double)(sumSqr += ldelta * ldelta + (delta = this.diag[i] - m.getElement(i, i)) * delta) <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.getElement(i, j));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public AbstractDoubleMatrix toDoubleMatrix() {
        int i;
        DoubleTridiagonalMatrix m = new DoubleTridiagonalMatrix(this.numRows);
        m.diag[0] = this.diag[0];
        m.udiag[0] = this.udiag[0];
        for (i = 1; i < this.numRows - 1; ++i) {
            m.ldiag[i] = this.ldiag[i];
            m.diag[i] = this.diag[i];
            m.udiag[i] = this.udiag[i];
        }
        m.ldiag[i] = this.ldiag[i];
        m.diag[i] = this.diag[i];
        return m;
    }

    @Override
    public AbstractComplexMatrix toComplexMatrix() {
        int i;
        ComplexTridiagonalMatrix m = new ComplexTridiagonalMatrix(this.numRows);
        m.diagRe[0] = this.diag[0];
        m.udiagRe[0] = this.udiag[0];
        for (i = 1; i < this.numRows - 1; ++i) {
            m.ldiagRe[i] = this.ldiag[i];
            m.diagRe[i] = this.diag[i];
            m.udiagRe[i] = this.udiag[i];
        }
        m.ldiagRe[i] = this.ldiag[i];
        m.diagRe[i] = this.diag[i];
        return m;
    }

    @Override
    public int getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (j == i - 1) {
                return this.ldiag[i];
            }
            if (j == i) {
                return this.diag[i];
            }
            if (j == i + 1) {
                return this.udiag[i];
            }
            return 0;
        }
        throw new MatrixDimensionException(IntegerTridiagonalMatrix.getInvalidElementMsg(i, j));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setElement(int i, int j, int x) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) throw new MatrixDimensionException(IntegerTridiagonalMatrix.getInvalidElementMsg(i, j));
        if (j == i - 1) {
            this.ldiag[i] = x;
            return;
        } else if (j == i) {
            this.diag[i] = x;
            return;
        } else {
            if (j != i + 1) throw new MatrixDimensionException(IntegerTridiagonalMatrix.getInvalidElementMsg(i, j));
            this.udiag[i] = x;
        }
    }

    @Override
    public boolean isSymmetric() {
        if (this.ldiag[1] != this.udiag[0]) {
            return false;
        }
        for (int i = 1; i < this.numRows - 1; ++i) {
            if (this.ldiag[i + 1] == this.udiag[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int trace() {
        int tr = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            tr += this.diag[i];
        }
        return tr;
    }

    @Override
    public int infNorm() {
        int tmpResult;
        int i;
        int result = Math.abs(this.diag[0]) + Math.abs(this.udiag[0]);
        for (i = 1; i < this.numRows - 1; ++i) {
            tmpResult = Math.abs(this.ldiag[i]) + Math.abs(this.diag[i]) + Math.abs(this.udiag[i]);
            if (tmpResult <= result) continue;
            result = tmpResult;
        }
        tmpResult = Math.abs(this.ldiag[i]) + Math.abs(this.diag[i]);
        if (tmpResult > result) {
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        int i;
        double result = this.diag[0] * this.diag[0] + this.udiag[0] * this.udiag[0];
        for (i = 1; i < this.numRows - 1; ++i) {
            result += (double)(this.ldiag[i] * this.ldiag[i] + this.diag[i] * this.diag[i] + this.udiag[i] * this.udiag[i]);
        }
        return Math.sqrt(result += (double)(this.ldiag[i] * this.ldiag[i] + this.diag[i] * this.diag[i]));
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveSymmetric((DoubleTridiagonalMatrix)this.transpose().multiply(this))));
    }

    @Override
    public AbstractIntegerSquareMatrix add(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerTridiagonalMatrix) {
            return this.add((IntegerTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.addTridiagonal(m);
        }
        if (m instanceof IntegerSquareMatrix) {
            return this.add((IntegerSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.getElement(i, 0) + m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.getElement(i, j) + m.getElement(i, j);
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                System.arraycopy(m.matrix[i], 0, array[i], 0, this.numRows);
            }
            int[] nArray = array[0];
            nArray[0] = nArray[0] + this.diag[0];
            int[] nArray2 = array[0];
            nArray2[1] = nArray2[1] + this.udiag[0];
            int n = this.numRows - 1;
            for (int i = 1; i < n; ++i) {
                int[] nArray3 = array[i];
                int n2 = i - 1;
                nArray3[n2] = nArray3[n2] + this.ldiag[i];
                int[] nArray4 = array[i];
                int n3 = i;
                nArray4[n3] = nArray4[n3] + this.diag[i];
                int[] nArray5 = array[i];
                int n4 = i + 1;
                nArray5[n4] = nArray5[n4] + this.udiag[i];
            }
            int[] nArray6 = array[n];
            int n5 = n - 1;
            nArray6[n5] = nArray6[n5] + this.ldiag[n];
            int[] nArray7 = array[n];
            int n6 = n;
            nArray7[n6] = nArray7[n6] + this.diag[n];
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix add(IntegerTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.numRows) {
            IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] + m.diag[0];
            ans.udiag[0] = this.udiag[0] + m.udiag[0];
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = this.ldiag[i] + m.ldiag[i];
                ans.diag[i] = this.diag[i] + m.diag[i];
                ans.udiag[i] = this.udiag[i] + m.udiag[i];
            }
            ans.ldiag[mRow] = this.ldiag[mRow] + m.ldiag[mRow];
            ans.diag[mRow] = this.diag[mRow] + m.diag[mRow];
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix addTridiagonal(AbstractIntegerSquareMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.rows()) {
            IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] + m.getElement(0, 0);
            ans.udiag[0] = this.udiag[0] + m.getElement(0, 1);
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = this.ldiag[i] + m.getElement(i, i - 1);
                ans.diag[i] = this.diag[i] + m.getElement(i, i);
                ans.udiag[i] = this.udiag[i] + m.getElement(i, i + 1);
            }
            ans.ldiag[mRow] = this.ldiag[mRow] + m.getElement(mRow, mRow - 1);
            ans.diag[mRow] = this.diag[mRow] + m.getElement(mRow, mRow);
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerSquareMatrix subtract(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerTridiagonalMatrix) {
            return this.subtract((IntegerTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(m);
        }
        if (m instanceof IntegerSquareMatrix) {
            return this.subtract((IntegerSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.getElement(i, 0) - m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.getElement(i, j) - m.getElement(i, j);
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.getElement(i, 0) - m.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.getElement(i, j) - m.matrix[i][j];
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix subtract(IntegerTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.numRows) {
            IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] - m.diag[0];
            ans.udiag[0] = this.udiag[0] - m.udiag[0];
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = this.ldiag[i] - m.ldiag[i];
                ans.diag[i] = this.diag[i] - m.diag[i];
                ans.udiag[i] = this.udiag[i] - m.udiag[i];
            }
            ans.ldiag[mRow] = this.ldiag[mRow] - m.ldiag[mRow];
            ans.diag[mRow] = this.diag[mRow] - m.diag[mRow];
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix subtractTridiagonal(AbstractIntegerSquareMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.rows()) {
            IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] - m.getElement(0, 0);
            ans.udiag[0] = this.udiag[0] - m.getElement(0, 1);
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = this.ldiag[i] - m.getElement(i, i - 1);
                ans.diag[i] = this.diag[i] - m.getElement(i, i);
                ans.udiag[i] = this.udiag[i] - m.getElement(i, i + 1);
            }
            ans.ldiag[mRow] = this.ldiag[mRow] - m.getElement(mRow, mRow - 1);
            ans.diag[mRow] = this.diag[mRow] - m.getElement(mRow, mRow);
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerMatrix scalarMultiply(int x) {
        IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(this.numRows);
        int lastRow = this.numRows - 1;
        ans.diag[0] = x * this.diag[0];
        ans.udiag[0] = x * this.udiag[0];
        for (int i = 1; i < lastRow; ++i) {
            ans.ldiag[i] = x * this.ldiag[i];
            ans.diag[i] = x * this.diag[i];
            ans.udiag[i] = x * this.udiag[i];
        }
        ans.ldiag[lastRow] = x * this.ldiag[lastRow];
        ans.diag[lastRow] = x * this.diag[lastRow];
        return ans;
    }

    @Override
    public int scalarProduct(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerTridiagonalMatrix) {
            return this.scalarProduct((IntegerTridiagonalMatrix)m);
        }
        if (m instanceof IntegerSquareMatrix) {
            return this.scalarProduct((IntegerSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int ans = this.diag[0] * m.getElement(0, 0) + this.udiag[0] * m.getElement(0, 1);
            int lastRow = this.numRows - 1;
            for (int i = 1; i < lastRow; ++i) {
                ans += this.ldiag[i] * m.getElement(i, i - 1) + this.diag[i] * m.getElement(i, i) + this.udiag[i] * m.getElement(i, i + 1);
            }
            return ans += this.ldiag[lastRow] * m.getElement(lastRow, lastRow - 1) + this.diag[lastRow] * m.getElement(lastRow, lastRow);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int ans = this.diag[0] * m.matrix[0][0] + this.udiag[0] * m.matrix[0][1];
            int lastRow = this.numRows - 1;
            for (int i = 1; i < lastRow; ++i) {
                ans += this.ldiag[i] * m.matrix[i][i - 1] + this.diag[i] * m.matrix[i][i] + this.udiag[i] * m.matrix[i][i + 1];
            }
            return ans += this.ldiag[lastRow] * m.matrix[lastRow][lastRow - 1] + this.diag[lastRow] * m.matrix[lastRow][lastRow];
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerTridiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            int ans = this.diag[0] * m.diag[0] + this.udiag[0] * m.udiag[0];
            int lastRow = this.numRows - 1;
            for (int i = 1; i < lastRow; ++i) {
                ans += this.ldiag[i] * m.ldiag[i] + this.diag[i] * m.diag[i] + this.udiag[i] * m.udiag[i];
            }
            return ans += this.ldiag[lastRow] * m.ldiag[lastRow] + this.diag[lastRow] * m.diag[lastRow];
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerVector multiply(AbstractIntegerVector v) {
        if (this.numCols == v.dimension()) {
            int[] array = new int[this.numRows];
            int lastRow = this.numRows - 1;
            array[0] = this.diag[0] * v.getComponent(0) + this.udiag[0] * v.getComponent(1);
            for (int i = 1; i < lastRow; ++i) {
                array[i] = this.ldiag[i] * v.getComponent(i - 1) + this.diag[i] * v.getComponent(i) + this.udiag[i] * v.getComponent(i + 1);
            }
            array[lastRow] = this.ldiag[lastRow] * v.getComponent(lastRow - 1) + this.diag[lastRow] * v.getComponent(lastRow);
            return new IntegerVector(array);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractIntegerSquareMatrix multiply(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerTridiagonalMatrix) {
            return this.multiply((IntegerTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(m);
        }
        if (m instanceof IntegerSquareMatrix) {
            return this.multiply((IntegerSquareMatrix)m);
        }
        if (this.numCols == m.rows()) {
            int mColumns = m.columns();
            int[][] array = new int[this.numRows][mColumns];
            int lastRow = this.numRows - 1;
            for (int j = 0; j < this.numRows; ++j) {
                array[0][j] = this.diag[0] * m.getElement(0, j) + this.udiag[0] * m.getElement(1, j);
                for (int i = 1; i < lastRow; ++i) {
                    array[i][j] = this.ldiag[i] * m.getElement(i - 1, j) + this.diag[i] * m.getElement(i, j) + this.udiag[i] * m.getElement(i + 1, j);
                }
                array[lastRow][j] = this.ldiag[lastRow] * m.getElement(lastRow - 1, j) + this.diag[lastRow] * m.getElement(lastRow, j);
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix m) {
        if (this.numCols == m.numRows) {
            int[][] array = new int[this.numRows][m.numCols];
            int lastRow = this.numRows - 1;
            for (int j = 0; j < this.numRows; ++j) {
                array[0][j] = this.diag[0] * m.matrix[0][j] + this.udiag[0] * m.matrix[1][j];
                for (int i = 1; i < lastRow; ++i) {
                    array[i][j] = this.ldiag[i] * m.matrix[i - 1][j] + this.diag[i] * m.matrix[i][j] + this.udiag[i] * m.matrix[i + 1][j];
                }
                array[lastRow][j] = this.ldiag[lastRow] * m.matrix[lastRow - 1][j] + this.diag[lastRow] * m.matrix[lastRow][j];
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (this.numCols == m.numRows) {
            int[][] array = new int[mRow][mRow];
            array[0][0] = this.diag[0] * m.diag[0] + this.udiag[0] * m.ldiag[1];
            array[0][1] = this.diag[0] * m.udiag[0] + this.udiag[0] * m.diag[1];
            array[0][2] = this.udiag[0] * m.udiag[1];
            if (mRow > 3) {
                array[1][0] = this.ldiag[1] * m.diag[0] + this.diag[1] * m.ldiag[1];
                array[1][1] = this.ldiag[1] * m.udiag[0] + this.diag[1] * m.diag[1] + this.udiag[1] * m.ldiag[2];
                array[1][2] = this.diag[1] * m.udiag[1] + this.udiag[1] * m.diag[2];
                array[1][3] = this.udiag[1] * m.udiag[2];
            }
            if (mRow == 3) {
                array[1][0] = this.ldiag[1] * m.diag[0] + this.diag[1] * m.ldiag[1];
                array[1][1] = this.ldiag[1] * m.udiag[0] + this.diag[1] * m.diag[1] + this.udiag[1] * m.ldiag[2];
                array[1][2] = this.diag[1] * m.udiag[1] + this.udiag[1] * m.diag[2];
            } else if (mRow > 4) {
                for (int i = 2; i < mRow - 2; ++i) {
                    array[i][i - 2] = this.ldiag[i] * m.ldiag[i - 1];
                    array[i][i - 1] = this.ldiag[i] * m.diag[i - 1] + this.diag[i] * m.ldiag[i];
                    array[i][i] = this.ldiag[i] * m.udiag[i - 1] + this.diag[i] * m.diag[i] + this.udiag[i] * m.ldiag[i + 1];
                    array[i][i + 1] = this.diag[i] * m.udiag[i] + this.udiag[i] * m.diag[i + 1];
                    array[i][i + 2] = this.udiag[i] * m.udiag[i + 1];
                }
            }
            if (mRow > 3) {
                array[mRow - 2][mRow - 4] = this.ldiag[mRow - 2] * m.ldiag[mRow - 3];
                array[mRow - 2][mRow - 3] = this.ldiag[mRow - 2] * m.diag[mRow - 3] + this.diag[mRow - 2] * m.ldiag[mRow - 2];
                array[mRow - 2][mRow - 2] = this.ldiag[mRow - 2] * m.udiag[mRow - 3] + this.diag[mRow - 2] * m.diag[mRow - 2] + this.udiag[mRow - 2] * m.ldiag[mRow - 1];
                array[mRow - 2][mRow - 1] = this.diag[mRow - 2] * m.udiag[mRow - 2] + this.udiag[mRow - 2] * m.diag[mRow - 1];
            }
            array[mRow][--mRow - 2] = this.ldiag[mRow] * m.ldiag[mRow - 1];
            array[mRow][mRow - 1] = this.ldiag[mRow] * m.diag[mRow - 1] + this.diag[mRow] * m.ldiag[mRow];
            array[mRow][mRow] = this.ldiag[mRow] * m.udiag[mRow - 1] + this.diag[mRow] * m.diag[mRow];
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerSquareMatrix multiplyTridiagonal(AbstractIntegerSquareMatrix m) {
        int mRow = this.numRows;
        if (this.numCols == m.rows()) {
            int[][] array = new int[mRow][mRow];
            array[0][0] = this.diag[0] * m.getElement(0, 0) + this.udiag[0] * m.getElement(1, 0);
            array[0][1] = this.diag[0] * m.getElement(0, 1) + this.udiag[0] * m.getElement(1, 1);
            array[0][2] = this.udiag[0] * m.getElement(1, 2);
            if (mRow > 3) {
                array[1][0] = this.ldiag[1] * m.getElement(0, 0) + this.diag[1] * m.getElement(1, 0);
                array[1][1] = this.ldiag[1] * m.getElement(0, 1) + this.diag[1] * m.getElement(1, 1) + this.udiag[1] * m.getElement(2, 1);
                array[1][2] = this.diag[1] * m.getElement(1, 2) + this.udiag[1] * m.getElement(2, 2);
                array[1][3] = this.udiag[1] * m.getElement(2, 3);
            }
            if (mRow == 3) {
                array[1][0] = this.ldiag[1] * m.getElement(0, 0) + this.diag[1] * m.getElement(1, 0);
                array[1][1] = this.ldiag[1] * m.getElement(0, 1) + this.diag[1] * m.getElement(1, 1) + this.udiag[1] * m.getElement(2, 1);
                array[1][2] = this.diag[1] * m.getElement(1, 2) + this.udiag[1] * m.getElement(2, 2);
            } else if (mRow > 4) {
                for (int i = 2; i < mRow - 2; ++i) {
                    array[i][i - 2] = this.ldiag[i] * m.getElement(i - 1, i - 2);
                    array[i][i - 1] = this.ldiag[i] * m.getElement(i - 1, i - 1) + this.diag[i] * m.getElement(i, i - 1);
                    array[i][i] = this.ldiag[i] * m.getElement(i - 1, i) + this.diag[i] * m.getElement(i, i) + this.udiag[i] * m.getElement(i + 1, i);
                    array[i][i + 1] = this.diag[i] * m.getElement(i, i + 1) + this.udiag[i] * m.getElement(i + 1, i + 1);
                    array[i][i + 2] = this.udiag[i] * m.getElement(i + 1, i + 2);
                }
            }
            if (mRow > 3) {
                array[mRow - 2][mRow - 4] = this.ldiag[mRow - 2] * m.getElement(mRow - 3, mRow - 4);
                array[mRow - 2][mRow - 3] = this.ldiag[mRow - 2] * m.getElement(mRow - 3, mRow - 3) + this.diag[mRow - 2] * m.getElement(mRow - 2, mRow - 3);
                array[mRow - 2][mRow - 2] = this.ldiag[mRow - 2] * m.getElement(mRow - 3, mRow - 2) + this.diag[mRow - 2] * m.getElement(mRow - 2, mRow - 2) + this.udiag[mRow - 2] * m.getElement(mRow - 1, mRow - 2);
                array[mRow - 2][mRow - 1] = this.diag[mRow - 2] * m.getElement(mRow - 2, mRow - 1) + this.udiag[mRow - 2] * m.getElement(mRow - 1, mRow - 1);
            }
            array[mRow][--mRow - 2] = this.ldiag[mRow] * m.getElement(mRow - 1, mRow - 2);
            array[mRow][mRow - 1] = this.ldiag[mRow] * m.getElement(mRow - 1, mRow - 1) + this.diag[mRow] * m.getElement(mRow, mRow - 1);
            array[mRow][mRow] = this.ldiag[mRow] * m.getElement(mRow - 1, mRow) + this.diag[mRow] * m.getElement(mRow, mRow);
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public Matrix transpose() {
        IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(this.numRows);
        System.arraycopy(this.ldiag, 1, ans.udiag, 0, this.ldiag.length - 1);
        System.arraycopy(this.diag, 0, ans.diag, 0, this.diag.length);
        System.arraycopy(this.udiag, 0, ans.ldiag, 1, this.udiag.length - 1);
        return ans;
    }

    @Override
    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        double tmp;
        int N = this.numRows;
        double[][] arrayL = new double[N][N];
        double[][] arrayU = new double[N][N];
        double d = tmp = Math.sqrt(this.diag[0]);
        arrayU[0][0] = d;
        arrayL[0][0] = d;
        double d2 = (double)this.ldiag[1] / tmp;
        arrayU[0][1] = d2;
        arrayL[1][0] = d2;
        for (int j = 1; j < N; ++j) {
            int i;
            tmp = this.diag[j];
            for (i = 0; i < j; ++i) {
                tmp -= arrayL[j][i] * arrayL[j][i];
            }
            double d3 = Math.sqrt(tmp);
            arrayU[j][j] = d3;
            arrayL[j][j] = d3;
            if (j + 1 >= N) continue;
            tmp = this.ldiag[j + 1];
            for (int k = 0; k < j + 1; ++k) {
                tmp -= arrayL[j][k] * arrayU[k][j + 1];
            }
            double d4 = tmp / arrayU[j][j];
            arrayU[j][j + 1] = d4;
            arrayL[j + 1][j] = d4;
            for (i = j + 2; i < N; ++i) {
                tmp = 0.0;
                for (int k = 0; k < i; ++k) {
                    tmp -= arrayL[j][k] * arrayU[k][i];
                }
                double d5 = tmp / arrayU[j][j];
                arrayU[j][i] = d5;
                arrayL[i][j] = d5;
            }
        }
        AbstractDoubleSquareMatrix[] lu = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(arrayL), new DoubleSquareMatrix(arrayU)};
        return lu;
    }

    @Override
    public AbstractDoubleSquareMatrix[] qrDecompose() {
        int k;
        int i;
        int N = this.numRows;
        double[][] array = new double[N][N];
        double[][] arrayQ = new double[N][N];
        double[][] arrayR = new double[N][N];
        array[0][0] = this.diag[0];
        array[0][1] = this.udiag[0];
        for (i = 1; i < N - 1; ++i) {
            array[i][i - 1] = this.ldiag[i];
            array[i][i] = this.diag[i];
            array[i][i + 1] = this.udiag[i];
        }
        array[N - 1][N - 2] = this.ldiag[N - 1];
        array[N - 1][N - 1] = this.diag[N - 1];
        for (k = 0; k < N; ++k) {
            int i2;
            double norm = array[k][k];
            for (i2 = k + 1; i2 < N; ++i2) {
                norm = ExtraMath.hypot(norm, array[i2][k]);
            }
            if (norm != 0.0) {
                if (array[k][k] < 0.0) {
                    norm = -norm;
                }
                for (i2 = k; i2 < N; ++i2) {
                    double[] dArray = array[i2];
                    int n = k;
                    dArray[n] = dArray[n] / norm;
                }
                double[] dArray = array[k];
                int n = k;
                dArray[n] = dArray[n] + 1.0;
                for (int j = k + 1; j < N; ++j) {
                    int i3;
                    double s = array[k][k] * array[k][j];
                    for (i3 = k + 1; i3 < N; ++i3) {
                        s += array[i3][k] * array[i3][j];
                    }
                    s /= array[k][k];
                    for (i3 = k; i3 < N; ++i3) {
                        double[] dArray2 = array[i3];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] - s * array[i3][k];
                    }
                }
            }
            arrayR[k][k] = -norm;
        }
        for (k = N - 1; k >= 0; --k) {
            arrayQ[k][k] = 1.0;
            for (int j = k; j < N; ++j) {
                int i4;
                if (array[k][k] == 0.0) continue;
                double s = array[k][k] * arrayQ[k][j];
                for (i4 = k + 1; i4 < N; ++i4) {
                    s += array[i4][k] * arrayQ[i4][j];
                }
                s /= array[k][k];
                for (i4 = k; i4 < N; ++i4) {
                    double[] dArray = arrayQ[i4];
                    int n = j;
                    dArray[n] = dArray[n] - s * array[i4][k];
                }
            }
        }
        for (i = 0; i < N; ++i) {
            for (int j = i + 1; j < N; ++j) {
                arrayR[i][j] = array[i][j];
            }
        }
        AbstractDoubleSquareMatrix[] qr = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(arrayQ), new DoubleSquareMatrix(arrayR)};
        return qr;
    }

    @Override
    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int i;
        double t;
        int k;
        int N = this.numRows;
        int Nm1 = N - 1;
        double[][] array = new double[N][N];
        double[][] arrayU = new double[N][N];
        double[] arrayS = new double[N];
        double[][] arrayV = new double[N][N];
        double[] e = new double[N];
        double[] work = new double[N];
        array[0][0] = this.diag[0];
        array[0][1] = this.udiag[0];
        for (int i2 = 1; i2 < Nm1; ++i2) {
            array[i2][i2 - 1] = this.ldiag[i2];
            array[i2][i2] = this.diag[i2];
            array[i2][i2 + 1] = this.udiag[i2];
        }
        array[Nm1][Nm1 - 1] = this.ldiag[Nm1];
        array[Nm1][Nm1] = this.diag[Nm1];
        for (int k2 = 0; k2 < Nm1; ++k2) {
            int i3;
            int j;
            int i4;
            arrayS[k2] = array[k2][k2];
            for (i4 = k2 + 1; i4 < N; ++i4) {
                arrayS[k2] = ExtraMath.hypot(arrayS[k2], array[i4][k2]);
            }
            if (arrayS[k2] != 0.0) {
                if (array[k2][k2] < 0.0) {
                    arrayS[k2] = -arrayS[k2];
                }
                for (i4 = k2; i4 < N; ++i4) {
                    double[] dArray = array[i4];
                    int n = k2;
                    dArray[n] = dArray[n] / arrayS[k2];
                }
                double[] dArray = array[k2];
                int n = k2;
                dArray[n] = dArray[n] + 1.0;
            }
            arrayS[k2] = -arrayS[k2];
            for (j = k2 + 1; j < N; ++j) {
                if (arrayS[k2] != 0.0) {
                    double t2 = array[k2][k2] * array[k2][j];
                    for (i3 = k2 + 1; i3 < N; ++i3) {
                        t2 += array[i3][k2] * array[i3][j];
                    }
                    t2 /= array[k2][k2];
                    for (i3 = k2; i3 < N; ++i3) {
                        double[] dArray = array[i3];
                        int n = j;
                        dArray[n] = dArray[n] - t2 * array[i3][k2];
                    }
                }
                e[j] = array[k2][j];
            }
            for (i4 = k2; i4 < N; ++i4) {
                arrayU[i4][k2] = array[i4][k2];
            }
            if (k2 >= N - 2) continue;
            e[k2] = e[k2 + 1];
            for (i4 = k2 + 2; i4 < N; ++i4) {
                e[k2] = ExtraMath.hypot(e[k2], e[i4]);
            }
            if (e[k2] != 0.0) {
                if (e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i4 = k2 + 1;
                while (i4 < N) {
                    int n = i4++;
                    e[n] = e[n] / e[k2];
                }
                int n = k2 + 1;
                e[n] = e[n] + 1.0;
            }
            e[k2] = -e[k2];
            if (e[k2] != 0.0) {
                for (i4 = k2 + 1; i4 < N; ++i4) {
                    work[i4] = 0.0;
                    for (int j2 = k2 + 1; j2 < N; ++j2) {
                        int n = i4;
                        work[n] = work[n] + e[j2] * array[i4][j2];
                    }
                }
                for (j = k2 + 1; j < N; ++j) {
                    double t3 = e[j] / e[k2 + 1];
                    for (i3 = k2 + 1; i3 < N; ++i3) {
                        double[] dArray = array[i3];
                        int n = j;
                        dArray[n] = dArray[n] - t3 * work[i3];
                    }
                }
            }
            for (i4 = k2 + 1; i4 < N; ++i4) {
                arrayV[i4][k2] = e[i4];
            }
        }
        int p = N;
        arrayS[Nm1] = array[Nm1][Nm1];
        e[N - 2] = array[N - 2][Nm1];
        e[Nm1] = 0.0;
        arrayU[Nm1][Nm1] = 1.0;
        for (k = N - 2; k >= 0; --k) {
            int i5;
            if (arrayS[k] != 0.0) {
                for (int j = k + 1; j < N; ++j) {
                    t = arrayU[k][k] * arrayU[k][j];
                    for (i = k + 1; i < N; ++i) {
                        t += arrayU[i][k] * arrayU[i][j];
                    }
                    t /= arrayU[k][k];
                    for (i = k; i < N; ++i) {
                        double[] dArray = arrayU[i];
                        int n = j;
                        dArray[n] = dArray[n] - t * arrayU[i][k];
                    }
                }
                for (i5 = k; i5 < N; ++i5) {
                    arrayU[i5][k] = -arrayU[i5][k];
                }
                double[] dArray = arrayU[k];
                int n = k;
                dArray[n] = dArray[n] + 1.0;
                for (i5 = 0; i5 < k - 1; ++i5) {
                    arrayU[i5][k] = 0.0;
                }
                continue;
            }
            for (i5 = 0; i5 < N; ++i5) {
                arrayU[i5][k] = 0.0;
            }
            arrayU[k][k] = 1.0;
        }
        for (k = Nm1; k >= 0; --k) {
            if (k < N - 2 && e[k] != 0.0) {
                for (int j = k + 1; j < N; ++j) {
                    t = arrayV[k + 1][k] * arrayV[k + 1][j];
                    for (i = k + 2; i < N; ++i) {
                        t += arrayV[i][k] * arrayV[i][j];
                    }
                    t /= arrayV[k + 1][k];
                    for (i = k + 1; i < N; ++i) {
                        double[] dArray = arrayV[i];
                        int n = j;
                        dArray[n] = dArray[n] - t * arrayV[i][k];
                    }
                }
            }
            for (int i6 = 0; i6 < N; ++i6) {
                arrayV[i6][k] = 0.0;
            }
            arrayV[k][k] = 1.0;
        }
        double eps = Math.pow(2.0, -52.0);
        int iter = 0;
        block33: while (p > 0) {
            int action;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= eps * (Math.abs(arrayS[k3]) + Math.abs(arrayS[k3 + 1])))) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                action = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(arrayS[ks]) <= eps * t4)) continue;
                    arrayS[ks] = 0.0;
                    break;
                }
                if (ks == k3) {
                    action = 3;
                } else if (ks == p - 1) {
                    action = 1;
                } else {
                    action = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (action) {
                case 1: {
                    int i7;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j = p - 2; j >= k3; --j) {
                        t5 = ExtraMath.hypot(arrayS[j], f);
                        cs = arrayS[j] / t5;
                        sn = f / t5;
                        arrayS[j] = t5;
                        if (j != k3) {
                            f = -sn * e[j - 1];
                            int n = j - 1;
                            e[n] = e[n] * cs;
                        }
                        for (i7 = 0; i7 < N; ++i7) {
                            t5 = cs * arrayV[i7][j] + sn * arrayV[i7][p - 1];
                            arrayV[i7][p - 1] = -sn * arrayV[i7][j] + cs * arrayV[i7][p - 1];
                            arrayV[i7][j] = t5;
                        }
                    }
                    continue block33;
                }
                case 2: {
                    int i7;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (int j = k3; j < p; ++j) {
                        t5 = ExtraMath.hypot(arrayS[j], f);
                        cs = arrayS[j] / t5;
                        sn = f / t5;
                        arrayS[j] = t5;
                        f = -sn * e[j];
                        int n = j;
                        e[n] = e[n] * cs;
                        for (i7 = 0; i7 < N; ++i7) {
                            t5 = cs * arrayU[i7][j] + sn * arrayU[i7][k3 - 1];
                            arrayU[i7][k3 - 1] = -sn * arrayU[i7][j] + cs * arrayU[i7][k3 - 1];
                            arrayU[i7][j] = t5;
                        }
                    }
                    continue block33;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(arrayS[p - 1]), Math.abs(arrayS[p - 2])), Math.abs(e[p - 2])), Math.abs(arrayS[k3])), Math.abs(e[k3]));
                    double sp = arrayS[p - 1] / scale;
                    double spm1 = arrayS[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = arrayS[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 || c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j = k3; j < p - 1; ++j) {
                        int i8;
                        double t6 = ExtraMath.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j != k3) {
                            e[j - 1] = t6;
                        }
                        f = cs * arrayS[j] + sn * e[j];
                        e[j] = cs * e[j] - sn * arrayS[j];
                        g = sn * arrayS[j + 1];
                        int n = j + 1;
                        arrayS[n] = arrayS[n] * cs;
                        for (i8 = 0; i8 < N; ++i8) {
                            t6 = cs * arrayV[i8][j] + sn * arrayV[i8][j + 1];
                            arrayV[i8][j + 1] = -sn * arrayV[i8][j] + cs * arrayV[i8][j + 1];
                            arrayV[i8][j] = t6;
                        }
                        t6 = ExtraMath.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        arrayS[j] = t6;
                        f = cs * e[j] + sn * arrayS[j + 1];
                        arrayS[j + 1] = -sn * e[j] + cs * arrayS[j + 1];
                        g = sn * e[j + 1];
                        int n2 = j + 1;
                        e[n2] = e[n2] * cs;
                        if (j >= Nm1) continue;
                        for (i8 = 0; i8 < N; ++i8) {
                            t6 = cs * arrayU[i8][j] + sn * arrayU[i8][j + 1];
                            arrayU[i8][j + 1] = -sn * arrayU[i8][j] + cs * arrayU[i8][j + 1];
                            arrayU[i8][j] = t6;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (arrayS[k3] <= 0.0) {
                        arrayS[k3] = -arrayS[k3];
                        for (int i9 = 0; i9 < p; ++i9) {
                            arrayV[i9][k3] = -arrayV[i9][k3];
                        }
                    }
                    while (k3 < p - 1 && !(arrayS[k3] >= arrayS[k3 + 1])) {
                        double tmp = arrayS[k3];
                        arrayS[k3] = arrayS[k3 + 1];
                        arrayS[k3 + 1] = tmp;
                        if (k3 < Nm1) {
                            for (int i10 = 0; i10 < N; ++i10) {
                                tmp = arrayU[i10][k3 + 1];
                                arrayU[i10][k3 + 1] = arrayU[i10][k3];
                                arrayU[i10][k3] = tmp;
                                tmp = arrayV[i10][k3 + 1];
                                arrayV[i10][k3 + 1] = arrayV[i10][k3];
                                arrayV[i10][k3] = tmp;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
        AbstractDoubleSquareMatrix[] svd = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(arrayU), new DoubleDiagonalMatrix(arrayS), new DoubleSquareMatrix(arrayV)};
        return svd;
    }
}

