/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.maths.ArrayMath;
import jsci.maths.DimensionException;
import jsci.maths.ExtraMath;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractDoubleSquareMatrix;
import jsci.maths.matrices.AbstractIntegerMatrix;
import jsci.maths.matrices.AbstractIntegerSquareMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.matrices.DoubleDiagonalMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.IntegerVector;

public class IntegerSquareMatrix
extends AbstractIntegerSquareMatrix {
    protected final int[][] matrix;

    public IntegerSquareMatrix(int[][] array) {
        super(array.length);
        if (!ArrayMath.isSquare(array)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.matrix = array;
    }

    public IntegerSquareMatrix(int size) {
        this(new int[size][size]);
    }

    public IntegerSquareMatrix(AbstractIntegerVector[] array) {
        this(array.length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrix[i][j] = array[j].getComponent(i);
            }
        }
    }

    @Override
    public boolean equals(AbstractIntegerMatrix m, double tol) {
        if (m != null && this.numRows == m.rows() && this.numCols == m.columns()) {
            int sumSqr = 0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    int delta = this.matrix[i][j] - m.getElement(i, j);
                    sumSqr += delta * delta;
                }
            }
            return (double)sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.matrix[i][j]);
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public AbstractDoubleMatrix toDoubleMatrix() {
        double[][] ans = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = this.matrix[i][j];
            }
        }
        return new DoubleSquareMatrix(ans);
    }

    @Override
    public AbstractComplexMatrix toComplexMatrix() {
        ComplexSquareMatrix cm = new ComplexSquareMatrix(this.numRows);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                cm.setElement(i, j, this.matrix[i][j], 0.0);
            }
        }
        return cm;
    }

    @Override
    public int getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            return this.matrix[i][j];
        }
        throw new MatrixDimensionException(IntegerSquareMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public void setElement(int i, int j, int x) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) {
            throw new MatrixDimensionException(IntegerSquareMatrix.getInvalidElementMsg(i, j));
        }
        this.matrix[i][j] = x;
    }

    @Override
    public int infNorm() {
        int result = 0;
        for (int i = 0; i < this.numRows; ++i) {
            int tmpResult = 0;
            for (int j = 0; j < this.numCols; ++j) {
                tmpResult += Math.abs(this.matrix[i][j]);
            }
            if (tmpResult <= result) continue;
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                result = ExtraMath.hypot(result, this.matrix[i][j]);
            }
        }
        return result;
    }

    @Override
    public int det() {
        if (this.numRows == 2) {
            return this.matrix[0][0] * this.matrix[1][1] - this.matrix[0][1] * this.matrix[1][0];
        }
        DoubleSquareMatrix[] lu = (DoubleSquareMatrix[])this.luDecompose(null);
        double det = lu[1].matrix[0][0];
        for (int i = 1; i < this.numRows; ++i) {
            det *= lu[1].matrix[i][i];
        }
        return Math.round((float)det) * this.LUpivot[this.numRows];
    }

    @Override
    public int trace() {
        int result = this.matrix[0][0];
        for (int i = 1; i < this.numRows; ++i) {
            result += this.matrix[i][i];
        }
        return result;
    }

    @Override
    public AbelianGroup.Member negate() {
        int[][] array = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = -this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = -this.matrix[i][j];
            }
        }
        return new IntegerSquareMatrix(array);
    }

    @Override
    public AbstractIntegerSquareMatrix add(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerSquareMatrix) {
            return this.add((IntegerSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.matrix[i][0] + m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.matrix[i][j] + m.getElement(i, j);
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.matrix[i][0] + m.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.matrix[i][j] + m.matrix[i][j];
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerSquareMatrix subtract(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerSquareMatrix) {
            return this.subtract((IntegerSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.matrix[i][0] - m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.matrix[i][j] - m.getElement(i, j);
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.matrix[i][0] - m.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.matrix[i][j] - m.matrix[i][j];
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerMatrix scalarMultiply(int x) {
        int[][] array = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = x * this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = x * this.matrix[i][j];
            }
        }
        return new IntegerSquareMatrix(array);
    }

    @Override
    public int scalarProduct(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerSquareMatrix) {
            return this.scalarProduct((IntegerSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int ans = 0;
            for (int i = 0; i < this.numRows; ++i) {
                ans += this.matrix[i][0] * m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    ans += this.matrix[i][j] * m.getElement(i, j);
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int ans = 0;
            for (int i = 0; i < this.numRows; ++i) {
                ans += this.matrix[i][0] * m.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    ans += this.matrix[i][j] * m.matrix[i][j];
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerVector multiply(AbstractIntegerVector v) {
        if (this.numCols == v.dimension()) {
            int[] array = new int[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                array[i] = this.matrix[i][0] * v.getComponent(0);
                for (int j = 1; j < this.numCols; ++j) {
                    int n = i;
                    array[n] = array[n] + this.matrix[i][j] * v.getComponent(j);
                }
            }
            return new IntegerVector(array);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractIntegerSquareMatrix multiply(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerSquareMatrix) {
            return this.multiply((IntegerSquareMatrix)m);
        }
        if (this.numCols == m.rows()) {
            int mColumns = m.columns();
            int[][] array = new int[this.numRows][mColumns];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < mColumns; ++k) {
                    array[j][k] = this.matrix[j][0] * m.getElement(0, k);
                    for (int n = 1; n < this.numCols; ++n) {
                        int[] nArray = array[j];
                        int n2 = k;
                        nArray[n2] = nArray[n2] + this.matrix[j][n] * m.getElement(n, k);
                    }
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix m) {
        if (this.numCols == m.numRows) {
            int[][] array = new int[this.numRows][m.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.numCols; ++k) {
                    array[j][k] = this.matrix[j][0] * m.matrix[0][k];
                    for (int n = 1; n < this.numCols; ++n) {
                        int[] nArray = array[j];
                        int n2 = k;
                        nArray[n2] = nArray[n2] + this.matrix[j][n] * m.matrix[n][k];
                    }
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public AbstractIntegerSquareMatrix directSum(AbstractIntegerSquareMatrix m) {
        int j;
        int i;
        int[][] array = new int[this.numRows + m.numRows][this.numCols + m.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                array[i][j] = this.matrix[i][j];
            }
        }
        for (i = 0; i < m.numRows; ++i) {
            for (j = 0; j < m.numCols; ++j) {
                array[i + this.numRows][j + this.numCols] = m.getElement(i, j);
            }
        }
        return new IntegerSquareMatrix(array);
    }

    @Override
    public AbstractIntegerSquareMatrix tensor(AbstractIntegerSquareMatrix m) {
        int[][] array = new int[this.numRows * m.numRows][this.numCols * m.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int k = 0;
                while (k < m.numRows) {
                    for (int l = 0; l < m.numCols; ++l) {
                        array[i * m.numRows + k][j * m.numCols + l] = this.matrix[i][j] * m.getElement(k, l);
                    }
                    ++j;
                }
            }
        }
        return new IntegerSquareMatrix(array);
    }

    @Override
    public Matrix transpose() {
        int[][] array = new int[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            array[0][i] = this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                array[j][i] = this.matrix[i][j];
            }
        }
        return new IntegerSquareMatrix(array);
    }

    @Override
    public AbstractDoubleSquareMatrix inverse() {
        int i;
        int N = this.numRows;
        double[][] arrayL = new double[N][N];
        double[][] arrayU = new double[N][N];
        DoubleSquareMatrix[] lu = (DoubleSquareMatrix[])this.luDecompose(null);
        arrayL[0][0] = 1.0 / lu[0].matrix[0][0];
        arrayU[0][0] = 1.0 / lu[1].matrix[0][0];
        for (i = 1; i < N; ++i) {
            arrayL[i][i] = 1.0 / lu[0].matrix[i][i];
            arrayU[i][i] = 1.0 / lu[1].matrix[i][i];
        }
        for (i = 0; i < N - 1; ++i) {
            for (int j = i + 1; j < N; ++j) {
                double tmpL = 0.0;
                double tmpU = 0.0;
                for (int k = i; k < j; ++k) {
                    tmpL -= lu[0].matrix[j][k] * arrayL[k][i];
                    tmpU -= arrayU[i][k] * lu[1].matrix[k][j];
                }
                arrayL[j][i] = tmpL / lu[0].matrix[j][j];
                arrayU[i][j] = tmpU / lu[1].matrix[j][j];
            }
        }
        double[][] inv = new double[N][N];
        for (int i2 = 0; i2 < N; ++i2) {
            int k;
            int j;
            for (j = 0; j < i2; ++j) {
                for (k = i2; k < N; ++k) {
                    double[] dArray = inv[i2];
                    int n = this.LUpivot[j];
                    dArray[n] = dArray[n] + arrayU[i2][k] * arrayL[k][j];
                }
            }
            for (j = i2; j < N; ++j) {
                for (k = j; k < N; ++k) {
                    double[] dArray = inv[i2];
                    int n = this.LUpivot[j];
                    dArray[n] = dArray[n] + arrayU[i2][k] * arrayL[k][j];
                }
            }
        }
        return new DoubleSquareMatrix(inv);
    }

    @Override
    public final AbstractDoubleSquareMatrix[] luDecompose(int[] pivot) {
        int j;
        if (this.LU != null) {
            if (pivot != null) {
                System.arraycopy(this.LUpivot, 0, pivot, 0, pivot.length);
            }
            return this.LU;
        }
        int N = this.numRows;
        double[][] arrayL = new double[N][N];
        double[][] arrayU = new double[N][N];
        if (pivot == null) {
            pivot = new int[N + 1];
        }
        for (int i = 0; i < N; ++i) {
            pivot[i] = i;
        }
        pivot[N] = 1;
        for (j = 0; j < N; ++j) {
            int k;
            int i;
            double tmp;
            for (int i2 = 0; i2 < j; ++i2) {
                tmp = this.matrix[pivot[i2]][j];
                for (int k2 = 0; k2 < i2; ++k2) {
                    tmp -= arrayU[i2][k2] * arrayU[k2][j];
                }
                arrayU[i2][j] = tmp;
            }
            double max = 0.0;
            int pivotrow = j;
            for (i = j; i < N; ++i) {
                tmp = this.matrix[pivot[i]][j];
                for (k = 0; k < j; ++k) {
                    tmp -= arrayU[i][k] * arrayU[k][j];
                }
                arrayU[i][j] = tmp;
                if (!((tmp = Math.abs(tmp)) > max)) continue;
                max = tmp;
                pivotrow = i;
            }
            if (pivotrow != j) {
                double[] tmprow = arrayU[j];
                arrayU[j] = arrayU[pivotrow];
                arrayU[pivotrow] = tmprow;
                k = pivot[j];
                pivot[j] = pivot[pivotrow];
                pivot[pivotrow] = k;
                pivot[N] = -pivot[N];
            }
            tmp = arrayU[j][j];
            for (i = j + 1; i < N; ++i) {
                double[] dArray = arrayU[i];
                int n = j;
                dArray[n] = dArray[n] / tmp;
            }
        }
        for (j = 0; j < N; ++j) {
            arrayL[j][j] = 1.0;
            for (int i = j + 1; i < N; ++i) {
                arrayL[i][j] = arrayU[i][j];
                arrayU[i][j] = 0.0;
            }
        }
        this.LU = new DoubleSquareMatrix[2];
        this.LU[0] = new DoubleSquareMatrix(arrayL);
        this.LU[1] = new DoubleSquareMatrix(arrayU);
        this.LUpivot = new int[pivot.length];
        System.arraycopy(pivot, 0, this.LUpivot, 0, pivot.length);
        return this.LU;
    }

    @Override
    public final AbstractDoubleSquareMatrix[] luDecompose() {
        int i;
        int j;
        int N = this.numRows;
        double[][] arrayL = new double[N][N];
        double[][] arrayU = new double[N][N];
        for (j = 0; j < N; ++j) {
            int k;
            double tmp;
            for (i = 0; i < j; ++i) {
                tmp = this.matrix[i][j];
                for (k = 0; k < i; ++k) {
                    tmp -= arrayU[i][k] * arrayU[k][j];
                }
                arrayU[i][j] = tmp;
            }
            for (i = j; i < N; ++i) {
                tmp = this.matrix[i][j];
                for (k = 0; k < j; ++k) {
                    tmp -= arrayU[i][k] * arrayU[k][j];
                }
                arrayU[i][j] = tmp;
            }
            tmp = arrayU[j][j];
            for (i = j + 1; i < N; ++i) {
                double[] dArray = arrayU[i];
                int n = j;
                dArray[n] = dArray[n] / tmp;
            }
        }
        for (j = 0; j < N; ++j) {
            arrayL[j][j] = 1.0;
            for (i = j + 1; i < N; ++i) {
                arrayL[i][j] = arrayU[i][j];
                arrayU[i][j] = 0.0;
            }
        }
        AbstractDoubleSquareMatrix[] lu = new DoubleSquareMatrix[]{new DoubleSquareMatrix(arrayL), new DoubleSquareMatrix(arrayU)};
        return lu;
    }

    @Override
    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        double tmp;
        int N = this.numRows;
        double[][] arrayL = new double[N][N];
        double[][] arrayU = new double[N][N];
        double d = tmp = Math.sqrt(this.matrix[0][0]);
        arrayU[0][0] = d;
        arrayL[0][0] = d;
        for (int i = 1; i < N; ++i) {
            double d2 = (double)this.matrix[i][0] / tmp;
            arrayU[0][i] = d2;
            arrayL[i][0] = d2;
        }
        for (int j = 1; j < N; ++j) {
            int i;
            tmp = this.matrix[j][j];
            for (i = 0; i < j; ++i) {
                tmp -= arrayL[j][i] * arrayL[j][i];
            }
            double d3 = Math.sqrt(tmp);
            arrayU[j][j] = d3;
            arrayL[j][j] = d3;
            for (i = j + 1; i < N; ++i) {
                tmp = this.matrix[i][j];
                for (int k = 0; k < i; ++k) {
                    tmp -= arrayL[j][k] * arrayU[k][i];
                }
                double d4 = tmp / arrayU[j][j];
                arrayU[j][i] = d4;
                arrayL[i][j] = d4;
            }
        }
        AbstractDoubleSquareMatrix[] lu = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(arrayL), new DoubleSquareMatrix(arrayU)};
        return lu;
    }

    @Override
    public AbstractDoubleSquareMatrix[] qrDecompose() {
        int k;
        int i;
        int N = this.numRows;
        double[][] array = new double[N][N];
        double[][] arrayQ = new double[N][N];
        double[][] arrayR = new double[N][N];
        for (i = 0; i < N; ++i) {
            array[i][0] = this.matrix[i][0];
            for (int j = 1; j < N; ++j) {
                array[i][j] = this.matrix[i][j];
            }
        }
        for (k = 0; k < N; ++k) {
            int i2;
            double norm = array[k][k];
            for (i2 = k + 1; i2 < N; ++i2) {
                norm = ExtraMath.hypot(norm, array[i2][k]);
            }
            if (norm != 0.0) {
                if (array[k][k] < 0.0) {
                    norm = -norm;
                }
                for (i2 = k; i2 < N; ++i2) {
                    double[] dArray = array[i2];
                    int n = k;
                    dArray[n] = dArray[n] / norm;
                }
                double[] dArray = array[k];
                int n = k;
                dArray[n] = dArray[n] + 1.0;
                for (int j = k + 1; j < N; ++j) {
                    int i3;
                    double s = array[k][k] * array[k][j];
                    for (i3 = k + 1; i3 < N; ++i3) {
                        s += array[i3][k] * array[i3][j];
                    }
                    s /= array[k][k];
                    for (i3 = k; i3 < N; ++i3) {
                        double[] dArray2 = array[i3];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] - s * array[i3][k];
                    }
                }
            }
            arrayR[k][k] = -norm;
        }
        for (k = N - 1; k >= 0; --k) {
            arrayQ[k][k] = 1.0;
            for (int j = k; j < N; ++j) {
                int i4;
                if (array[k][k] == 0.0) continue;
                double s = array[k][k] * arrayQ[k][j];
                for (i4 = k + 1; i4 < N; ++i4) {
                    s += array[i4][k] * arrayQ[i4][j];
                }
                s /= array[k][k];
                for (i4 = k; i4 < N; ++i4) {
                    double[] dArray = arrayQ[i4];
                    int n = j;
                    dArray[n] = dArray[n] - s * array[i4][k];
                }
            }
        }
        for (i = 0; i < N; ++i) {
            for (int j = i + 1; j < N; ++j) {
                arrayR[i][j] = array[i][j];
            }
        }
        AbstractDoubleSquareMatrix[] qr = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(arrayQ), new DoubleSquareMatrix(arrayR)};
        return qr;
    }

    @Override
    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int i;
        double t;
        int k;
        int j;
        int N = this.numRows;
        int Nm1 = N - 1;
        double[][] array = new double[N][N];
        double[][] arrayU = new double[N][N];
        double[] arrayS = new double[N];
        double[][] arrayV = new double[N][N];
        double[] e = new double[N];
        double[] work = new double[N];
        for (int i2 = 0; i2 < N; ++i2) {
            array[i2][0] = this.matrix[i2][0];
            for (j = 1; j < N; ++j) {
                array[i2][j] = this.matrix[i2][j];
            }
        }
        for (int k2 = 0; k2 < Nm1; ++k2) {
            int i3;
            int i4;
            arrayS[k2] = array[k2][k2];
            for (i4 = k2 + 1; i4 < N; ++i4) {
                arrayS[k2] = ExtraMath.hypot(arrayS[k2], array[i4][k2]);
            }
            if (arrayS[k2] != 0.0) {
                if (array[k2][k2] < 0.0) {
                    arrayS[k2] = -arrayS[k2];
                }
                for (i4 = k2; i4 < N; ++i4) {
                    double[] dArray = array[i4];
                    int n = k2;
                    dArray[n] = dArray[n] / arrayS[k2];
                }
                double[] dArray = array[k2];
                int n = k2;
                dArray[n] = dArray[n] + 1.0;
            }
            arrayS[k2] = -arrayS[k2];
            for (j = k2 + 1; j < N; ++j) {
                if (arrayS[k2] != 0.0) {
                    double t2 = array[k2][k2] * array[k2][j];
                    for (i3 = k2 + 1; i3 < N; ++i3) {
                        t2 += array[i3][k2] * array[i3][j];
                    }
                    t2 /= array[k2][k2];
                    for (i3 = k2; i3 < N; ++i3) {
                        double[] dArray = array[i3];
                        int n = j;
                        dArray[n] = dArray[n] - t2 * array[i3][k2];
                    }
                }
                e[j] = array[k2][j];
            }
            for (i4 = k2; i4 < N; ++i4) {
                arrayU[i4][k2] = array[i4][k2];
            }
            if (k2 >= N - 2) continue;
            e[k2] = e[k2 + 1];
            for (i4 = k2 + 2; i4 < N; ++i4) {
                e[k2] = ExtraMath.hypot(e[k2], e[i4]);
            }
            if (e[k2] != 0.0) {
                if (e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i4 = k2 + 1;
                while (i4 < N) {
                    int n = i4++;
                    e[n] = e[n] / e[k2];
                }
                int n = k2 + 1;
                e[n] = e[n] + 1.0;
            }
            e[k2] = -e[k2];
            if (e[k2] != 0.0) {
                for (i4 = k2 + 1; i4 < N; ++i4) {
                    work[i4] = 0.0;
                    for (int j2 = k2 + 1; j2 < N; ++j2) {
                        int n = i4;
                        work[n] = work[n] + e[j2] * array[i4][j2];
                    }
                }
                for (j = k2 + 1; j < N; ++j) {
                    double t3 = e[j] / e[k2 + 1];
                    for (i3 = k2 + 1; i3 < N; ++i3) {
                        double[] dArray = array[i3];
                        int n = j;
                        dArray[n] = dArray[n] - t3 * work[i3];
                    }
                }
            }
            for (i4 = k2 + 1; i4 < N; ++i4) {
                arrayV[i4][k2] = e[i4];
            }
        }
        int p = N;
        arrayS[Nm1] = array[Nm1][Nm1];
        e[N - 2] = array[N - 2][Nm1];
        e[Nm1] = 0.0;
        arrayU[Nm1][Nm1] = 1.0;
        for (k = N - 2; k >= 0; --k) {
            int i5;
            if (arrayS[k] != 0.0) {
                for (int j3 = k + 1; j3 < N; ++j3) {
                    t = arrayU[k][k] * arrayU[k][j3];
                    for (i = k + 1; i < N; ++i) {
                        t += arrayU[i][k] * arrayU[i][j3];
                    }
                    t /= arrayU[k][k];
                    for (i = k; i < N; ++i) {
                        double[] dArray = arrayU[i];
                        int n = j3;
                        dArray[n] = dArray[n] - t * arrayU[i][k];
                    }
                }
                for (i5 = k; i5 < N; ++i5) {
                    arrayU[i5][k] = -arrayU[i5][k];
                }
                double[] dArray = arrayU[k];
                int n = k;
                dArray[n] = dArray[n] + 1.0;
                for (i5 = 0; i5 < k - 1; ++i5) {
                    arrayU[i5][k] = 0.0;
                }
                continue;
            }
            for (i5 = 0; i5 < N; ++i5) {
                arrayU[i5][k] = 0.0;
            }
            arrayU[k][k] = 1.0;
        }
        for (k = Nm1; k >= 0; --k) {
            if (k < N - 2 && e[k] != 0.0) {
                for (int j4 = k + 1; j4 < N; ++j4) {
                    t = arrayV[k + 1][k] * arrayV[k + 1][j4];
                    for (i = k + 2; i < N; ++i) {
                        t += arrayV[i][k] * arrayV[i][j4];
                    }
                    t /= arrayV[k + 1][k];
                    for (i = k + 1; i < N; ++i) {
                        double[] dArray = arrayV[i];
                        int n = j4;
                        dArray[n] = dArray[n] - t * arrayV[i][k];
                    }
                }
            }
            for (int i6 = 0; i6 < N; ++i6) {
                arrayV[i6][k] = 0.0;
            }
            arrayV[k][k] = 1.0;
        }
        double eps = Math.pow(2.0, -52.0);
        int iter = 0;
        block34: while (p > 0) {
            int action;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= eps * (Math.abs(arrayS[k3]) + Math.abs(arrayS[k3 + 1])))) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                action = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(arrayS[ks]) <= eps * t4)) continue;
                    arrayS[ks] = 0.0;
                    break;
                }
                if (ks == k3) {
                    action = 3;
                } else if (ks == p - 1) {
                    action = 1;
                } else {
                    action = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (action) {
                case 1: {
                    int i7;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j5 = p - 2; j5 >= k3; --j5) {
                        t5 = ExtraMath.hypot(arrayS[j5], f);
                        cs = arrayS[j5] / t5;
                        sn = f / t5;
                        arrayS[j5] = t5;
                        if (j5 != k3) {
                            f = -sn * e[j5 - 1];
                            int n = j5 - 1;
                            e[n] = e[n] * cs;
                        }
                        for (i7 = 0; i7 < N; ++i7) {
                            t5 = cs * arrayV[i7][j5] + sn * arrayV[i7][p - 1];
                            arrayV[i7][p - 1] = -sn * arrayV[i7][j5] + cs * arrayV[i7][p - 1];
                            arrayV[i7][j5] = t5;
                        }
                    }
                    continue block34;
                }
                case 2: {
                    int i7;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (int j6 = k3; j6 < p; ++j6) {
                        t5 = ExtraMath.hypot(arrayS[j6], f);
                        cs = arrayS[j6] / t5;
                        sn = f / t5;
                        arrayS[j6] = t5;
                        f = -sn * e[j6];
                        int n = j6;
                        e[n] = e[n] * cs;
                        for (i7 = 0; i7 < N; ++i7) {
                            t5 = cs * arrayU[i7][j6] + sn * arrayU[i7][k3 - 1];
                            arrayU[i7][k3 - 1] = -sn * arrayU[i7][j6] + cs * arrayU[i7][k3 - 1];
                            arrayU[i7][j6] = t5;
                        }
                    }
                    continue block34;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(arrayS[p - 1]), Math.abs(arrayS[p - 2])), Math.abs(e[p - 2])), Math.abs(arrayS[k3])), Math.abs(e[k3]));
                    double sp = arrayS[p - 1] / scale;
                    double spm1 = arrayS[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = arrayS[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 || c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j7 = k3; j7 < p - 1; ++j7) {
                        int i8;
                        double t6 = ExtraMath.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j7 != k3) {
                            e[j7 - 1] = t6;
                        }
                        f = cs * arrayS[j7] + sn * e[j7];
                        e[j7] = cs * e[j7] - sn * arrayS[j7];
                        g = sn * arrayS[j7 + 1];
                        int n = j7 + 1;
                        arrayS[n] = arrayS[n] * cs;
                        for (i8 = 0; i8 < N; ++i8) {
                            t6 = cs * arrayV[i8][j7] + sn * arrayV[i8][j7 + 1];
                            arrayV[i8][j7 + 1] = -sn * arrayV[i8][j7] + cs * arrayV[i8][j7 + 1];
                            arrayV[i8][j7] = t6;
                        }
                        t6 = ExtraMath.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        arrayS[j7] = t6;
                        f = cs * e[j7] + sn * arrayS[j7 + 1];
                        arrayS[j7 + 1] = -sn * e[j7] + cs * arrayS[j7 + 1];
                        g = sn * e[j7 + 1];
                        int n2 = j7 + 1;
                        e[n2] = e[n2] * cs;
                        if (j7 >= Nm1) continue;
                        for (i8 = 0; i8 < N; ++i8) {
                            t6 = cs * arrayU[i8][j7] + sn * arrayU[i8][j7 + 1];
                            arrayU[i8][j7 + 1] = -sn * arrayU[i8][j7] + cs * arrayU[i8][j7 + 1];
                            arrayU[i8][j7] = t6;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (arrayS[k3] <= 0.0) {
                        arrayS[k3] = -arrayS[k3];
                        for (int i9 = 0; i9 < p; ++i9) {
                            arrayV[i9][k3] = -arrayV[i9][k3];
                        }
                    }
                    while (k3 < p - 1 && !(arrayS[k3] >= arrayS[k3 + 1])) {
                        double tmp = arrayS[k3];
                        arrayS[k3] = arrayS[k3 + 1];
                        arrayS[k3 + 1] = tmp;
                        if (k3 < Nm1) {
                            for (int i10 = 0; i10 < N; ++i10) {
                                tmp = arrayU[i10][k3 + 1];
                                arrayU[i10][k3 + 1] = arrayU[i10][k3];
                                arrayU[i10][k3] = tmp;
                                tmp = arrayV[i10][k3 + 1];
                                arrayV[i10][k3 + 1] = arrayV[i10][k3];
                                arrayV[i10][k3] = tmp;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
        AbstractDoubleSquareMatrix[] svd = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(arrayU), new DoubleDiagonalMatrix(arrayS), new DoubleSquareMatrix(arrayV)};
        return svd;
    }
}

