/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import java.awt.Dimension;
import java.util.Hashtable;
import jsci.maths.algebras.Algebra;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractIntegerMatrix;
import jsci.maths.matrices.AbstractIntegerSquareMatrix;
import jsci.maths.matrices.IntegerDiagonalMatrix;
import jsci.maths.matrices.IntegerMatrix;

public final class IntegerMatrixAlgebra
implements Algebra,
Ring {
    private static final Hashtable algebras = new Hashtable();
    private final int rows;
    private final int cols;
    private AbstractIntegerMatrix zero;
    private AbstractIntegerSquareMatrix one;

    static IntegerMatrixAlgebra get(int rows, int cols) {
        Dimension dim = new Dimension(rows, cols);
        IntegerMatrixAlgebra algebra = (IntegerMatrixAlgebra)algebras.get(dim);
        if (algebra == null) {
            algebra = new IntegerMatrixAlgebra(rows, cols);
            algebras.put(dim, algebra);
        }
        return algebra;
    }

    private IntegerMatrixAlgebra(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public Ring.Member one() {
        if (this.one == null) {
            this.one = IntegerDiagonalMatrix.identity(this.cols);
        }
        return this.one;
    }

    @Override
    public boolean isOne(Ring.Member r) {
        return this.one().equals(r);
    }

    @Override
    public AbelianGroup.Member zero() {
        if (this.zero == null) {
            this.zero = new IntegerMatrix(this.rows, this.cols);
        }
        return this.zero;
    }

    @Override
    public boolean isZero(AbelianGroup.Member r) {
        return this.zero().equals(r);
    }

    @Override
    public boolean isNegative(AbelianGroup.Member a, AbelianGroup.Member b) {
        return this.zero().equals(a.add(b));
    }
}

