/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import java.awt.Dimension;
import java.util.Hashtable;
import jsci.maths.algebras.Algebra;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractDoubleSquareMatrix;
import jsci.maths.matrices.DoubleDiagonalMatrix;
import jsci.maths.matrices.DoubleMatrix;

public final class DoubleMatrixAlgebra
implements Algebra,
Ring {
    private static final Hashtable algebras = new Hashtable();
    private final int rows;
    private final int cols;
    private AbstractDoubleMatrix zero;
    private AbstractDoubleSquareMatrix one;

    static DoubleMatrixAlgebra get(int rows, int cols) {
        Dimension dim = new Dimension(rows, cols);
        DoubleMatrixAlgebra algebra = (DoubleMatrixAlgebra)algebras.get(dim);
        if (algebra == null) {
            algebra = new DoubleMatrixAlgebra(rows, cols);
            algebras.put(dim, algebra);
        }
        return algebra;
    }

    private DoubleMatrixAlgebra(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public Ring.Member one() {
        if (this.one == null) {
            this.one = DoubleDiagonalMatrix.identity(this.cols);
        }
        return this.one;
    }

    @Override
    public boolean isOne(Ring.Member r) {
        return this.one().equals(r);
    }

    @Override
    public AbelianGroup.Member zero() {
        if (this.zero == null) {
            this.zero = new DoubleMatrix(this.rows, this.cols);
        }
        return this.zero;
    }

    @Override
    public boolean isZero(AbelianGroup.Member r) {
        return this.zero().equals(r);
    }

    @Override
    public boolean isNegative(AbelianGroup.Member a, AbelianGroup.Member b) {
        return this.zero().equals(a.add(b));
    }
}

