/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.GlobalSettings;
import jsci.maths.ArrayMath;
import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.DimensionException;
import jsci.maths.LinearMath;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.matrices.DoubleTridiagonalMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.matrices.TridiagonalMatrix;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.ComplexVector;

public class ComplexTridiagonalMatrix
extends AbstractComplexSquareMatrix
implements TridiagonalMatrix {
    protected final double[] ldiagRe;
    protected final double[] ldiagIm;
    protected final double[] diagRe;
    protected final double[] diagIm;
    protected final double[] udiagRe;
    protected final double[] udiagIm;

    public ComplexTridiagonalMatrix(int size) {
        super(size);
        this.ldiagRe = new double[size];
        this.ldiagIm = new double[size];
        this.diagRe = new double[size];
        this.diagIm = new double[size];
        this.udiagRe = new double[size];
        this.udiagIm = new double[size];
    }

    public ComplexTridiagonalMatrix(Complex[][] array) {
        this(array.length);
        int i;
        if (!ArrayMath.isSquare(array)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.diagRe[0] = array[0][0].real();
        this.diagIm[0] = array[0][0].imag();
        this.udiagRe[0] = array[0][1].real();
        this.udiagIm[0] = array[0][1].imag();
        for (i = 1; i < array.length - 1; ++i) {
            this.ldiagRe[i] = array[i][i - 1].real();
            this.ldiagIm[i] = array[i][i - 1].imag();
            this.diagRe[i] = array[i][i].real();
            this.diagIm[i] = array[i][i].imag();
            this.udiagRe[i] = array[i][i + 1].real();
            this.udiagIm[i] = array[i][i + 1].imag();
        }
        this.ldiagRe[i] = array[i][i - 1].real();
        this.ldiagIm[i] = array[i][i - 1].imag();
        this.diagRe[i] = array[i][i].real();
        this.diagIm[i] = array[i][i].imag();
    }

    @Override
    public boolean equals(AbstractComplexMatrix m, double tol) {
        if (m instanceof TridiagonalMatrix) {
            double ldeltaIm;
            double ldeltaRe;
            int i;
            if (this.numRows != m.rows() || this.numCols != m.columns()) {
                return false;
            }
            double sumSqr = 0.0;
            double deltaRe = this.diagRe[0] - m.getRealElement(0, 0);
            double deltaIm = this.diagIm[0] - m.getImagElement(0, 0);
            double udeltaRe = this.udiagRe[0] - m.getRealElement(0, 1);
            double udeltaIm = this.udiagIm[0] - m.getImagElement(0, 1);
            sumSqr += deltaRe * deltaRe + deltaIm * deltaIm + udeltaRe * udeltaRe + udeltaIm * udeltaIm;
            for (i = 1; i < this.numRows - 1; ++i) {
                ldeltaRe = this.ldiagRe[i] - m.getRealElement(i, i - 1);
                ldeltaIm = this.ldiagIm[i] - m.getImagElement(i, i - 1);
                deltaRe = this.diagRe[i] - m.getRealElement(i, i);
                deltaIm = this.diagIm[i] - m.getImagElement(i, i);
                udeltaRe = this.udiagRe[i] - m.getRealElement(i, i + 1);
                udeltaIm = this.udiagIm[i] - m.getImagElement(i, i + 1);
                sumSqr += ldeltaRe * ldeltaRe + ldeltaIm * ldeltaIm + deltaRe * deltaRe + deltaIm * deltaIm + udeltaRe * udeltaRe + udeltaIm * udeltaIm;
            }
            ldeltaRe = this.ldiagRe[i] - m.getRealElement(i, i - 1);
            return (sumSqr += ldeltaRe * ldeltaRe + (ldeltaIm = this.ldiagIm[i] - m.getImagElement(i, i - 1)) * ldeltaIm + (deltaRe = this.diagRe[i] - m.getRealElement(i, i)) * deltaRe + (deltaIm = this.diagIm[i] - m.getImagElement(i, i)) * deltaIm) <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.rows() * this.columns());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                buf.append(this.getElement(i, j).toString());
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public AbstractDoubleMatrix real() {
        int i;
        DoubleTridiagonalMatrix m = new DoubleTridiagonalMatrix(this.numRows);
        m.diag[0] = this.diagRe[0];
        m.udiag[0] = this.udiagRe[0];
        for (i = 1; i < this.numRows - 1; ++i) {
            m.ldiag[i] = this.ldiagRe[i];
            m.diag[i] = this.diagRe[i];
            m.udiag[i] = this.udiagRe[i];
        }
        m.ldiag[i] = this.ldiagRe[i];
        m.diag[i] = this.diagRe[i];
        return m;
    }

    @Override
    public AbstractDoubleMatrix imag() {
        int i;
        DoubleTridiagonalMatrix m = new DoubleTridiagonalMatrix(this.numRows);
        m.diag[0] = this.diagIm[0];
        m.udiag[0] = this.udiagIm[0];
        for (i = 1; i < this.numRows - 1; ++i) {
            m.ldiag[i] = this.ldiagIm[i];
            m.diag[i] = this.diagIm[i];
            m.udiag[i] = this.udiagIm[i];
        }
        m.ldiag[i] = this.ldiagIm[i];
        m.diag[i] = this.diagIm[i];
        return m;
    }

    @Override
    public Complex getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (j == i - 1) {
                return new Complex(this.ldiagRe[i], this.ldiagIm[i]);
            }
            if (j == i) {
                return new Complex(this.diagRe[i], this.diagIm[i]);
            }
            if (j == i + 1) {
                return new Complex(this.udiagRe[i], this.udiagIm[i]);
            }
            return Complex.ZERO;
        }
        throw new MatrixDimensionException(ComplexTridiagonalMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public double getRealElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (j == i - 1) {
                return this.ldiagRe[i];
            }
            if (j == i) {
                return this.diagRe[i];
            }
            if (j == i + 1) {
                return this.udiagRe[i];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(ComplexTridiagonalMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public double getImagElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (j == i - 1) {
                return this.ldiagIm[i];
            }
            if (j == i) {
                return this.diagIm[i];
            }
            if (j == i + 1) {
                return this.udiagIm[i];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(ComplexTridiagonalMatrix.getInvalidElementMsg(i, j));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setElement(int i, int j, Complex z) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) throw new MatrixDimensionException(ComplexTridiagonalMatrix.getInvalidElementMsg(i, j));
        if (j == i - 1) {
            this.ldiagRe[i] = z.real();
            this.ldiagIm[i] = z.imag();
            return;
        } else if (j == i) {
            this.diagRe[i] = z.real();
            this.diagIm[i] = z.imag();
            return;
        } else {
            if (j != i + 1) throw new MatrixDimensionException(ComplexTridiagonalMatrix.getInvalidElementMsg(i, j));
            this.udiagRe[i] = z.real();
            this.udiagIm[i] = z.imag();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setElement(int i, int j, double x, double y) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) throw new MatrixDimensionException(ComplexTridiagonalMatrix.getInvalidElementMsg(i, j));
        if (j == i - 1) {
            this.ldiagRe[i] = x;
            this.ldiagIm[i] = y;
            return;
        } else if (j == i) {
            this.diagRe[i] = x;
            this.diagIm[i] = y;
            return;
        } else {
            if (j != i + 1) throw new MatrixDimensionException(ComplexTridiagonalMatrix.getInvalidElementMsg(i, j));
            this.udiagRe[i] = x;
            this.udiagIm[i] = y;
        }
    }

    @Override
    public Complex trace() {
        double trRe = this.diagRe[0];
        double trIm = this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            trRe += this.diagRe[i];
            trIm += this.diagIm[i];
        }
        return new Complex(trRe, trIm);
    }

    @Override
    public double infNorm() {
        double tmpResult;
        int i;
        double result = Math.sqrt(this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0]) + Math.sqrt(this.udiagRe[0] * this.udiagRe[0] + this.udiagIm[0] * this.udiagIm[0]);
        for (i = 1; i < this.numRows - 1; ++i) {
            tmpResult = Math.sqrt(this.ldiagRe[i] * this.ldiagRe[i] + this.ldiagIm[i] * this.ldiagIm[i]) + Math.sqrt(this.diagRe[i] * this.diagRe[i] + this.diagIm[i] * this.diagIm[i]) + Math.sqrt(this.udiagRe[i] * this.udiagRe[i] + this.udiagIm[i] * this.udiagIm[i]);
            if (!(tmpResult > result)) continue;
            result = tmpResult;
        }
        tmpResult = Math.sqrt(this.ldiagRe[i] * this.ldiagRe[i] + this.ldiagIm[i] * this.ldiagIm[i]) + Math.sqrt(this.diagRe[i] * this.diagRe[i] + this.diagIm[i] * this.diagIm[i]);
        if (tmpResult > result) {
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        int i;
        double result = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0] + this.udiagRe[0] * this.udiagRe[0] + this.udiagIm[0] * this.udiagIm[0];
        for (i = 1; i < this.numRows - 1; ++i) {
            result += this.ldiagRe[i] * this.ldiagRe[i] + this.ldiagIm[i] * this.ldiagIm[i] + this.diagRe[i] * this.diagRe[i] + this.diagIm[i] * this.diagIm[i] + this.udiagRe[i] * this.udiagRe[i] + this.udiagIm[i] * this.udiagIm[i];
        }
        return Math.sqrt(result += this.ldiagRe[i] * this.ldiagRe[i] + this.ldiagIm[i] * this.ldiagIm[i] + this.diagRe[i] * this.diagRe[i] + this.diagIm[i] * this.diagIm[i]);
    }

    @Override
    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveHermitian((ComplexTridiagonalMatrix)this.hermitianAdjoint().multiply(this))));
    }

    @Override
    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix m) {
        if (m instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.addTridiagonal(m);
        }
        if (m instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                Complex elem = this.getElement(i, 0).add(m.getElement(i, 0));
                arrayRe[i][0] = elem.real();
                arrayIm[i][0] = elem.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    elem = this.getElement(i, j).add(m.getElement(i, j));
                    arrayRe[i][j] = elem.real();
                    arrayIm[i][j] = elem.imag();
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] arrayRe = new double[this.numRows][this.numRows];
            double[][] arrayIm = new double[this.numRows][this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                System.arraycopy(m.matrixRe[i], 0, arrayRe[i], 0, this.numRows);
                System.arraycopy(m.matrixIm[i], 0, arrayIm[i], 0, this.numRows);
            }
            double[] dArray = arrayRe[0];
            dArray[0] = dArray[0] + this.diagRe[0];
            double[] dArray2 = arrayIm[0];
            dArray2[0] = dArray2[0] + this.diagIm[0];
            double[] dArray3 = arrayRe[0];
            dArray3[1] = dArray3[1] + this.udiagRe[0];
            double[] dArray4 = arrayIm[0];
            dArray4[1] = dArray4[1] + this.udiagIm[0];
            int n = this.numCols - 1;
            for (int i = 1; i < n; ++i) {
                double[] dArray5 = arrayRe[i];
                int n2 = i - 1;
                dArray5[n2] = dArray5[n2] + this.ldiagRe[i];
                double[] dArray6 = arrayIm[i];
                int n3 = i - 1;
                dArray6[n3] = dArray6[n3] + this.ldiagIm[i];
                double[] dArray7 = arrayRe[i];
                int n4 = i;
                dArray7[n4] = dArray7[n4] + this.diagRe[i];
                double[] dArray8 = arrayIm[i];
                int n5 = i;
                dArray8[n5] = dArray8[n5] + this.diagIm[i];
                double[] dArray9 = arrayRe[i];
                int n6 = i + 1;
                dArray9[n6] = dArray9[n6] + this.udiagRe[i];
                double[] dArray10 = arrayIm[i];
                int n7 = i + 1;
                dArray10[n7] = dArray10[n7] + this.udiagIm[i];
            }
            double[] dArray11 = arrayRe[n];
            int n8 = n - 1;
            dArray11[n8] = dArray11[n8] + this.ldiagRe[n];
            double[] dArray12 = arrayIm[n];
            int n9 = n - 1;
            dArray12[n9] = dArray12[n9] + this.ldiagIm[n];
            double[] dArray13 = arrayRe[n];
            int n10 = n;
            dArray13[n10] = dArray13[n10] + this.diagRe[n];
            double[] dArray14 = arrayIm[n];
            int n11 = n;
            dArray14[n11] = dArray14[n11] + this.diagIm[n];
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.numRows) {
            ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
            ans.diagRe[0] = this.diagRe[0] + m.diagRe[0];
            ans.diagIm[0] = this.diagIm[0] + m.diagIm[0];
            ans.udiagRe[0] = this.udiagRe[0] + m.udiagRe[0];
            ans.udiagIm[0] = this.udiagIm[0] + m.udiagIm[0];
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiagRe[i] = this.ldiagRe[i] + m.ldiagRe[i];
                ans.ldiagIm[i] = this.ldiagIm[i] + m.ldiagIm[i];
                ans.diagRe[i] = this.diagRe[i] + m.diagRe[i];
                ans.diagIm[i] = this.diagIm[i] + m.diagIm[i];
                ans.udiagRe[i] = this.udiagRe[i] + m.udiagRe[i];
                ans.udiagIm[i] = this.udiagIm[i] + m.udiagIm[i];
            }
            ans.ldiagRe[mRow] = this.ldiagRe[mRow] + m.ldiagRe[mRow];
            ans.ldiagIm[mRow] = this.ldiagIm[mRow] + m.ldiagIm[mRow];
            ans.diagRe[mRow] = this.diagRe[mRow] + m.diagRe[mRow];
            ans.diagIm[mRow] = this.diagIm[mRow] + m.diagIm[mRow];
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix addTridiagonal(AbstractComplexSquareMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.rows()) {
            ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
            Complex elem = m.getElement(0, 0);
            ans.diagRe[0] = this.diagRe[0] + elem.real();
            ans.diagIm[0] = this.diagIm[0] + elem.imag();
            elem = m.getElement(0, 1);
            ans.udiagRe[0] = this.udiagRe[0] + elem.real();
            ans.udiagIm[0] = this.udiagIm[0] + elem.imag();
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                elem = m.getElement(i, i - 1);
                ans.ldiagRe[i] = this.ldiagRe[i] + elem.real();
                ans.ldiagIm[i] = this.ldiagIm[i] + elem.imag();
                elem = m.getElement(i, i);
                ans.diagRe[i] = this.diagRe[i] + elem.real();
                ans.diagIm[i] = this.diagIm[i] + elem.imag();
                elem = m.getElement(i, i + 1);
                ans.udiagRe[i] = this.udiagRe[i] + elem.real();
                ans.udiagIm[i] = this.udiagIm[i] + elem.imag();
            }
            elem = m.getElement(mRow, mRow - 1);
            ans.ldiagRe[mRow] = this.ldiagRe[mRow] + elem.real();
            ans.ldiagIm[mRow] = this.ldiagIm[mRow] + elem.imag();
            elem = m.getElement(mRow, mRow);
            ans.diagRe[mRow] = this.diagRe[mRow] + elem.real();
            ans.diagIm[mRow] = this.diagIm[mRow] + elem.imag();
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix m) {
        if (m instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(m);
        }
        if (m instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                Complex elem = this.getElement(i, 0).subtract(m.getElement(i, 0));
                arrayRe[i][0] = elem.real();
                arrayIm[i][0] = elem.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    elem = this.getElement(i, j).subtract(m.getElement(i, j));
                    arrayRe[i][j] = elem.real();
                    arrayIm[i][j] = elem.imag();
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                Complex elem = this.getElement(i, 0);
                arrayRe[i][0] = elem.real() - m.matrixRe[i][0];
                arrayIm[i][0] = elem.imag() - m.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    elem = this.getElement(i, j);
                    arrayRe[i][j] = elem.real() - m.matrixRe[i][j];
                    arrayIm[i][j] = elem.imag() - m.matrixIm[i][j];
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.numRows) {
            ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
            ans.diagRe[0] = this.diagRe[0] - m.diagRe[0];
            ans.diagIm[0] = this.diagIm[0] - m.diagIm[0];
            ans.udiagRe[0] = this.udiagRe[0] - m.udiagRe[0];
            ans.udiagIm[0] = this.udiagIm[0] - m.udiagIm[0];
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiagRe[i] = this.ldiagRe[i] - m.ldiagRe[i];
                ans.ldiagIm[i] = this.ldiagIm[i] - m.ldiagIm[i];
                ans.diagRe[i] = this.diagRe[i] - m.diagRe[i];
                ans.diagIm[i] = this.diagIm[i] - m.diagIm[i];
                ans.udiagRe[i] = this.udiagRe[i] - m.udiagRe[i];
                ans.udiagIm[i] = this.udiagIm[i] - m.udiagIm[i];
            }
            ans.ldiagRe[mRow] = this.ldiagRe[mRow] - m.ldiagRe[mRow];
            ans.ldiagIm[mRow] = this.ldiagIm[mRow] - m.ldiagIm[mRow];
            ans.diagRe[mRow] = this.diagRe[mRow] - m.diagRe[mRow];
            ans.diagIm[mRow] = this.diagIm[mRow] - m.diagIm[mRow];
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix subtractTridiagonal(AbstractComplexSquareMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.rows()) {
            ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
            Complex elem = m.getElement(0, 0);
            ans.diagRe[0] = this.diagRe[0] - elem.real();
            ans.diagIm[0] = this.diagIm[0] - elem.imag();
            elem = m.getElement(0, 1);
            ans.udiagRe[0] = this.udiagRe[0] - elem.real();
            ans.udiagIm[0] = this.udiagIm[0] - elem.imag();
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                elem = m.getElement(i, i - 1);
                ans.ldiagRe[i] = this.ldiagRe[i] - elem.real();
                ans.ldiagIm[i] = this.ldiagIm[i] - elem.imag();
                elem = m.getElement(i, i);
                ans.diagRe[i] = this.diagRe[i] - elem.real();
                ans.diagIm[i] = this.diagIm[i] - elem.imag();
                elem = m.getElement(i, i + 1);
                ans.udiagRe[i] = this.udiagRe[i] - elem.real();
                ans.udiagIm[i] = this.udiagIm[i] - elem.imag();
            }
            elem = m.getElement(mRow, mRow - 1);
            ans.ldiagRe[mRow] = this.ldiagRe[mRow] - elem.real();
            ans.ldiagIm[mRow] = this.ldiagIm[mRow] - elem.imag();
            elem = m.getElement(mRow, mRow);
            ans.diagRe[mRow] = this.diagRe[mRow] - elem.real();
            ans.diagIm[mRow] = this.diagIm[mRow] - elem.imag();
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractComplexMatrix scalarMultiply(Complex z) {
        double real = z.real();
        double imag = z.imag();
        int mRow = this.numRows;
        ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
        ans.diagRe[0] = real * this.diagRe[0] - imag * this.diagIm[0];
        ans.diagIm[0] = imag * this.diagRe[0] + real * this.diagIm[0];
        ans.udiagRe[0] = real * this.udiagRe[0] - imag * this.udiagIm[0];
        ans.udiagIm[0] = imag * this.udiagRe[0] + real * this.udiagIm[0];
        --mRow;
        for (int i = 1; i < mRow; ++i) {
            ans.ldiagRe[i] = real * this.ldiagRe[i] - imag * this.ldiagIm[i];
            ans.ldiagIm[i] = imag * this.ldiagRe[i] + real * this.ldiagIm[i];
            ans.diagRe[i] = real * this.diagRe[i] - imag * this.diagIm[i];
            ans.diagIm[i] = imag * this.diagRe[i] + real * this.diagIm[i];
            ans.udiagRe[i] = real * this.udiagRe[i] - imag * this.udiagIm[i];
            ans.udiagIm[i] = imag * this.udiagRe[i] + real * this.udiagIm[i];
        }
        ans.ldiagRe[mRow] = real * this.ldiagRe[mRow] - imag * this.ldiagIm[mRow];
        ans.ldiagIm[mRow] = imag * this.ldiagRe[mRow] + real * this.ldiagIm[mRow];
        ans.diagRe[mRow] = real * this.diagRe[mRow] - imag * this.diagIm[mRow];
        ans.diagIm[mRow] = imag * this.diagRe[mRow] + real * this.diagIm[mRow];
        return ans;
    }

    @Override
    public AbstractComplexMatrix scalarMultiply(double x) {
        int mRow = this.numRows;
        ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
        ans.diagRe[0] = x * this.diagRe[0];
        ans.diagIm[0] = x * this.diagIm[0];
        ans.udiagRe[0] = x * this.udiagRe[0];
        ans.udiagIm[0] = x * this.udiagIm[0];
        --mRow;
        for (int i = 1; i < mRow; ++i) {
            ans.ldiagRe[i] = x * this.ldiagRe[i];
            ans.ldiagIm[i] = x * this.ldiagIm[i];
            ans.diagRe[i] = x * this.diagRe[i];
            ans.diagIm[i] = x * this.diagIm[i];
            ans.udiagRe[i] = x * this.udiagRe[i];
            ans.udiagIm[i] = x * this.udiagIm[i];
        }
        ans.ldiagRe[mRow] = x * this.ldiagRe[mRow];
        ans.ldiagIm[mRow] = x * this.ldiagIm[mRow];
        ans.diagRe[mRow] = x * this.diagRe[mRow];
        ans.diagIm[mRow] = x * this.diagIm[mRow];
        return ans;
    }

    @Override
    public AbstractComplexVector multiply(AbstractComplexVector v) {
        int mRow = this.numRows;
        if (mRow == v.dimension()) {
            double[] arrayRe = new double[mRow];
            double[] arrayIm = new double[mRow];
            Complex comp = v.getComponent(0);
            arrayRe[0] = this.diagRe[0] * comp.real() - this.diagIm[0] * comp.imag();
            arrayIm[0] = this.diagIm[0] * comp.real() + this.diagRe[0] * comp.imag();
            comp = v.getComponent(1);
            arrayRe[0] = arrayRe[0] + (this.udiagRe[0] * comp.real() - this.udiagIm[0] * comp.imag());
            arrayIm[0] = arrayIm[0] + (this.udiagIm[0] * comp.real() + this.udiagRe[0] * comp.imag());
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                comp = v.getComponent(i - 1);
                arrayRe[i] = this.ldiagRe[i] * comp.real() - this.ldiagIm[i] * comp.imag();
                arrayIm[i] = this.ldiagIm[i] * comp.real() + this.ldiagRe[i] * comp.imag();
                comp = v.getComponent(i);
                int n = i;
                arrayRe[n] = arrayRe[n] + (this.diagRe[i] * comp.real() - this.diagIm[i] * comp.imag());
                int n2 = i;
                arrayIm[n2] = arrayIm[n2] + (this.diagIm[i] * comp.real() + this.diagRe[i] * comp.imag());
                comp = v.getComponent(i + 1);
                int n3 = i;
                arrayRe[n3] = arrayRe[n3] + (this.udiagRe[i] * comp.real() - this.udiagIm[i] * comp.imag());
                int n4 = i;
                arrayIm[n4] = arrayIm[n4] + (this.udiagIm[i] * comp.real() + this.udiagRe[i] * comp.imag());
            }
            comp = v.getComponent(mRow - 1);
            arrayRe[mRow] = this.ldiagRe[mRow] * comp.real() - this.ldiagIm[mRow] * comp.imag();
            arrayIm[mRow] = this.ldiagIm[mRow] * comp.real() + this.ldiagRe[mRow] * comp.imag();
            comp = v.getComponent(mRow);
            int n = mRow;
            arrayRe[n] = arrayRe[n] + (this.diagRe[mRow] * comp.real() - this.diagIm[mRow] * comp.imag());
            int n5 = mRow;
            arrayIm[n5] = arrayIm[n5] + (this.diagIm[mRow] * comp.real() + this.diagRe[mRow] * comp.imag());
            return new ComplexVector(arrayRe, arrayIm);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix m) {
        if (m instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(m);
        }
        if (m instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)m);
        }
        if (this.numCols == m.rows()) {
            int mColumns = m.columns();
            double[][] arrayRe = new double[this.numRows][mColumns];
            double[][] arrayIm = new double[this.numRows][mColumns];
            int lastRow = this.numRows - 1;
            for (int j = 0; j < this.numRows; ++j) {
                arrayRe[0][j] = this.diagRe[0] * m.getRealElement(0, j) - this.diagIm[0] * m.getImagElement(0, j) + (this.udiagRe[0] * m.getRealElement(1, j) - this.udiagIm[0] * m.getImagElement(1, j));
                arrayIm[0][j] = this.diagIm[0] * m.getRealElement(0, j) + this.diagRe[0] * m.getImagElement(0, j) + (this.udiagIm[0] * m.getRealElement(1, j) + this.udiagRe[0] * m.getImagElement(1, j));
                for (int i = 1; i < lastRow; ++i) {
                    arrayRe[i][j] = this.ldiagRe[i] * m.getRealElement(i - 1, j) - this.ldiagIm[i] * m.getImagElement(i - 1, j) + (this.diagRe[i] * m.getRealElement(i, j) - this.diagIm[i] * m.getImagElement(i, j)) + (this.udiagRe[i] * m.getRealElement(i + 1, j) - this.udiagIm[i] * m.getImagElement(i + 1, j));
                    arrayIm[i][j] = this.ldiagIm[i] * m.getRealElement(i - 1, j) + this.ldiagRe[i] * m.getImagElement(i - 1, j) + (this.diagIm[i] * m.getRealElement(i, j) + this.diagRe[i] * m.getImagElement(i, j)) + (this.udiagIm[i] * m.getRealElement(i + 1, j) + this.udiagRe[i] * m.getImagElement(i + 1, j));
                }
                arrayRe[lastRow][j] = this.ldiagRe[lastRow] * m.getRealElement(lastRow - 1, j) - this.ldiagIm[lastRow] * m.getImagElement(lastRow - 1, j) + (this.diagRe[lastRow] * m.getRealElement(lastRow, j) - this.diagIm[lastRow] * m.getImagElement(lastRow, j));
                arrayIm[lastRow][j] = this.ldiagIm[lastRow] * m.getRealElement(lastRow - 1, j) + this.ldiagRe[lastRow] * m.getImagElement(lastRow - 1, j) + (this.diagIm[lastRow] * m.getRealElement(lastRow, j) + this.diagRe[lastRow] * m.getImagElement(lastRow, j));
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix m) {
        if (this.numCols == m.numRows) {
            double[][] arrayRe = new double[this.numRows][m.numCols];
            double[][] arrayIm = new double[this.numRows][m.numCols];
            int lastRow = this.numRows - 1;
            for (int j = 0; j < this.numRows; ++j) {
                arrayRe[0][j] = this.diagRe[0] * m.matrixRe[0][j] - this.diagIm[0] * m.matrixIm[0][j] + (this.udiagRe[0] * m.matrixRe[1][j] - this.udiagIm[0] * m.matrixIm[1][j]);
                arrayIm[0][j] = this.diagIm[0] * m.matrixRe[0][j] + this.diagRe[0] * m.matrixIm[0][j] + (this.udiagIm[0] * m.matrixRe[1][j] + this.udiagRe[0] * m.matrixIm[1][j]);
                for (int i = 1; i < lastRow; ++i) {
                    arrayRe[i][j] = this.ldiagRe[i] * m.matrixRe[i - 1][j] - this.ldiagIm[i] * m.matrixIm[i - 1][j] + (this.diagRe[i] * m.matrixRe[i][j] - this.diagIm[i] * m.matrixIm[i][j]) + (this.udiagRe[i] * m.matrixRe[i + 1][j] - this.udiagIm[i] * m.matrixIm[i + 1][j]);
                    arrayIm[i][j] = this.ldiagIm[i] * m.matrixRe[i - 1][j] + this.ldiagRe[i] * m.matrixIm[i - 1][j] + (this.diagIm[i] * m.matrixRe[i][j] + this.diagRe[i] * m.matrixIm[i][j]) + (this.udiagIm[i] * m.matrixRe[i + 1][j] + this.udiagRe[i] * m.matrixIm[i + 1][j]);
                }
                arrayRe[lastRow][j] = this.ldiagRe[lastRow] * m.matrixRe[lastRow - 1][j] - this.ldiagIm[lastRow] * m.matrixIm[lastRow - 1][j] + (this.diagRe[lastRow] * m.matrixRe[lastRow][j] - this.diagIm[lastRow] * m.matrixIm[lastRow][j]);
                arrayIm[lastRow][j] = this.ldiagIm[lastRow] * m.matrixRe[lastRow - 1][j] + this.ldiagRe[lastRow] * m.matrixIm[lastRow - 1][j] + (this.diagIm[lastRow] * m.matrixRe[lastRow][j] + this.diagRe[lastRow] * m.matrixIm[lastRow][j]);
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (this.numCols == m.numRows) {
            double[][] arrayRe = new double[mRow][mRow];
            double[][] arrayIm = new double[mRow][mRow];
            arrayRe[0][0] = this.diagRe[0] * m.diagRe[0] - this.diagIm[0] * m.diagIm[0] + (this.udiagRe[0] * m.ldiagRe[1] - this.udiagIm[0] * m.ldiagIm[1]);
            arrayIm[0][0] = this.diagIm[0] * m.diagRe[0] + this.diagRe[0] * m.diagIm[0] + (this.udiagIm[0] * m.ldiagRe[1] + this.udiagRe[0] * m.ldiagIm[1]);
            arrayRe[0][1] = this.diagRe[0] * m.udiagRe[0] - this.diagIm[0] * m.udiagIm[0] + (this.udiagRe[0] * m.diagRe[1] - this.udiagIm[0] * m.diagIm[1]);
            arrayIm[0][1] = this.diagIm[0] * m.udiagRe[0] + this.diagRe[0] * m.udiagIm[0] + (this.udiagIm[0] * m.diagRe[1] + this.udiagRe[0] * m.diagIm[1]);
            arrayRe[0][2] = this.udiagRe[0] * m.udiagRe[1] - this.udiagIm[0] * m.udiagIm[1];
            arrayIm[0][2] = this.udiagIm[0] * m.udiagRe[1] + this.udiagRe[0] * m.udiagIm[1];
            if (mRow > 3) {
                arrayRe[1][0] = this.ldiagRe[1] * m.diagRe[0] - this.ldiagIm[1] * m.diagIm[0] + (this.diagRe[1] * m.ldiagRe[1] - this.diagIm[1] * m.ldiagIm[1]);
                arrayIm[1][0] = this.ldiagIm[1] * m.diagRe[0] + this.ldiagRe[1] * m.diagIm[0] + (this.diagIm[1] * m.ldiagRe[1] + this.diagRe[1] * m.ldiagIm[1]);
                arrayRe[1][1] = this.ldiagRe[1] * m.udiagRe[0] - this.ldiagIm[1] * m.udiagIm[0] + (this.diagRe[1] * m.diagRe[1] - this.diagIm[1] * m.diagIm[1]) + (this.udiagRe[1] * m.ldiagRe[2] - this.udiagIm[1] * m.ldiagIm[2]);
                arrayIm[1][1] = this.ldiagIm[1] * m.udiagRe[0] + this.ldiagRe[1] * m.udiagIm[0] + (this.diagIm[1] * m.diagRe[1] + this.diagRe[1] * m.diagIm[1]) + (this.udiagIm[1] * m.ldiagRe[2] + this.udiagRe[1] * m.ldiagIm[2]);
                arrayRe[1][2] = this.diagRe[1] * m.udiagRe[1] - this.diagIm[1] * m.udiagIm[1] + (this.udiagRe[1] * m.diagRe[2] - this.udiagIm[1] * m.diagIm[2]);
                arrayIm[1][2] = this.diagIm[1] * m.udiagRe[1] + this.diagRe[1] * m.udiagIm[1] + (this.udiagIm[1] * m.diagRe[2] + this.udiagRe[1] * m.diagIm[2]);
                arrayRe[1][3] = this.udiagRe[1] * m.udiagRe[2] - this.udiagIm[1] * m.udiagIm[2];
                arrayIm[1][3] = this.udiagIm[1] * m.udiagRe[2] + this.udiagRe[1] * m.udiagIm[2];
            }
            if (mRow == 3) {
                arrayRe[1][0] = this.ldiagRe[1] * m.diagRe[0] - this.ldiagIm[1] * m.diagIm[0] + (this.diagRe[1] * m.ldiagRe[1] - this.diagIm[1] * m.ldiagIm[1]);
                arrayIm[1][0] = this.ldiagIm[1] * m.diagRe[0] + this.ldiagRe[1] * m.diagIm[0] + (this.diagIm[1] * m.ldiagRe[1] + this.diagRe[1] * m.ldiagIm[1]);
                arrayRe[1][1] = this.ldiagRe[1] * m.udiagRe[0] - this.ldiagIm[1] * m.udiagIm[0] + (this.diagRe[1] * m.diagRe[1] - this.diagIm[1] * m.diagIm[1]) + (this.udiagRe[1] * m.ldiagRe[2] - this.udiagIm[1] * m.ldiagIm[2]);
                arrayIm[1][1] = this.ldiagIm[1] * m.udiagRe[0] + this.ldiagRe[1] * m.udiagIm[0] + (this.diagIm[1] * m.diagRe[1] + this.diagRe[1] * m.diagIm[1]) + (this.udiagIm[1] * m.ldiagRe[2] + this.udiagRe[1] * m.ldiagIm[2]);
                arrayRe[1][2] = this.diagRe[1] * m.udiagRe[1] - this.diagIm[1] * m.udiagIm[1] + (this.udiagRe[1] * m.diagRe[2] - this.udiagIm[1] * m.diagIm[2]);
                arrayIm[1][2] = this.diagIm[1] * m.udiagRe[1] + this.diagRe[1] * m.udiagIm[1] + (this.udiagIm[1] * m.diagRe[2] + this.udiagRe[1] * m.diagIm[2]);
            } else if (mRow > 4) {
                for (int i = 2; i < mRow - 2; ++i) {
                    arrayRe[i][i - 2] = this.ldiagRe[i] * m.ldiagRe[i - 1] - this.ldiagIm[i] * m.ldiagIm[i - 1];
                    arrayIm[i][i - 2] = this.ldiagIm[i] * m.ldiagRe[i - 1] + this.ldiagRe[i] * m.ldiagIm[i - 1];
                    arrayRe[i][i - 1] = this.ldiagRe[i] * m.diagRe[i - 1] - this.ldiagIm[i] * m.diagIm[i - 1] + (this.diagRe[i] * m.ldiagRe[i] - this.diagIm[i] * m.ldiagIm[i]);
                    arrayIm[i][i - 1] = this.ldiagIm[i] * m.diagRe[i - 1] + this.ldiagRe[i] * m.diagIm[i - 1] + (this.diagIm[i] * m.ldiagRe[i] + this.diagRe[i] * m.ldiagIm[i]);
                    arrayRe[i][i] = this.ldiagRe[i] * m.udiagRe[i - 1] - this.ldiagIm[i] * m.udiagIm[i - 1] + (this.diagRe[i] * m.diagRe[i] - this.diagIm[i] * m.diagIm[i]) + (this.udiagRe[i] * m.ldiagRe[i + 1] - this.udiagIm[i] * m.ldiagIm[i + 1]);
                    arrayIm[i][i] = this.ldiagIm[i] * m.udiagRe[i - 1] + this.ldiagRe[i] * m.udiagIm[i - 1] + (this.diagIm[i] * m.diagRe[i] + this.diagRe[i] * m.diagIm[i]) + (this.udiagIm[i] * m.ldiagRe[i + 1] + this.udiagRe[i] * m.ldiagIm[i + 1]);
                    arrayRe[i][i + 1] = this.diagRe[i] * m.udiagRe[i] - this.diagIm[i] * m.udiagIm[i] + (this.udiagRe[i] * m.diagRe[i + 1] - this.udiagIm[i] * m.diagIm[i + 1]);
                    arrayIm[i][i + 1] = this.diagIm[i] * m.udiagRe[i] + this.diagRe[i] * m.udiagIm[i] + (this.udiagIm[i] * m.diagRe[i + 1] + this.udiagRe[i] * m.diagIm[i + 1]);
                    arrayRe[i][i + 2] = this.udiagRe[i] * m.udiagRe[i + 1] - this.udiagIm[i] * m.udiagIm[i + 1];
                    arrayIm[i][i + 2] = this.udiagIm[i] * m.udiagRe[i + 1] + this.udiagRe[i] * m.udiagIm[i + 1];
                }
            }
            if (mRow > 3) {
                arrayRe[mRow - 2][mRow - 4] = this.ldiagRe[mRow - 2] * m.ldiagRe[mRow - 3] - this.ldiagIm[mRow - 2] * m.ldiagIm[mRow - 3];
                arrayIm[mRow - 2][mRow - 4] = this.ldiagIm[mRow - 2] * m.ldiagRe[mRow - 3] + this.ldiagRe[mRow - 2] * m.ldiagIm[mRow - 3];
                arrayRe[mRow - 2][mRow - 3] = this.ldiagRe[mRow - 2] * m.diagRe[mRow - 3] - this.ldiagIm[mRow - 2] * m.diagIm[mRow - 3] + (this.diagRe[mRow - 2] * m.ldiagRe[mRow - 2] - this.diagIm[mRow - 2] * m.ldiagIm[mRow - 2]);
                arrayIm[mRow - 2][mRow - 3] = this.ldiagIm[mRow - 2] * m.diagRe[mRow - 3] + this.ldiagRe[mRow - 2] * m.diagIm[mRow - 3] + (this.diagIm[mRow - 2] * m.ldiagRe[mRow - 2] + this.diagRe[mRow - 2] * m.ldiagIm[mRow - 2]);
                arrayRe[mRow - 2][mRow - 2] = this.ldiagRe[mRow - 2] * m.udiagRe[mRow - 3] - this.ldiagIm[mRow - 2] * m.udiagIm[mRow - 3] + (this.diagRe[mRow - 2] * m.diagRe[mRow - 2] - this.diagIm[mRow - 2] * m.diagIm[mRow - 2]) + (this.udiagRe[mRow - 2] * m.ldiagRe[mRow - 1] - this.udiagIm[mRow - 2] * m.ldiagIm[mRow - 1]);
                arrayIm[mRow - 2][mRow - 2] = this.ldiagIm[mRow - 2] * m.udiagRe[mRow - 3] + this.ldiagRe[mRow - 2] * m.udiagIm[mRow - 3] + (this.diagIm[mRow - 2] * m.diagRe[mRow - 2] + this.diagRe[mRow - 2] * m.diagIm[mRow - 2]) + (this.udiagIm[mRow - 2] * m.ldiagRe[mRow - 1] + this.udiagRe[mRow - 2] * m.ldiagIm[mRow - 1]);
                arrayRe[mRow - 2][mRow - 1] = this.diagRe[mRow - 2] * m.udiagRe[mRow - 2] - this.diagIm[mRow - 2] * m.udiagIm[mRow - 2] + (this.udiagRe[mRow - 2] * m.diagRe[mRow - 1] - this.udiagIm[mRow - 2] * m.diagIm[mRow - 1]);
                arrayIm[mRow - 2][mRow - 1] = this.diagIm[mRow - 2] * m.udiagRe[mRow - 2] + this.diagRe[mRow - 2] * m.udiagIm[mRow - 2] + (this.udiagIm[mRow - 2] * m.diagRe[mRow - 1] + this.udiagRe[mRow - 2] * m.diagIm[mRow - 1]);
            }
            arrayRe[mRow][--mRow - 2] = this.ldiagRe[mRow] * m.ldiagRe[mRow - 1] - this.ldiagIm[mRow] * m.ldiagIm[mRow - 1];
            arrayIm[mRow][mRow - 2] = this.ldiagIm[mRow] * m.ldiagRe[mRow - 1] + this.ldiagRe[mRow] * m.ldiagIm[mRow - 1];
            arrayRe[mRow][mRow - 1] = this.ldiagRe[mRow] * m.diagRe[mRow - 1] - this.ldiagIm[mRow] * m.diagIm[mRow - 1] + (this.diagRe[mRow] * m.ldiagRe[mRow] - this.diagIm[mRow] * m.ldiagIm[mRow]);
            arrayIm[mRow][mRow - 1] = this.ldiagIm[mRow] * m.diagRe[mRow - 1] + this.ldiagRe[mRow] * m.diagIm[mRow - 1] + (this.diagIm[mRow] * m.ldiagRe[mRow] + this.diagRe[mRow] * m.ldiagIm[mRow]);
            arrayRe[mRow][mRow] = this.ldiagRe[mRow] * m.udiagRe[mRow - 1] - this.ldiagIm[mRow] * m.udiagIm[mRow - 1] + (this.diagRe[mRow] * m.diagRe[mRow] - this.diagIm[mRow] * m.diagIm[mRow]);
            arrayIm[mRow][mRow] = this.ldiagIm[mRow] * m.udiagRe[mRow - 1] + this.ldiagRe[mRow] * m.udiagIm[mRow - 1] + (this.diagIm[mRow] * m.diagRe[mRow] + this.diagRe[mRow] * m.diagIm[mRow]);
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexSquareMatrix multiplyTridiagonal(AbstractComplexSquareMatrix m) {
        int mRow = this.numRows;
        if (this.numCols == m.rows()) {
            Complex elem3;
            double[][] arrayRe = new double[mRow][mRow];
            double[][] arrayIm = new double[mRow][mRow];
            Complex elem1 = m.getElement(0, 0);
            Complex elem2 = m.getElement(1, 0);
            arrayRe[0][0] = this.diagRe[0] * elem1.real() - this.diagIm[0] * elem1.imag() + (this.udiagRe[0] * elem2.real() - this.udiagIm[0] * elem2.imag());
            arrayIm[0][0] = this.diagIm[0] * elem1.real() + this.diagRe[0] * elem1.imag() + (this.udiagIm[0] * elem2.real() + this.udiagRe[0] * elem2.imag());
            elem1 = m.getElement(0, 1);
            elem2 = m.getElement(1, 1);
            arrayRe[0][1] = this.diagRe[0] * elem1.real() - this.diagIm[0] * elem1.imag() + (this.udiagRe[0] * elem2.real() - this.udiagIm[0] * elem2.imag());
            arrayIm[0][1] = this.diagIm[0] * elem1.real() + this.diagRe[0] * elem1.imag() + (this.udiagIm[0] * elem2.real() + this.udiagRe[0] * elem2.imag());
            elem1 = m.getElement(1, 2);
            arrayRe[0][2] = this.udiagRe[0] * elem1.real() - this.udiagIm[0] * elem1.imag();
            arrayIm[0][2] = this.udiagIm[0] * elem1.real() + this.udiagRe[0] * elem1.imag();
            if (mRow > 3) {
                elem1 = m.getElement(0, 0);
                elem2 = m.getElement(1, 0);
                arrayRe[1][0] = this.ldiagRe[1] * elem1.real() - this.ldiagIm[1] * elem1.imag() + (this.diagRe[1] * elem2.real() - this.diagIm[1] * elem2.imag());
                arrayIm[1][0] = this.ldiagIm[1] * elem1.real() + this.ldiagRe[1] * elem1.imag() + (this.diagIm[1] * elem2.real() + this.diagRe[1] * elem2.imag());
                elem1 = m.getElement(0, 1);
                elem2 = m.getElement(1, 1);
                elem3 = m.getElement(2, 1);
                arrayRe[1][1] = this.ldiagRe[1] * elem1.real() - this.ldiagIm[1] * elem1.imag() + (this.diagRe[1] * elem2.real() - this.diagIm[1] * elem2.imag()) + (this.udiagRe[1] * elem3.real() - this.udiagIm[1] * elem3.imag());
                arrayIm[1][1] = this.ldiagIm[1] * elem1.real() + this.ldiagRe[1] * elem1.imag() + (this.diagIm[1] * elem2.real() + this.diagRe[1] * elem2.imag()) + (this.udiagIm[1] * elem3.real() + this.udiagRe[1] * elem3.imag());
                elem1 = m.getElement(1, 2);
                elem2 = m.getElement(2, 2);
                arrayRe[1][2] = this.diagRe[1] * elem1.real() - this.diagIm[1] * elem1.imag() + (this.udiagRe[1] * elem2.real() - this.udiagIm[1] * elem2.imag());
                arrayIm[1][2] = this.diagIm[1] * elem1.real() + this.diagRe[1] * elem1.imag() + (this.udiagIm[1] * elem2.real() + this.udiagRe[1] * elem2.imag());
                elem1 = m.getElement(2, 3);
                arrayRe[1][3] = this.udiagRe[1] * elem1.real() - this.udiagIm[1] * elem1.imag();
                arrayIm[1][3] = this.udiagIm[1] * elem1.real() + this.udiagRe[1] * elem1.imag();
            }
            if (mRow == 3) {
                elem1 = m.getElement(0, 0);
                elem2 = m.getElement(1, 0);
                arrayRe[1][0] = this.ldiagRe[1] * elem1.real() - this.ldiagIm[1] * elem1.imag() + (this.diagRe[1] * elem2.real() - this.diagIm[1] * elem2.imag());
                arrayIm[1][0] = this.ldiagIm[1] * elem1.real() + this.ldiagRe[1] * elem1.imag() + (this.diagIm[1] * elem2.real() + this.diagRe[1] * elem2.imag());
                elem1 = m.getElement(0, 1);
                elem2 = m.getElement(1, 1);
                elem3 = m.getElement(2, 1);
                arrayRe[1][1] = this.ldiagRe[1] * elem1.real() - this.ldiagIm[1] * elem1.imag() + (this.diagRe[1] * elem2.real() - this.diagIm[1] * elem2.imag()) + (this.udiagRe[1] * elem3.real() - this.udiagIm[1] * elem3.imag());
                arrayIm[1][1] = this.ldiagIm[1] * elem1.real() + this.ldiagRe[1] * elem1.imag() + (this.diagIm[1] * elem2.real() + this.diagRe[1] * elem2.imag()) + (this.udiagIm[1] * elem3.real() + this.udiagRe[1] * elem3.imag());
                elem1 = m.getElement(1, 2);
                elem2 = m.getElement(2, 2);
                arrayRe[1][2] = this.diagRe[1] * elem1.real() - this.diagIm[1] * elem1.imag() + (this.udiagRe[1] * elem2.real() - this.udiagIm[1] * elem2.imag());
                arrayIm[1][2] = this.diagIm[1] * elem1.real() + this.diagRe[1] * elem1.imag() + (this.udiagIm[1] * elem2.real() + this.udiagRe[1] * elem2.imag());
            } else if (mRow > 4) {
                for (int i = 2; i < mRow - 2; ++i) {
                    elem1 = m.getElement(i - 1, i - 2);
                    arrayRe[i][i - 2] = this.ldiagRe[i] * elem1.real() - this.ldiagIm[i] * elem1.imag();
                    arrayIm[i][i - 2] = this.ldiagIm[i] * elem1.real() + this.ldiagRe[i] * elem1.imag();
                    elem1 = m.getElement(i - 1, i - 1);
                    elem2 = m.getElement(i, i - 1);
                    arrayRe[i][i - 1] = this.ldiagRe[i] * elem1.real() - this.ldiagIm[i] * elem1.imag() + (this.diagRe[i] * elem2.real() - this.diagIm[i] * elem2.imag());
                    arrayIm[i][i - 1] = this.ldiagIm[i] * elem1.real() + this.ldiagRe[i] * elem1.imag() + (this.diagIm[i] * elem2.real() + this.diagRe[i] * elem2.imag());
                    elem1 = m.getElement(i - 1, i);
                    elem2 = m.getElement(i, i);
                    elem3 = m.getElement(i + 1, i);
                    arrayRe[i][i] = this.ldiagRe[i] * elem1.real() - this.ldiagIm[i] * elem1.imag() + (this.diagRe[i] * elem2.real() - this.diagIm[i] * elem2.imag()) + (this.udiagRe[i] * elem3.real() - this.udiagIm[i] * elem3.imag());
                    arrayIm[i][i] = this.ldiagIm[i] * elem1.real() + this.ldiagRe[i] * elem1.imag() + (this.diagIm[i] * elem2.real() + this.diagRe[i] * elem2.imag()) + (this.udiagIm[i] * elem3.real() + this.udiagRe[i] * elem3.imag());
                    elem1 = m.getElement(i, i + 1);
                    elem2 = m.getElement(i + 1, i + 1);
                    arrayRe[i][i + 1] = this.diagRe[i] * elem1.real() - this.diagIm[i] * elem1.imag() + (this.udiagRe[i] * elem2.real() - this.udiagIm[i] * elem2.imag());
                    arrayIm[i][i + 1] = this.diagIm[i] * elem1.real() + this.diagRe[i] * elem1.imag() + (this.udiagIm[i] * elem2.real() + this.udiagRe[i] * elem2.imag());
                    elem1 = m.getElement(i + 1, i + 2);
                    arrayRe[i][i + 2] = this.udiagRe[i] * elem1.real() - this.udiagIm[i] * elem1.imag();
                    arrayIm[i][i + 2] = this.udiagIm[i] * elem1.real() + this.udiagRe[i] * elem1.imag();
                }
            }
            if (mRow > 3) {
                elem1 = m.getElement(mRow - 3, mRow - 4);
                arrayRe[mRow - 2][mRow - 4] = this.ldiagRe[mRow - 2] * elem1.real() - this.ldiagIm[mRow - 2] * elem1.imag();
                arrayIm[mRow - 2][mRow - 4] = this.ldiagIm[mRow - 2] * elem1.real() + this.ldiagRe[mRow - 2] * elem1.imag();
                elem1 = m.getElement(mRow - 3, mRow - 3);
                elem2 = m.getElement(mRow - 2, mRow - 3);
                arrayRe[mRow - 2][mRow - 3] = this.ldiagRe[mRow - 2] * elem1.real() - this.ldiagIm[mRow - 2] * elem1.imag() + (this.diagRe[mRow - 2] * elem2.real() - this.diagIm[mRow - 2] * elem2.imag());
                arrayIm[mRow - 2][mRow - 3] = this.ldiagIm[mRow - 2] * elem1.real() + this.ldiagRe[mRow - 2] * elem1.imag() + (this.diagIm[mRow - 2] * elem2.real() + this.diagRe[mRow - 2] * elem2.imag());
                elem1 = m.getElement(mRow - 3, mRow - 2);
                elem2 = m.getElement(mRow - 2, mRow - 2);
                elem3 = m.getElement(mRow - 1, mRow - 2);
                arrayRe[mRow - 2][mRow - 2] = this.ldiagRe[mRow - 2] * elem1.real() - this.ldiagIm[mRow - 2] * elem1.imag() + (this.diagRe[mRow - 2] * elem2.real() - this.diagIm[mRow - 2] * elem2.imag()) + (this.udiagRe[mRow - 2] * elem3.real() - this.udiagIm[mRow - 2] * elem3.imag());
                arrayIm[mRow - 2][mRow - 2] = this.ldiagIm[mRow - 2] * elem1.real() + this.ldiagRe[mRow - 2] * elem1.imag() + (this.diagIm[mRow - 2] * elem2.real() + this.diagRe[mRow - 2] * elem2.imag()) + (this.udiagIm[mRow - 2] * elem3.real() + this.udiagRe[mRow - 2] * elem3.imag());
                elem1 = m.getElement(mRow - 2, mRow - 1);
                elem2 = m.getElement(mRow - 1, mRow - 1);
                arrayRe[mRow - 2][mRow - 1] = this.diagRe[mRow - 2] * elem1.real() - this.diagIm[mRow - 2] * elem1.imag() + (this.udiagRe[mRow - 2] * elem2.real() - this.udiagIm[mRow - 2] * elem2.imag());
                arrayIm[mRow - 2][mRow - 1] = this.diagIm[mRow - 2] * elem1.real() + this.diagRe[mRow - 2] * elem1.imag() + (this.udiagIm[mRow - 2] * elem2.real() + this.udiagRe[mRow - 2] * elem2.imag());
            }
            elem1 = m.getElement(--mRow - 1, mRow - 2);
            arrayRe[mRow][mRow - 2] = this.ldiagRe[mRow] * elem1.real() - this.ldiagIm[mRow] * elem1.imag();
            arrayIm[mRow][mRow - 2] = this.ldiagIm[mRow] * elem1.real() + this.ldiagRe[mRow] * elem1.imag();
            elem1 = m.getElement(mRow - 1, mRow - 1);
            elem2 = m.getElement(mRow, mRow - 1);
            arrayRe[mRow][mRow - 1] = this.ldiagRe[mRow] * elem1.real() - this.ldiagIm[mRow] * elem1.imag() + (this.diagRe[mRow] * elem2.real() - this.diagIm[mRow] * elem2.imag());
            arrayIm[mRow][mRow - 1] = this.ldiagIm[mRow] * elem1.real() + this.ldiagRe[mRow] * elem1.imag() + (this.diagIm[mRow] * elem2.real() + this.diagRe[mRow] * elem2.imag());
            elem1 = m.getElement(mRow - 1, mRow);
            elem2 = m.getElement(mRow, mRow);
            arrayRe[mRow][mRow] = this.ldiagRe[mRow] * elem1.real() - this.ldiagIm[mRow] * elem1.imag() + (this.diagRe[mRow] * elem2.real() - this.diagIm[mRow] * elem2.imag());
            arrayIm[mRow][mRow] = this.ldiagIm[mRow] * elem1.real() + this.ldiagRe[mRow] * elem1.imag() + (this.diagIm[mRow] * elem2.real() + this.diagRe[mRow] * elem2.imag());
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public AbstractComplexMatrix hermitianAdjoint() {
        int mRow = this.numRows;
        ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
        System.arraycopy(this.ldiagRe, 1, ans.udiagRe, 0, this.ldiagRe.length - 1);
        System.arraycopy(this.diagRe, 0, ans.diagRe, 0, this.diagRe.length);
        System.arraycopy(this.udiagRe, 0, ans.ldiagRe, 1, this.udiagRe.length - 1);
        ans.diagIm[0] = -this.diagIm[0];
        ans.ldiagIm[1] = -this.udiagIm[0];
        --mRow;
        for (int i = 1; i < mRow; ++i) {
            ans.udiagIm[i - 1] = -this.ldiagIm[i];
            ans.diagIm[i] = -this.diagIm[i];
            ans.ldiagIm[i + 1] = -this.udiagIm[i];
        }
        ans.udiagIm[mRow - 1] = -this.ldiagIm[mRow];
        ans.diagIm[mRow] = -this.diagIm[mRow];
        return ans;
    }

    @Override
    public AbstractComplexMatrix conjugate() {
        int mRow = this.numRows;
        ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
        System.arraycopy(this.ldiagRe, 1, ans.ldiagRe, 0, this.ldiagRe.length - 1);
        System.arraycopy(this.diagRe, 0, ans.diagRe, 0, this.diagRe.length);
        System.arraycopy(this.udiagRe, 0, ans.udiagRe, 1, this.udiagRe.length - 1);
        ans.diagIm[0] = -this.diagIm[0];
        ans.udiagIm[0] = -this.udiagIm[0];
        --mRow;
        for (int i = 1; i < mRow; ++i) {
            ans.ldiagIm[i] = -this.ldiagIm[i];
            ans.diagIm[i] = -this.diagIm[i];
            ans.udiagIm[i] = -this.udiagIm[i];
        }
        ans.ldiagIm[mRow] = -this.ldiagIm[mRow];
        ans.diagIm[mRow] = -this.diagIm[mRow];
        return ans;
    }

    @Override
    public Matrix transpose() {
        ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(this.numRows);
        System.arraycopy(this.ldiagRe, 1, ans.udiagRe, 0, this.ldiagRe.length - 1);
        System.arraycopy(this.ldiagIm, 1, ans.udiagIm, 0, this.ldiagIm.length - 1);
        System.arraycopy(this.diagRe, 0, ans.diagRe, 0, this.diagRe.length);
        System.arraycopy(this.diagIm, 0, ans.diagIm, 0, this.diagIm.length);
        System.arraycopy(this.udiagRe, 0, ans.ldiagRe, 1, this.udiagRe.length - 1);
        System.arraycopy(this.udiagIm, 0, ans.ldiagIm, 1, this.udiagIm.length - 1);
        return ans;
    }

    @Override
    public AbstractComplexMatrix mapElements(ComplexMapping f) {
        Complex zeroValue = f.map(Complex.ZERO);
        if (zeroValue.mod() <= GlobalSettings.ZERO_TOL) {
            return this.tridiagonalMap(f);
        }
        return this.generalMap(f, zeroValue);
    }

    private AbstractComplexMatrix tridiagonalMap(ComplexMapping f) {
        int mRow = this.numRows;
        ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
        ans.setElement(0, 0, f.map(this.diagRe[0], this.diagIm[0]));
        ans.setElement(0, 1, f.map(this.udiagRe[0], this.udiagIm[0]));
        --mRow;
        for (int i = 1; i < mRow; ++i) {
            ans.setElement(i, i - 1, f.map(this.ldiagRe[i], this.ldiagIm[i]));
            ans.setElement(i, i, f.map(this.diagRe[i], this.diagIm[i]));
            ans.setElement(i, i + 1, f.map(this.udiagRe[i], this.udiagIm[i]));
        }
        ans.setElement(mRow, mRow - 1, f.map(this.ldiagRe[mRow], this.ldiagIm[mRow]));
        ans.setElement(mRow, mRow, f.map(this.diagRe[mRow], this.diagIm[mRow]));
        return ans;
    }

    private AbstractComplexMatrix generalMap(ComplexMapping f, Complex zeroValue) {
        double[][] arrayRe = new double[this.numRows][this.numRows];
        double[][] arrayIm = new double[this.numRows][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                arrayRe[i][j] = zeroValue.real();
                arrayIm[i][j] = zeroValue.imag();
            }
        }
        int mRow = this.numRows;
        Complex z = f.map(this.diagRe[0], this.diagIm[0]);
        arrayRe[0][0] = z.real();
        arrayIm[0][0] = z.imag();
        z = f.map(this.udiagRe[0], this.udiagIm[0]);
        arrayRe[0][1] = z.real();
        arrayIm[0][1] = z.imag();
        --mRow;
        for (int i = 1; i < mRow; ++i) {
            z = f.map(this.ldiagRe[i], this.ldiagIm[i]);
            arrayRe[i][i - 1] = z.real();
            arrayIm[i][i - 1] = z.imag();
            z = f.map(this.diagRe[i], this.diagIm[i]);
            arrayRe[i][i] = z.real();
            arrayIm[i][i] = z.imag();
            z = f.map(this.udiagRe[i], this.udiagIm[i]);
            arrayRe[i][i + 1] = z.real();
            arrayIm[i][i + 1] = z.imag();
        }
        z = f.map(this.ldiagRe[mRow], this.ldiagIm[mRow]);
        arrayRe[mRow][mRow - 1] = z.real();
        arrayIm[mRow][mRow - 1] = z.imag();
        z = f.map(this.diagRe[mRow], this.diagIm[mRow]);
        arrayRe[mRow][mRow] = z.real();
        arrayIm[mRow][mRow] = z.imag();
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }
}

