/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.chaos;

import jsci.maths.MappingND;

public final class StandardMap
implements MappingND {
    private final double k;

    public StandardMap(double kval) {
        this.k = kval;
    }

    @Override
    public double[] map(double[] x) {
        double[] ans = new double[2];
        ans[1] = (x[1] + this.k * Math.sin(x[0])) % (Math.PI * 2);
        ans[0] = (x[0] + ans[1]) % (Math.PI * 2);
        return ans;
    }

    public double[] iterate(int n, double[] x) {
        double[] xn = this.map(x);
        for (int i = 1; i < n; ++i) {
            xn = this.map(xn);
        }
        return xn;
    }
}

