/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.chaos;

import jsci.maths.Complex;
import jsci.maths.ComplexMapping;

public final class MandelbrotMap
implements ComplexMapping {
    public static final double CONVERGENT_BOUND = 2.0;
    private Complex a;

    public MandelbrotMap(double aval) {
        this.a = new Complex(aval, 0.0);
    }

    public MandelbrotMap(Complex aval) {
        this.a = aval;
    }

    public Complex getConstant() {
        return this.a;
    }

    public void setConstant(Complex aval) {
        this.a = aval;
    }

    public double map(double x) {
        return x * x + this.a.real();
    }

    @Override
    public Complex map(Complex z) {
        return this.map(z.real(), z.imag());
    }

    @Override
    public Complex map(double real, double imag) {
        return new Complex(real * real - imag * imag + this.a.real(), 2.0 * real * imag + this.a.imag());
    }

    public double iterate(int n, double x) {
        for (int i = 0; i < n; ++i) {
            x = this.map(x);
        }
        return x;
    }

    public Complex iterate(int n, Complex z) {
        for (int i = 0; i < n; ++i) {
            z = this.map(z);
        }
        return z;
    }
}

