/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.chaos;

public abstract class KochCurve {
    public double hausdorffDimension() {
        return Math.log(4.0) / Math.log(3.0);
    }

    public void recurse(double startX, double startY, double endX, double endY, int n) {
        if (n == 0) {
            return;
        }
        double l_3X = (endX - startX) / 3.0;
        double l_3Y = (endY - startY) / 3.0;
        this.eraseLine(startX + l_3X, startY + l_3Y, endX - l_3X, endY - l_3Y);
        double h = Math.sqrt(3.0) / 2.0;
        double pX = (startX + endX) / 2.0 - l_3Y * h;
        double pY = (startY + endY) / 2.0 + l_3X * h;
        this.drawLine(startX + l_3X, startY + l_3Y, pX, pY);
        this.drawLine(pX, pY, endX - l_3X, endY - l_3Y);
        this.recurse(startX, startY, startX + l_3X, startY + l_3Y, n - 1);
        this.recurse(startX + l_3X, startY + l_3Y, pX, pY, n - 1);
        this.recurse(pX, pY, endX - l_3X, endY - l_3Y, n - 1);
        this.recurse(endX - l_3X, endY - l_3Y, endX, endY, n - 1);
    }

    protected abstract void drawLine(double var1, double var3, double var5, double var7);

    protected abstract void eraseLine(double var1, double var3, double var5, double var7);
}

