/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.chaos;

import jsci.maths.MappingND;

public final class HenonMap
implements MappingND {
    private final double a;
    private final double b;
    public static final double A_CHAOS = 1.4;
    public static final double B_CHAOS = 0.3;

    public HenonMap(double aval, double bval) {
        this.a = aval;
        this.b = bval;
    }

    @Override
    public double[] map(double[] x) {
        double[] ans = new double[]{1.0 - this.a * x[0] * x[0] + x[1], this.b * x[0]};
        return ans;
    }

    public double hausdorffDimension() {
        return 1.26;
    }

    public double[] iterate(int n, double[] x) {
        double[] xn = this.map(x);
        for (int i = 1; i < n; ++i) {
            xn = this.map(xn);
        }
        return xn;
    }
}

