/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.categories;

import jsci.maths.categories.Category;
import jsci.maths.categories.UndefinedCompositionException;

public final class Preorder
implements Category {
    private final int N;

    public Preorder(int n) {
        this.N = n;
    }

    @Override
    public Category.Morphism identity(Object a) {
        return new Relation((Integer)a, (Integer)a);
    }

    @Override
    public Object cardinality(Object a) {
        return a;
    }

    @Override
    public Category.HomSet hom(Object a, Object b) {
        Integer i = (Integer)a;
        Integer j = (Integer)b;
        if (i.compareTo(j) <= 0) {
            return new RelationSet(i, j);
        }
        return new RelationSet();
    }

    public Object initial() {
        return new Integer(0);
    }

    public Object terminal() {
        return new Integer(this.N - 1);
    }

    public int ordinal() {
        return this.N;
    }

    public class Relation
    implements Category.Morphism {
        private final Integer from;
        private final Integer to;

        public Relation(Integer a, Integer b) {
            this.from = a;
            this.to = b;
        }

        @Override
        public Object domain() {
            return this.from;
        }

        @Override
        public Object codomain() {
            return this.to;
        }

        @Override
        public Object map(Object o) {
            return this.to;
        }

        @Override
        public Category.Morphism compose(Category.Morphism m) {
            if (m instanceof Relation) {
                Relation r = (Relation)m;
                if (this.to.equals(r.from)) {
                    return new Relation(this.from, r.to);
                }
                throw new UndefinedCompositionException();
            }
            throw new IllegalArgumentException("Morphism is not a Relation.");
        }
    }

    public class RelationSet
    implements Category.HomSet {
        public final Relation morphism;

        public RelationSet() {
            this.morphism = null;
        }

        public RelationSet(Integer a, Integer b) {
            this.morphism = new Relation(a, b);
        }
    }
}

