/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.categories;

import jsci.maths.Complex;
import jsci.maths.MathInteger;
import jsci.maths.algebras.BanachSpace;
import jsci.maths.algebras.HilbertSpace;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.categories.Category;
import jsci.maths.categories.UndefinedCompositionException;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.ComplexDiagonalMatrix;
import jsci.maths.matrices.ComplexMatrix;
import jsci.maths.vectors.AbstractComplexVector;

public class Hilb
implements Category {
    @Override
    public Category.Morphism identity(Object a) {
        return new LinearMap(ComplexDiagonalMatrix.identity(((HilbertSpace)a).dimension()));
    }

    @Override
    public Object cardinality(Object a) {
        return new MathInteger(((HilbertSpace)a).dimension());
    }

    @Override
    public Category.HomSet hom(Object a, Object b) {
        return new OperatorSpace((HilbertSpace)a, (HilbertSpace)b);
    }

    public class LinearMap
    implements BanachSpace.Member,
    Category.Morphism {
        private AbstractComplexMatrix matrix;

        public LinearMap(Complex[][] array) {
            this.matrix = new ComplexMatrix(array);
        }

        public LinearMap(AbstractComplexMatrix m) {
            this.matrix = m;
        }

        @Override
        public Object domain() {
            return new HilbertSpace(this.matrix.columns());
        }

        @Override
        public Object codomain() {
            return new HilbertSpace(this.matrix.rows());
        }

        @Override
        public Object map(Object v) {
            return this.matrix.multiply((AbstractComplexVector)v);
        }

        @Override
        public Category.Morphism compose(Category.Morphism m) {
            if (m instanceof LinearMap) {
                LinearMap lm = (LinearMap)m;
                if (this.matrix.columns() == lm.matrix.rows()) {
                    return new LinearMap(lm.matrix.multiply(this.matrix));
                }
                throw new UndefinedCompositionException();
            }
            throw new IllegalArgumentException("Morphism is not a LinearMap.");
        }

        @Override
        public double norm() {
            return this.matrix.frobeniusNorm();
        }

        public int dimension() {
            return this.matrix.rows() * this.matrix.columns();
        }

        @Override
        public Object getSet() {
            return this.matrix.getSet();
        }

        @Override
        public AbelianGroup.Member add(AbelianGroup.Member m) {
            if (m instanceof LinearMap) {
                return new LinearMap(this.matrix.add(((LinearMap)m).matrix));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }

        @Override
        public AbelianGroup.Member negate() {
            return new LinearMap((AbstractComplexMatrix)this.matrix.negate());
        }

        @Override
        public AbelianGroup.Member subtract(AbelianGroup.Member m) {
            if (m instanceof LinearMap) {
                return new LinearMap(this.matrix.subtract(((LinearMap)m).matrix));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }

        @Override
        public Module.Member scalarMultiply(Ring.Member z) {
            if (z instanceof Complex) {
                return new LinearMap(this.matrix.scalarMultiply((Complex)z));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }

        @Override
        public VectorSpace.Member scalarDivide(Field.Member z) {
            if (z instanceof Complex) {
                return new LinearMap(this.matrix.scalarMultiply((Complex)z));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }
    }

    public class OperatorSpace
    extends HilbertSpace
    implements Category.HomSet {
        private final int rows;
        private final int cols;

        public OperatorSpace(HilbertSpace a, HilbertSpace b) {
            super(a.dimension() * b.dimension());
            this.rows = b.dimension();
            this.cols = a.dimension();
        }

        public VectorSpace.Member getVector(Complex[][] array) {
            return new LinearMap(array);
        }
    }
}

