/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.categories;

import jsci.maths.ExtraMath;
import jsci.maths.MathInteger;
import jsci.maths.MathSet;
import jsci.maths.categories.Category;
import jsci.maths.categories.UndefinedCompositionException;

public class FinSet
implements Category {
    @Override
    public Category.Morphism identity(Object a) {
        return new IdentityFunction((MathSet)a);
    }

    @Override
    public Object cardinality(Object a) {
        return new MathInteger(((MathSet)a).cardinality());
    }

    @Override
    public Category.HomSet hom(Object a, Object b) {
        return new FunctionSet((MathSet)a, (MathSet)b);
    }

    private class IdentityFunction
    extends Function {
        public IdentityFunction(MathSet s) {
            super(s, s, null, null);
        }

        @Override
        public Object map(Object o) {
            return o;
        }

        @Override
        public Category.Morphism compose(Category.Morphism m) {
            if (m instanceof Function) {
                return m;
            }
            throw new IllegalArgumentException("Morphism is not a Function.");
        }
    }

    public class Function
    implements Category.Morphism {
        private final MathSet from;
        private final MathSet to;
        private final Object[] in;
        private final Object[] out;

        public Function(MathSet a, MathSet b, Object[] inObjs, Object[] outObjs) {
            this.from = a;
            this.to = b;
            this.in = inObjs;
            this.out = outObjs;
        }

        @Override
        public Object domain() {
            return this.from;
        }

        @Override
        public Object codomain() {
            return this.to;
        }

        @Override
        public Object map(Object o) {
            for (int i = 0; i < this.in.length; ++i) {
                if (!o.equals(this.in[i])) continue;
                return this.out[i];
            }
            return null;
        }

        @Override
        public Category.Morphism compose(Category.Morphism m) {
            if (m instanceof Function) {
                Function f = (Function)m;
                if (this.to.equals(f.from)) {
                    Object[] outObjs = new Object[this.in.length];
                    for (int i = 0; i < outObjs.length; ++i) {
                        outObjs[i] = f.map(this.out[i]);
                    }
                    return new Function(this.from, f.to, this.in, outObjs);
                }
                throw new UndefinedCompositionException();
            }
            throw new IllegalArgumentException("Morphism is not a Function.");
        }
    }

    public class FunctionSet
    implements MathSet,
    Category.HomSet {
        private final MathSet from;
        private final MathSet to;
        private final int size;

        public FunctionSet(MathSet a, MathSet b) {
            this.from = a;
            this.to = b;
            this.size = ExtraMath.pow(b.cardinality(), a.cardinality());
        }

        public Function getElement(Object[] in, Object[] out) {
            return new Function(this.from, this.to, in, out);
        }

        @Override
        public int cardinality() {
            return this.size;
        }

        @Override
        public MathSet union(MathSet set) {
            return set.union(this);
        }

        @Override
        public MathSet intersect(MathSet set) {
            return set.intersect(this);
        }
    }
}

