/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.analysis;

import jsci.maths.analysis.RealFunction;
import jsci.maths.analysis.RealFunctionND;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;

public abstract class RealFunction2D
implements Ring.Member {
    public abstract double map(double var1, double var3);

    public final int dimension() {
        return 2;
    }

    @Override
    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Negation(this);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member f) {
        if (f instanceof RealFunction2D) {
            return this.add((RealFunction2D)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction2D add(RealFunction2D f) {
        return new Sum(this, f);
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member f) {
        if (f instanceof RealFunction2D) {
            return this.subtract((RealFunction2D)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction2D subtract(RealFunction2D f) {
        return new Difference(this, f);
    }

    @Override
    public Ring.Member multiply(Ring.Member f) {
        if (f instanceof RealFunction2D) {
            return this.multiply((RealFunction2D)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction2D multiply(RealFunction2D f) {
        return new Product(this, f);
    }

    public Ring.Member inverse() {
        return new Reciprocal(this);
    }

    public Ring.Member divide(Ring.Member f) {
        if (f instanceof RealFunction2D) {
            return this.divide((RealFunction2D)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction2D divide(RealFunction2D f) {
        return new Quotient(this, f);
    }

    public RealFunctionND tensor(RealFunction f) {
        return new TensorProduct3D(this, f);
    }

    public RealFunctionND tensor(RealFunction2D f) {
        return new TensorProduct4D(this, f);
    }

    public static RealFunction2D constant(double k) {
        return new Constant(k);
    }

    private static class Constant
    extends RealFunction2D {
        private final double A;

        public Constant(double A) {
            this.A = A;
        }

        @Override
        public double map(double x, double y) {
            return this.A;
        }
    }

    private static class TensorProduct4D
    extends RealFunctionND {
        private final RealFunction2D f1;
        private final RealFunction2D f2;

        public TensorProduct4D(RealFunction2D f1, RealFunction2D f2) {
            super(4);
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double[] x) {
            return this.f1.map(x[0], x[1]) * this.f2.map(x[2], x[3]);
        }
    }

    private static class TensorProduct3D
    extends RealFunctionND {
        private final RealFunction2D f1;
        private final RealFunction f2;

        public TensorProduct3D(RealFunction2D f1, RealFunction f2) {
            super(3);
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double[] x) {
            return this.f1.map(x[0], x[1]) * this.f2.map(x[2]);
        }
    }

    private static class Quotient
    extends RealFunction2D {
        private final RealFunction2D f1;
        private final RealFunction2D f2;

        public Quotient(RealFunction2D f1, RealFunction2D f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double x, double y) {
            return this.f1.map(x, y) / this.f2.map(x, y);
        }
    }

    private static class Reciprocal
    extends RealFunction2D {
        private final RealFunction2D f;

        public Reciprocal(RealFunction2D f) {
            this.f = f;
        }

        @Override
        public double map(double x, double y) {
            return 1.0 / this.f.map(x, y);
        }
    }

    private static class Product
    extends RealFunction2D {
        private final RealFunction2D f1;
        private final RealFunction2D f2;

        public Product(RealFunction2D f1, RealFunction2D f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double x, double y) {
            return this.f1.map(x, y) * this.f2.map(x, y);
        }
    }

    private static class Difference
    extends RealFunction2D {
        private final RealFunction2D f1;
        private final RealFunction2D f2;

        public Difference(RealFunction2D f1, RealFunction2D f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double x, double y) {
            return this.f1.map(x, y) - this.f2.map(x, y);
        }
    }

    private static class Sum
    extends RealFunction2D {
        private final RealFunction2D f1;
        private final RealFunction2D f2;

        public Sum(RealFunction2D f1, RealFunction2D f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double x, double y) {
            return this.f1.map(x, y) + this.f2.map(x, y);
        }
    }

    private static class Negation
    extends RealFunction2D {
        private final RealFunction2D f;

        public Negation(RealFunction2D f) {
            this.f = f;
        }

        @Override
        public double map(double x, double y) {
            return -this.f.map(x, y);
        }
    }
}

