/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.analysis;

import jsci.maths.analysis.RealFunction;
import jsci.maths.analysis.Sine;

public class Cosine
extends RealFunction {
    private final double A;
    private final double w;
    private final double k;

    public Cosine() {
        this(1.0, 1.0, 0.0);
    }

    public Cosine(double A, double w, double k) {
        this.A = A;
        this.w = w;
        this.k = k;
    }

    @Override
    public double map(double x) {
        return this.A * Math.cos(this.w * x + this.k);
    }

    @Override
    public RealFunction differentiate() {
        return new Sine(-this.A * this.w, this.w, this.k);
    }
}

