/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.analysis;

import jsci.maths.Complex;
import jsci.maths.analysis.ComplexFunction;

public class ComplexExponential
extends ComplexFunction {
    private final Complex A;
    private final Complex w;

    public ComplexExponential() {
        this.A = Complex.ONE;
        this.w = Complex.ONE;
    }

    public ComplexExponential(Complex A, Complex w) {
        this.A = A;
        this.w = w;
    }

    @Override
    public Complex map(double x, double y) {
        double iwzRe = -(this.w.imag() * x + this.w.real() * y);
        double iwzIm = this.w.real() * x - this.w.imag() * y;
        return this.A.multiply(new Complex(Math.exp(iwzRe) * Math.cos(iwzIm), Math.exp(iwzRe) * Math.sin(iwzIm)));
    }

    @Override
    public Complex map(Complex z) {
        return this.map(z.real(), z.imag());
    }

    @Override
    public ComplexFunction differentiate() {
        return new ComplexExponential(this.A.multiply(Complex.I.multiply(this.w)), this.w);
    }

    public ComplexFunction integrate() {
        return new ComplexExponential(this.A.divide(Complex.I.multiply(this.w)), this.w);
    }
}

