/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.algebras;

import jsci.maths.Complex;
import jsci.maths.algebras.LieAlgebra;
import jsci.maths.fields.ComplexField;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.Double3Vector;
import jsci.maths.vectors.VectorDimensionException;

public final class sp2_RDim2
extends LieAlgebra {
    private static final Complex[][] t1 = new Complex[][]{{Complex.ZERO, ComplexField.HALF}, {ComplexField.HALF, Complex.ZERO}};
    private static final Complex[][] t2 = new Complex[][]{{Complex.ZERO, ComplexField.HALF}, {ComplexField.MINUS_HALF, Complex.ZERO}};
    private static final Complex[][] t3 = new Complex[][]{{ComplexField.HALF, Complex.ZERO}, {Complex.ZERO, ComplexField.MINUS_HALF}};
    private static final AbstractComplexSquareMatrix[] basisMatrices = new AbstractComplexSquareMatrix[]{new ComplexSquareMatrix(t1), new ComplexSquareMatrix(t2), new ComplexSquareMatrix(t3)};
    private static final sp2_RDim2 _instance = new sp2_RDim2();

    private sp2_RDim2() {
        super("sp(2,R) [2]");
    }

    public static final sp2_RDim2 getInstance() {
        return _instance;
    }

    @Override
    public AbstractComplexSquareMatrix getElement(AbstractDoubleVector v) {
        AbstractComplexMatrix m = basisMatrices[0].scalarMultiply(v.getComponent(0));
        m = m.add(basisMatrices[1].scalarMultiply(v.getComponent(1)));
        m = m.add(basisMatrices[2].scalarMultiply(v.getComponent(2)));
        return (AbstractComplexSquareMatrix)m.scalarMultiply(Complex.I);
    }

    @Override
    public AbstractDoubleVector multiply(AbstractDoubleVector a, AbstractDoubleVector b) {
        if (!(a instanceof Double3Vector) || !(b instanceof Double3Vector)) {
            throw new VectorDimensionException("Vectors must be 3-vectors.");
        }
        return new Double3Vector(a.getComponent(2) * b.getComponent(1) - a.getComponent(1) * b.getComponent(2), a.getComponent(2) * b.getComponent(0) - a.getComponent(0) * b.getComponent(2), a.getComponent(1) * b.getComponent(0) - a.getComponent(0) * b.getComponent(1));
    }

    @Override
    public AbstractComplexSquareMatrix[] basis() {
        return basisMatrices;
    }
}

