/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.GlobalSettings;
import jsci.maths.ExtraMath;
import jsci.maths.MathDouble;
import jsci.maths.MathInteger;
import jsci.maths.algebras.CStarAlgebra;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractDoubleSquareMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.Double3Vector;

public final class Quaternion
implements Field.Member,
CStarAlgebra.Member {
    private static final long serialVersionUID = 1605315490425547301L;
    private double re;
    private double imi;
    private double imj;
    private double imk;
    public static final Quaternion ONE = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public static final Quaternion I = new Quaternion(0.0, 1.0, 0.0, 0.0);
    public static final Quaternion J = new Quaternion(0.0, 0.0, 1.0, 0.0);
    public static final Quaternion K = new Quaternion(0.0, 0.0, 0.0, 1.0);

    public Quaternion(double real, Double3Vector imag) {
        this.re = real;
        this.imi = imag.getComponent(0);
        this.imj = imag.getComponent(1);
        this.imk = imag.getComponent(2);
    }

    public Quaternion(double q0, double q1, double q2, double q3) {
        this.re = q0;
        this.imi = q1;
        this.imj = q2;
        this.imk = q3;
    }

    public static Quaternion rotation(AbstractDoubleSquareMatrix m) {
        double imk;
        double imj;
        double imi;
        double re;
        if (m.rows() != 3 && m.columns() != 3) {
            throw new MatrixDimensionException("The matrix is not 3-dimensional.");
        }
        double wSqr = (1.0 + m.trace()) / 4.0;
        if (wSqr > GlobalSettings.ZERO_TOL) {
            re = Math.sqrt(wSqr);
            imi = (m.getElement(2, 1) - m.getElement(1, 2)) / (re * 4.0);
            imj = (m.getElement(0, 2) - m.getElement(2, 0)) / (re * 4.0);
            imk = (m.getElement(1, 0) - m.getElement(0, 1)) / (re * 4.0);
        } else {
            double xSqr = -(m.getElement(1, 1) + m.getElement(2, 2)) / 2.0;
            re = 0.0;
            if (xSqr > GlobalSettings.ZERO_TOL) {
                imi = Math.sqrt(xSqr);
                imj = m.getElement(1, 0) / (2.0 * imi);
                imk = m.getElement(2, 0) / (2.0 * imi);
            } else {
                double ySqr = (1.0 - m.getElement(2, 2)) / 2.0;
                imi = 0.0;
                if (ySqr > GlobalSettings.ZERO_TOL) {
                    imj = Math.sqrt(ySqr);
                    imk = m.getElement(2, 1) / (2.0 * imj);
                } else {
                    imj = 0.0;
                    imk = 1.0;
                }
            }
        }
        return new Quaternion(re, imi, imj, imk);
    }

    public AbstractDoubleSquareMatrix toRotationMatrix() {
        double[][] array = new double[3][3];
        array[0][0] = 1.0 - 2.0 * (this.imj * this.imj + this.imk * this.imk);
        array[0][1] = 2.0 * (this.imi * this.imj - this.re * this.imk);
        array[0][2] = 2.0 * (this.imi * this.imk + this.re * this.imj);
        array[1][0] = 2.0 * (this.imi * this.imj + this.re * this.imk);
        array[1][1] = 1.0 - 2.0 * (this.imi * this.imi + this.imk * this.imk);
        array[1][2] = 2.0 * (this.imj * this.imk - this.re * this.imi);
        array[2][0] = 2.0 * (this.imi * this.imk - this.re * this.imj);
        array[2][1] = 2.0 * (this.imj * this.imk + this.re * this.imi);
        array[2][2] = 1.0 - 2.0 * (this.imi * this.imi + this.imj * this.imj);
        return new DoubleSquareMatrix(array);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Quaternion) {
            Quaternion q = (Quaternion)obj;
            return this.subtract(q).norm() <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(40);
        buf.append(this.re);
        if (this.imi >= 0.0) {
            buf.append("+");
        }
        buf.append(this.imi);
        buf.append("i");
        if (this.imj >= 0.0) {
            buf.append("+");
        }
        buf.append(this.imj);
        buf.append("j");
        if (this.imk >= 0.0) {
            buf.append("+");
        }
        buf.append(this.imk);
        buf.append("k");
        return buf.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public boolean isNaN() {
        return this.re == Double.NaN || this.imi == Double.NaN || this.imj == Double.NaN || this.imk == Double.NaN;
    }

    public boolean isInfinite() {
        return this.re == Double.POSITIVE_INFINITY || this.re == Double.NEGATIVE_INFINITY || this.imi == Double.POSITIVE_INFINITY || this.imi == Double.NEGATIVE_INFINITY || this.imj == Double.POSITIVE_INFINITY || this.imj == Double.NEGATIVE_INFINITY || this.imk == Double.POSITIVE_INFINITY || this.imk == Double.NEGATIVE_INFINITY;
    }

    public double real() {
        return this.re;
    }

    public Double3Vector imag() {
        return new Double3Vector(this.imi, this.imj, this.imk);
    }

    @Override
    public Object getSet() {
        throw new RuntimeException("Not yet implemented: please file bug report");
    }

    @Override
    public double norm() {
        return Math.sqrt(this.sumSquares());
    }

    public double sumSquares() {
        return this.re * this.re + this.imi * this.imi + this.imj * this.imj + this.imk * this.imk;
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Quaternion(-this.re, -this.imi, -this.imj, -this.imk);
    }

    @Override
    public Field.Member inverse() {
        double sumSqr = this.sumSquares();
        return new Quaternion(this.re / sumSqr, -this.imi / sumSqr, -this.imj / sumSqr, -this.imk / sumSqr);
    }

    @Override
    public CStarAlgebra.Member involution() {
        return this.conjugate();
    }

    public Quaternion conjugate() {
        return new Quaternion(this.re, -this.imi, -this.imj, -this.imk);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member x) {
        if (x instanceof Quaternion) {
            return this.add((Quaternion)x);
        }
        if (x instanceof MathDouble) {
            return this.addReal(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.addReal(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion add(Quaternion q) {
        return new Quaternion(this.re + q.re, this.imi + q.imi, this.imj + q.imj, this.imk + q.imk);
    }

    public Quaternion addReal(double real) {
        return new Quaternion(this.re + real, this.imi, this.imj, this.imk);
    }

    public Quaternion addImag(Double3Vector imag) {
        return new Quaternion(this.re, this.imi + imag.getComponent(0), this.imj + imag.getComponent(1), this.imk + imag.getComponent(2));
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member x) {
        if (x instanceof Quaternion) {
            return this.subtract((Quaternion)x);
        }
        if (x instanceof MathDouble) {
            return this.subtractReal(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.subtractReal(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion subtract(Quaternion q) {
        return new Quaternion(this.re - q.re, this.imi - q.imi, this.imj - q.imj, this.imk - q.imk);
    }

    public Quaternion subtractReal(double real) {
        return new Quaternion(this.re - real, this.imi, this.imj, this.imk);
    }

    public Quaternion subtractImag(Double3Vector imag) {
        return new Quaternion(this.re, this.imi - imag.getComponent(0), this.imj - imag.getComponent(1), this.imk - imag.getComponent(2));
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof MathDouble) {
            return this.multiply(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.multiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public Ring.Member multiply(Ring.Member x) {
        if (x instanceof Quaternion) {
            return this.multiply((Quaternion)x);
        }
        if (x instanceof MathDouble) {
            return this.multiply(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.multiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion multiply(Quaternion q) {
        return new Quaternion(this.re * q.re - this.imi * q.imi - this.imj * q.imj - this.imk * q.imk, this.re * q.imi + q.re * this.imi + (this.imj * q.imk - q.imj * this.imk), this.re * q.imj + q.re * this.imj + (this.imk * q.imi - q.imk * this.imi), this.re * q.imk + q.re * this.imk + (this.imi * q.imj - q.imi * this.imj));
    }

    public Quaternion multiply(double x) {
        return new Quaternion(x * this.re, x * this.imi, x * this.imj, x * this.imk);
    }

    @Override
    public VectorSpace.Member scalarDivide(Field.Member x) {
        if (x instanceof MathDouble) {
            return this.divide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public Field.Member divide(Field.Member x) {
        if (x instanceof Quaternion) {
            return this.divide((Quaternion)x);
        }
        if (x instanceof MathDouble) {
            return this.divide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion divide(Quaternion q) {
        double qSumSqr = q.sumSquares();
        return new Quaternion((this.re * q.re + this.imi * q.imi + this.imj * q.imj + this.imk * q.imk) / qSumSqr, (q.re * this.imi - this.re * q.imi - (this.imj * q.imk - q.imj * this.imk)) / qSumSqr, (q.re * this.imj - this.re * q.imj - (this.imk * q.imi - q.imk * this.imi)) / qSumSqr, (q.re * this.imk - this.re * q.imk - (this.imi * q.imj - q.imi * this.imj)) / qSumSqr);
    }

    public Quaternion divide(double x) {
        return new Quaternion(this.re / x, this.imi / x, this.imj / x, this.imk / x);
    }

    public Quaternion normalize() {
        return this.divide(this.norm());
    }

    public static Quaternion exp(Quaternion q) {
        double k = Math.exp(q.re);
        Double3Vector imag = q.imag();
        double imagNorm = imag.norm();
        return new Quaternion(k * Math.cos(imagNorm), (Double3Vector)imag.normalize().scalarMultiply(k * Math.sin(imagNorm)));
    }

    public static Quaternion log(Quaternion q) {
        double norm = q.norm();
        return new Quaternion(Math.log(norm), (Double3Vector)q.imag().normalize().scalarMultiply(Math.acos(q.re / norm)));
    }

    public static Quaternion sin(Quaternion q) {
        Double3Vector imag = q.imag();
        double imagNorm = imag.norm();
        return new Quaternion(Math.sin(q.re) * ExtraMath.cosh(imagNorm), (Double3Vector)imag.normalize().scalarMultiply(Math.cos(q.re) * ExtraMath.sinh(imagNorm)));
    }

    public static Quaternion cos(Quaternion q) {
        Double3Vector imag = q.imag();
        double imagNorm = imag.norm();
        return new Quaternion(Math.cos(q.re) * ExtraMath.cosh(imagNorm), (Double3Vector)imag.normalize().scalarMultiply(-Math.sin(q.re) * ExtraMath.sinh(imagNorm)));
    }

    public static Quaternion tan(Quaternion q) {
        return Quaternion.sin(q).divide(Quaternion.cos(q));
    }

    public static Quaternion sinh(Quaternion q) {
        Double3Vector imag = q.imag();
        double imagNorm = imag.norm();
        return new Quaternion(ExtraMath.sinh(q.re) * Math.cos(imagNorm), (Double3Vector)imag.normalize().scalarMultiply(ExtraMath.cosh(q.re) * Math.sin(imagNorm)));
    }

    public static Quaternion cosh(Quaternion q) {
        Double3Vector imag = q.imag();
        double imagNorm = imag.norm();
        return new Quaternion(ExtraMath.cosh(q.re) * Math.cos(imagNorm), (Double3Vector)imag.normalize().scalarMultiply(ExtraMath.sinh(q.re) * Math.sin(imagNorm)));
    }

    public static Quaternion tanh(Quaternion q) {
        return Quaternion.sinh(q).divide(Quaternion.cosh(q));
    }
}

