/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.maths.AbstractMath;
import jsci.maths.ArrayMath;
import jsci.maths.ExtraMath;
import jsci.maths.Mapping;
import jsci.maths.MappingND;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.analysis.RealFunction;
import jsci.maths.analysis.RealFunction2D;

public final class NumericalMath
extends AbstractMath {
    private NumericalMath() {
    }

    public static double[] solveQuadratic(double a, double b, double c) {
        double[] roots = new double[2];
        double q = b < 0.0 ? (-b + Math.sqrt(b * b - 4.0 * a * c)) / 2.0 : (-b - Math.sqrt(b * b - 4.0 * a * c)) / 2.0;
        roots[0] = q / a;
        roots[1] = c / q;
        return roots;
    }

    public static double bisection(Mapping func, double a, double b, int maxIter, double tol) throws MaximumIterationsExceededException {
        double x;
        int signb;
        int signa = ExtraMath.sign(func.map(a));
        if (signa == (signb = ExtraMath.sign(func.map(b)))) {
            throw new IllegalArgumentException("Bounds do not bracket a root.");
        }
        int n = 0;
        do {
            int signx;
            if ((signx = ExtraMath.sign(func.map(x = (a + b) / 2.0))) == signa) {
                a = x;
            } else if (signx == signb) {
                b = x;
            } else {
                a = x;
                b = x;
            }
            if (++n <= maxIter) continue;
            throw new MaximumIterationsExceededException("No convergence after " + maxIter + " iterations.");
        } while (Math.abs(a - b) > tol);
        return x;
    }

    public static double falsePosition(Mapping func, double a, double b, int maxIter, double tol) throws MaximumIterationsExceededException {
        double x;
        double delta;
        int signb;
        double fa = func.map(a);
        double fb = func.map(b);
        int signa = ExtraMath.sign(fa);
        if (signa == (signb = ExtraMath.sign(fb))) {
            throw new IllegalArgumentException("Bounds do not bracket a root.");
        }
        int n = 0;
        do {
            double fx;
            int signx;
            if ((signx = ExtraMath.sign(fx = func.map(x = a - (b - a) * fa / (fb - fa)))) == signa) {
                delta = x - a;
                a = x;
                fa = fx;
            } else if (signx == signb) {
                delta = b - x;
                b = x;
                fb = fx;
            } else {
                delta = 0.0;
            }
            if (++n <= maxIter) continue;
            throw new MaximumIterationsExceededException("No convergence after " + maxIter + " iterations.");
        } while (Math.abs(delta) > tol);
        return x;
    }

    public static double newtonRaphson(RealFunction func, double x, int maxIter, double tol) throws MaximumIterationsExceededException {
        double delta;
        RealFunction deriv = func.differentiate();
        int n = 0;
        do {
            delta = -func.map(x) / deriv.map(x);
            x += delta;
            if (++n <= maxIter) continue;
            throw new MaximumIterationsExceededException("No convergence after " + maxIter + " iterations.");
        } while (Math.abs(delta) > tol);
        return x;
    }

    public static double[] euler(double[] y, Mapping func, double dt) {
        for (int i = 0; i < y.length - 1; ++i) {
            y[i + 1] = y[i] + dt * func.map(y[i]);
        }
        return y;
    }

    public static double[] leapFrog(double[] y, Mapping func, double dt) {
        double two_dt = 2.0 * dt;
        for (int i = 1; i < y.length - 1; ++i) {
            y[i + 1] = y[i - 1] + two_dt * func.map(y[i]);
        }
        return y;
    }

    public static double[] rungeKutta2(double[] y, Mapping func, double dt) {
        double dt2 = dt / 2.0;
        for (int i = 0; i < y.length - 1; ++i) {
            y[i + 1] = y[i] + dt * func.map(y[i] + dt2 * func.map(y[i]));
        }
        return y;
    }

    public static double[] rungeKutta2(double[] y, RealFunction2D func, double t0, double dt) {
        double dt2 = dt / 2.0;
        double t = t0;
        for (int i = 0; i < y.length - 1; ++i) {
            y[i + 1] = y[i] + dt * func.map(y[i] + dt2 * func.map(y[i], t), t + dt2);
            t += dt;
        }
        return y;
    }

    public static double[] rungeKutta4(double[] y, Mapping func, double dt) {
        for (int i = 0; i < y.length - 1; ++i) {
            double k1 = dt * func.map(y[i]);
            double k2 = dt * func.map(y[i] + k1 / 2.0);
            double k3 = dt * func.map(y[i] + k2 / 2.0);
            double k4 = dt * func.map(y[i] + k3);
            y[i + 1] = y[i] + (k1 + k4) / 6.0 + (k2 + k3) / 3.0;
        }
        return y;
    }

    public static double[] rungeKutta4(double[] y, RealFunction2D func, double t0, double dt) {
        double dt2 = dt / 2.0;
        double t = t0;
        for (int i = 0; i < y.length - 1; ++i) {
            double k1 = dt * func.map(y[i], t);
            double k2 = dt * func.map(y[i] + k1 / 2.0, t + dt2);
            double k3 = dt * func.map(y[i] + k2 / 2.0, t + dt2);
            double k4 = dt * func.map(y[i] + k3, t + dt);
            y[i + 1] = y[i] + (k1 + k4) / 6.0 + (k2 + k3) / 3.0;
            t += dt;
        }
        return y;
    }

    public static double trapezium(int N, Mapping func, double a, double b) {
        double A = 0.0;
        double x = a;
        double h = (b - a) / (double)N;
        for (int i = 0; i < N; ++i) {
            A += func.map(x) + func.map(x + h);
            x += h;
        }
        return A * h / 2.0;
    }

    public static double simpson(int N, Mapping func, double a, double b) {
        double Ao = 0.0;
        double Ae = 0.0;
        double x = a;
        double h = (b - a) / (double)(2 * N);
        for (int i = 0; i < N - 1; ++i) {
            Ao += func.map(x + h);
            Ae += func.map(x + 2.0 * h);
            x += 2.0 * h;
        }
        return h / 3.0 * (func.map(a) + 4.0 * (Ao += func.map(x + h)) + 2.0 * Ae + func.map(b));
    }

    public static double richardson(int N, Mapping func, double a, double b) {
        double Aao = 0.0;
        double Aae = 0.0;
        double Abo = 0.0;
        double Abe = 0.0;
        double x = a;
        double ha = (b - a) / (double)(2 * N);
        double hb = ha / 2.0;
        for (int i = 0; i < N - 1; ++i) {
            Aao += func.map(x + ha);
            Aae += func.map(x + 2.0 * ha);
            Abo += func.map(x + hb);
            Abe += func.map(x + 2.0 * hb);
            Abo += func.map(x + 3.0 * hb);
            Abe += func.map(x + 4.0 * hb);
            x += 2.0 * ha;
        }
        Abo += func.map(x + hb);
        double Aa = ha / 3.0 * (func.map(a) + 4.0 * (Aao += func.map(x + ha)) + 2.0 * Aae + func.map(b));
        double Ab = hb / 3.0 * (func.map(a) + 4.0 * (Abo += func.map(x + 3.0 * hb)) + 2.0 * (Abe += func.map(x + 2.0 * hb)) + func.map(b));
        return (16.0 * Ab - Aa) / 15.0;
    }

    public static double gaussian4(int N, Mapping func, double a, double b) {
        double A = 0.0;
        double h = (b - a) / (double)N;
        double h2 = h / 2.0;
        double[] zeros = new double[4];
        double[] coeffs = new double[4];
        zeros[2] = 0.33998104358485626;
        zeros[3] = 0.8611363115940526;
        zeros[0] = -zeros[3];
        zeros[1] = -zeros[2];
        coeffs[3] = 0.34785484513745385;
        coeffs[0] = 0.34785484513745385;
        coeffs[2] = 0.6521451548625461;
        coeffs[1] = 0.6521451548625461;
        for (int n = 0; n < N; ++n) {
            for (int i = 0; i < zeros.length; ++i) {
                A += coeffs[i] * func.map(a + (zeros[i] + 1.0) * h2);
            }
            a += h;
        }
        return A * h2;
    }

    public static double gaussian8(int N, Mapping func, double a, double b) {
        double A = 0.0;
        double h = (b - a) / (double)N;
        double h2 = h / 2.0;
        double[] zeros = new double[8];
        double[] coeffs = new double[8];
        zeros[4] = 0.1834346424956498;
        zeros[5] = 0.525532409916329;
        zeros[6] = 0.7966664774136267;
        zeros[7] = 0.9602898564975363;
        zeros[0] = -zeros[7];
        zeros[1] = -zeros[6];
        zeros[2] = -zeros[5];
        zeros[3] = -zeros[4];
        coeffs[7] = 0.10122853629037626;
        coeffs[0] = 0.10122853629037626;
        coeffs[6] = 0.22238103445337448;
        coeffs[1] = 0.22238103445337448;
        coeffs[5] = 0.31370664587788727;
        coeffs[2] = 0.31370664587788727;
        coeffs[4] = 0.362683783378362;
        coeffs[3] = 0.362683783378362;
        for (int n = 0; n < N; ++n) {
            for (int i = 0; i < zeros.length; ++i) {
                A += coeffs[i] * func.map(a + (zeros[i] + 1.0) * h2);
            }
            a += h;
        }
        return A * h2;
    }

    public static double[] differentiate(int N, Mapping func, double a, double b) {
        double[] diff = new double[N];
        double x = a;
        double dx = (b - a) / (double)N;
        double dx2 = dx / 2.0;
        for (int i = 0; i < N; ++i) {
            diff[i] = (func.map(x + dx2) - func.map(x - dx2)) / dx;
            x += dx;
        }
        return diff;
    }

    public static double[][] differentiate(MappingND func, double[] x, double[] dx) {
        int i;
        double[] xplus = new double[x.length];
        double[] xminus = new double[x.length];
        System.arraycopy(x, 0, xplus, 0, x.length);
        System.arraycopy(x, 0, xminus, 0, x.length);
        xplus[0] = xplus[0] + dx[0];
        xminus[0] = xminus[0] - dx[0];
        double[] funcdiff = ArrayMath.scalarMultiply(0.5 / dx[0], ArrayMath.subtract(func.map(xplus), func.map(xminus)));
        double[][] diff = new double[funcdiff.length][x.length];
        for (i = 0; i < funcdiff.length; ++i) {
            diff[i][0] = funcdiff[i];
        }
        for (int j = 1; j < x.length; ++j) {
            System.arraycopy(x, 0, xplus, 0, x.length);
            System.arraycopy(x, 0, xminus, 0, x.length);
            int n = j;
            xplus[n] = xplus[n] + dx[j];
            int n2 = j;
            xminus[n2] = xminus[n2] - dx[j];
            funcdiff = ArrayMath.scalarMultiply(0.5 / dx[j], ArrayMath.subtract(func.map(xplus), func.map(xminus)));
            for (i = 0; i < funcdiff.length; ++i) {
                diff[i][j] = funcdiff[i];
            }
        }
        return diff;
    }

    public static double[] metropolis(double[] list, Mapping func, double dx) {
        for (int i = 0; i < list.length - 1; ++i) {
            list[i + 1] = list[i] + dx * (2.0 * Math.random() - 1.0);
            if (!(func.map(list[i + 1]) / func.map(list[i]) < Math.random())) continue;
            list[i + 1] = list[i];
        }
        return list;
    }
}

