/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.GlobalSettings;
import jsci.maths.ExtraMath;
import jsci.maths.fields.Field;
import jsci.maths.fields.RealField;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;

public final class MathDouble
extends Number
implements Comparable,
Field.Member {
    private static final long serialVersionUID = 8616680319093653108L;
    private final double x;

    public MathDouble(double num) {
        this.x = num;
    }

    public MathDouble(String s) throws NumberFormatException {
        this.x = Double.parseDouble(s);
    }

    public boolean equals(Object obj) {
        return this.equals(obj, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(Object obj, double tol) {
        if (obj instanceof Number) {
            return Math.abs(this.x - ((Number)obj).doubleValue()) <= tol;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.x;
    }

    public int compareTo(Object obj) throws IllegalArgumentException {
        if (obj != null && obj instanceof Number) {
            double objValue = ((Number)obj).doubleValue();
            if (Math.abs(this.x - objValue) <= GlobalSettings.ZERO_TOL) {
                return 0;
            }
            return this.x < objValue ? -1 : 1;
        }
        throw new IllegalArgumentException("Invalid object: " + obj.getClass());
    }

    public String toString() {
        return Double.toString(this.x);
    }

    public double value() {
        return this.x;
    }

    @Override
    public int intValue() {
        return (int)this.x;
    }

    @Override
    public long longValue() {
        return (long)this.x;
    }

    @Override
    public float floatValue() {
        return (float)this.x;
    }

    @Override
    public double doubleValue() {
        return this.x;
    }

    public static boolean isZero(double x) {
        return Math.abs(x) <= GlobalSettings.ZERO_TOL;
    }

    public boolean isNaN() {
        return this.x == Double.NaN;
    }

    public boolean isInfinite() {
        return this.x == Double.POSITIVE_INFINITY || this.x == Double.NEGATIVE_INFINITY;
    }

    @Override
    public Object getSet() {
        return RealField.getInstance();
    }

    @Override
    public AbelianGroup.Member negate() {
        return new MathDouble(-this.x);
    }

    @Override
    public Field.Member inverse() {
        return new MathDouble(1.0 / this.x);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member n) {
        if (n instanceof Number) {
            return this.add(((Number)((Object)n)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + n.getClass());
    }

    public MathDouble add(MathDouble n) {
        return this.add(n.x);
    }

    public MathDouble add(double y) {
        return new MathDouble(this.x + y);
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member n) {
        if (n instanceof Number) {
            return this.subtract(((Number)((Object)n)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + n.getClass());
    }

    public MathDouble subtract(MathDouble n) {
        return this.subtract(n.x);
    }

    public MathDouble subtract(double y) {
        return new MathDouble(this.x - y);
    }

    @Override
    public Ring.Member multiply(Ring.Member n) {
        if (n instanceof Number) {
            return this.multiply(((Number)((Object)n)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + n.getClass());
    }

    public MathDouble multiply(MathDouble n) {
        return this.multiply(n.x);
    }

    public MathDouble multiply(double y) {
        return new MathDouble(this.x * y);
    }

    @Override
    public Field.Member divide(Field.Member n) {
        if (n instanceof Number) {
            return this.divide(((Number)((Object)n)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + n.getClass());
    }

    public MathDouble divide(MathDouble n) {
        return this.divide(n.x);
    }

    public MathDouble divide(double y) {
        return new MathDouble(this.x / y);
    }

    public static MathDouble exp(MathDouble x) {
        return MathDouble.exp(x.x);
    }

    public static MathDouble exp(Number x) {
        return MathDouble.exp(x.doubleValue());
    }

    public static MathDouble exp(double x) {
        return new MathDouble(Math.exp(x));
    }

    public static MathDouble log(MathDouble x) {
        return MathDouble.log(x.x);
    }

    public static MathDouble log(Number x) {
        return MathDouble.log(x.doubleValue());
    }

    public static MathDouble log(double x) {
        return new MathDouble(Math.log(x));
    }

    public static MathDouble sin(MathDouble x) {
        return MathDouble.sin(x.x);
    }

    public static MathDouble sin(Number x) {
        return MathDouble.sin(x.doubleValue());
    }

    public static MathDouble sin(double x) {
        return new MathDouble(Math.sin(x));
    }

    public static MathDouble cos(MathDouble x) {
        return MathDouble.cos(x.x);
    }

    public static MathDouble cos(Number x) {
        return MathDouble.cos(x.doubleValue());
    }

    public static MathDouble cos(double x) {
        return new MathDouble(Math.cos(x));
    }

    public static MathDouble tan(MathDouble x) {
        return MathDouble.tan(x.x);
    }

    public static MathDouble tan(Number x) {
        return MathDouble.tan(x.doubleValue());
    }

    public static MathDouble tan(double x) {
        return new MathDouble(Math.tan(x));
    }

    public static MathDouble sinh(MathDouble x) {
        return MathDouble.sinh(x.x);
    }

    public static MathDouble sinh(Number x) {
        return MathDouble.sinh(x.doubleValue());
    }

    public static MathDouble sinh(double x) {
        return new MathDouble(ExtraMath.sinh(x));
    }

    public static MathDouble cosh(MathDouble x) {
        return MathDouble.cosh(x.x);
    }

    public static MathDouble cosh(Number x) {
        return MathDouble.cosh(x.doubleValue());
    }

    public static MathDouble cosh(double x) {
        return new MathDouble(ExtraMath.cosh(x));
    }

    public static MathDouble tanh(MathDouble x) {
        return MathDouble.tanh(x.x);
    }

    public static MathDouble tanh(Number x) {
        return MathDouble.tanh(x.doubleValue());
    }

    public static MathDouble tanh(double x) {
        return new MathDouble(ExtraMath.tanh(x));
    }

    public static MathDouble asin(MathDouble x) {
        return MathDouble.asin(x.x);
    }

    public static MathDouble asin(Number x) {
        return MathDouble.asin(x.doubleValue());
    }

    public static MathDouble asin(double x) {
        return new MathDouble(Math.asin(x));
    }

    public static MathDouble acos(MathDouble x) {
        return MathDouble.acos(x.x);
    }

    public static MathDouble acos(Number x) {
        return MathDouble.acos(x.doubleValue());
    }

    public static MathDouble acos(double x) {
        return new MathDouble(Math.acos(x));
    }

    public static MathDouble atan(MathDouble x) {
        return MathDouble.atan(x.x);
    }

    public static MathDouble atan(Number x) {
        return MathDouble.atan(x.doubleValue());
    }

    public static MathDouble atan(double x) {
        return new MathDouble(Math.atan(x));
    }

    public static MathDouble asinh(MathDouble x) {
        return MathDouble.asinh(x.x);
    }

    public static MathDouble asinh(Number x) {
        return MathDouble.asinh(x.doubleValue());
    }

    public static MathDouble asinh(double x) {
        return new MathDouble(ExtraMath.asinh(x));
    }

    public static MathDouble acosh(MathDouble x) {
        return MathDouble.acosh(x.x);
    }

    public static MathDouble acosh(Number x) {
        return MathDouble.acosh(x.doubleValue());
    }

    public static MathDouble acosh(double x) {
        return new MathDouble(ExtraMath.acosh(x));
    }

    public static MathDouble atanh(MathDouble x) {
        return MathDouble.atanh(x.x);
    }

    public static MathDouble atanh(Number x) {
        return MathDouble.atanh(x.doubleValue());
    }

    public static MathDouble atanh(double x) {
        return new MathDouble(ExtraMath.atanh(x));
    }
}

