/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.maths.AbstractMath;
import jsci.maths.SpecialMath;

public final class ExtraMath
extends AbstractMath {
    private ExtraMath() {
    }

    public static double round(double x, int significant) {
        if (x == 0.0) {
            return x;
        }
        if (significant == 0) {
            return 0.0;
        }
        double signedExp = ExtraMath.log10(Math.abs(x)) - (double)significant;
        if (signedExp < 0.0) {
            double factor = Math.pow(10.0, Math.floor(-signedExp));
            return (double)Math.round(x * factor) / factor;
        }
        double factor = Math.pow(10.0, Math.ceil(signedExp));
        return (double)Math.round(x / factor) * factor;
    }

    public static double random(double min, double max) {
        return (max - min) * Math.random() + min;
    }

    public static int sign(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double hypot(double x, double y) {
        double xAbs = Math.abs(x);
        double yAbs = Math.abs(y);
        if (xAbs == 0.0 && yAbs == 0.0) {
            return 0.0;
        }
        if (xAbs < yAbs) {
            return yAbs * Math.sqrt(1.0 + x / y * (x / y));
        }
        return xAbs * Math.sqrt(1.0 + y / x * (y / x));
    }

    public static int pow(int a, int b) {
        if (b < 0) {
            throw new IllegalArgumentException(b + " must be a positive integer.");
        }
        if (b == 0) {
            return 1;
        }
        if (a == 0) {
            return 0;
        }
        if (a == 1) {
            return 1;
        }
        if (a == 2) {
            return 1 << b;
        }
        for (int i = 1; i < b; ++i) {
            a *= a;
        }
        return a;
    }

    public static int pow2(int a) {
        return 1 << a;
    }

    public static double factorial(double x) {
        return SpecialMath.gamma(x + 1.0);
    }

    public static double logFactorial(double x) {
        return SpecialMath.logGamma(x + 1.0);
    }

    public static int binomial(int n, int k) {
        if (k == n || k == 0) {
            return 1;
        }
        if (n == 0) {
            return 1;
        }
        return ExtraMath.binomial(n - 1, k - 1) + ExtraMath.binomial(n - 1, k);
    }

    public static double binomial(double n, double k) {
        return Math.exp(SpecialMath.logGamma(n + 1.0) - SpecialMath.logGamma(k + 1.0) - SpecialMath.logGamma(n - k + 1.0));
    }

    public static double log10(double x) {
        return Math.log(x) / 2.302585092994046;
    }

    public static double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static double tanh(double x) {
        return ExtraMath.sinh(x) / ExtraMath.cosh(x);
    }

    public static double coth(double x) {
        return 1.0 / ExtraMath.tanh(x);
    }

    public static double csch(double x) {
        return 1.0 / ExtraMath.sinh(x);
    }

    public static double sech(double x) {
        return 1.0 / ExtraMath.cosh(x);
    }

    public static double asinh(double x) {
        return Double.isInfinite(x) ? x : (x == 0.0 ? x : Math.log(x + Math.sqrt(x * x + 1.0)));
    }

    public static double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static double atanh(double x) {
        return x != 0.0 ? (Math.log(1.0 + x) - Math.log(1.0 - x)) / 2.0 : x;
    }

    public static double acoth(double x) {
        if (Double.isInfinite(x)) {
            return x < 0.0 ? -0.0 : 0.0;
        }
        return x == -1.0 ? Double.NEGATIVE_INFINITY : (Math.log(x + 1.0) - Math.log(x - 1.0)) / 2.0;
    }

    public static double acsch(double x) {
        if (Double.isInfinite(x)) {
            return x < 0.0 ? -0.0 : 0.0;
        }
        return x == 0.0 ? 1.0 / x : Math.log((1.0 + (double)ExtraMath.sign(x) * Math.sqrt(x * x + 1.0)) / x);
    }

    public static double asech(double x) {
        return x == 0.0 ? 1.0 / x : Math.log((1.0 + Math.sqrt(1.0 - x * x)) / x);
    }
}

