/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.maths.AbstractMath;
import jsci.maths.ArrayMath;

public final class EngineerMath
extends AbstractMath {
    private EngineerMath() {
    }

    public static double[] runningAverage(double[] v, int width) {
        int k;
        if (v.length < width) {
            throw new IllegalArgumentException("Array must be at least as long as the required width : " + v.length + " < " + width);
        }
        if ((width & 1) == 0) {
            throw new IllegalArgumentException("The parameter 'width' must be odd : " + width);
        }
        if (v.length == 0) {
            throw new IllegalArgumentException("Empty array, nothing to compute!");
        }
        int halfsize = width >> 1;
        double[] ans = new double[v.length];
        ans[0] = ArrayMath.mean(ArrayMath.extract(0, width - 1, v));
        for (k = 1; k < halfsize; ++k) {
            ans[k] = ans[0];
        }
        for (k = halfsize; k < v.length - halfsize - 1; ++k) {
            ans[k] = ArrayMath.mean(ArrayMath.extract(k - halfsize, k + halfsize, v));
        }
        ans[v.length - halfsize - 1] = ArrayMath.mean(ArrayMath.extract(v.length - 1 - width + 1, v.length - 1, v));
        for (k = v.length - halfsize; k < v.length; ++k) {
            ans[k] = ans[v.length - halfsize - 1];
        }
        return ans;
    }

    public static double[] runningMedian(double[] v, int width) {
        int k;
        if (v.length < width) {
            throw new IllegalArgumentException("Array must be at least as long as the required width : " + v.length + " < " + width);
        }
        if ((width & 1) == 0) {
            throw new IllegalArgumentException("The parameter 'width' must be odd : " + width);
        }
        if (v.length == 0) {
            throw new IllegalArgumentException("Empty array, nothing to compute!");
        }
        int halfsize = width >> 1;
        double[] ans = new double[v.length];
        ans[0] = ArrayMath.median(ArrayMath.extract(0, width - 1, v));
        for (k = 1; k < halfsize; ++k) {
            ans[k] = ans[0];
        }
        for (k = halfsize; k < v.length - halfsize - 1; ++k) {
            ans[k] = ArrayMath.median(ArrayMath.extract(k - halfsize, k + halfsize, v));
        }
        ans[v.length - halfsize - 1] = ArrayMath.median(ArrayMath.extract(v.length - 1 - width + 1, v.length - 1, v));
        for (k = v.length - halfsize; k < v.length; ++k) {
            ans[k] = ans[v.length - halfsize - 1];
        }
        return ans;
    }

    public static double icf(double[] v) {
        double ans = 0.0;
        for (int j = 0; j < v.length; ++j) {
            if (v[j] == 0.0) continue;
            if (v[j] < 0.0) {
                throw new IllegalArgumentException("You cannot take the ICF of a array having negative components : v [" + j + "] = " + v[j] + " < 0");
            }
            ans -= v[j] * Math.log(v[j]);
        }
        return ans;
    }

    public static double entropy(double[] v) {
        double[] temp = ArrayMath.abs(v);
        double m = ArrayMath.mass(temp);
        if (m == 0.0) {
            return 0.0;
        }
        temp = ArrayMath.scalarMultiply(1.0 / m, temp);
        return EngineerMath.icf(temp);
    }

    public static double entropy(int[] v) {
        int[] temp = ArrayMath.abs(v);
        int m = ArrayMath.mass(temp);
        if (m == 0) {
            return 0.0;
        }
        double[] t2 = ArrayMath.scalarMultiply(1.0 / (double)m, temp);
        return EngineerMath.icf(t2);
    }

    public static double[] resample(double[] data, int newLength) {
        if (newLength <= 0) {
            throw new IllegalArgumentException("New length must be strictly positive : " + newLength + " <=0 ");
        }
        double[] ans = new double[newLength];
        for (int k = 0; k < newLength; ++k) {
            double pos = (double)k / (double)(newLength - 1) * (double)(data.length - 1);
            int base1 = (int)Math.floor(pos);
            int base2 = (int)Math.ceil(pos);
            double mod = pos - (double)base1;
            ans[k] = data[base1] * mod + data[base2] * (1.0 - mod);
        }
        return ans;
    }
}

