/*
 * Decompiled with CFR 0.152.
 */
package jsci.chemistry;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jsci.chemistry.Element;
import jsci.chemistry.periodictable.AlkaliEarthMetal;
import jsci.chemistry.periodictable.AlkaliMetal;
import jsci.chemistry.periodictable.Halogen;
import jsci.chemistry.periodictable.Metal;
import jsci.chemistry.periodictable.NobleGas;
import jsci.chemistry.periodictable.NonMetal;
import jsci.chemistry.periodictable.RareEarthMetal;
import jsci.chemistry.periodictable.TransitionMetal;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class PeriodicTable {
    private static final Map table = new HashMap();
    private static Map symbols;

    private PeriodicTable() {
    }

    public static String getName(String symbol) {
        if (symbols == null) {
            symbols = PeriodicTable.loadIndex();
        }
        return (String)symbols.get(symbol);
    }

    public static Element getElement(String name) {
        Element element = (Element)table.get(name = name.toLowerCase());
        if (element == null && (element = PeriodicTable.loadElement("periodictable/" + name + ".xml")) != null) {
            table.put(name, element);
        }
        return element;
    }

    private static Map loadIndex() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(PeriodicTable.class.getResource("periodictable/index.xml").toString());
            org.w3c.dom.Element root = doc.getDocumentElement();
            NodeList nl = root.getChildNodes();
            HashMap<String, String> index = new HashMap<String, String>();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!node.getNodeName().equals("element")) continue;
                NamedNodeMap attr = node.getAttributes();
                index.put(attr.getNamedItem("symbol").getNodeValue(), attr.getNamedItem("name").getNodeValue());
            }
            return index;
        }
        catch (ParserConfigurationException e) {
            return Collections.EMPTY_MAP;
        }
        catch (IOException e) {
            return Collections.EMPTY_MAP;
        }
        catch (SAXException e) {
            return Collections.EMPTY_MAP;
        }
    }

    private static Element loadElement(String resname) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(PeriodicTable.class.getResource(resname).toString());
            org.w3c.dom.Element root = doc.getDocumentElement();
            String group = root.getAttributes().getNamedItem("series").getNodeValue();
            NodeList nl = root.getChildNodes();
            String name = PeriodicTable.findStringValue(nl, "name");
            String symbol = PeriodicTable.findStringValue(nl, "symbol");
            Element elem = group.equals("non-metal") ? new NonMetal(name, symbol) : (group.equals("halogen") ? new Halogen(name, symbol) : (group.equals("noble-gas") ? new NobleGas(name, symbol) : (group.equals("metal") ? new Metal(name, symbol) : (group.equals("alkali-metal") ? new AlkaliMetal(name, symbol) : (group.equals("alkali-earth-metal") ? new AlkaliEarthMetal(name, symbol) : (group.equals("rare-earth-metal") ? new RareEarthMetal(name, symbol) : (group.equals("transition-metal") ? new TransitionMetal(name, symbol) : new Element(name, symbol))))))));
            elem.setAtomicNumber(Integer.parseInt(PeriodicTable.findStringValue(nl, "atomic-number")));
            elem.setMassNumber(Integer.parseInt(PeriodicTable.findStringValue(nl, "mass-number")));
            elem.setElectronegativity(PeriodicTable.findDoubleValue(nl, "electronegativity"));
            elem.setCovalentRadius(PeriodicTable.findDoubleValue(nl, "covalent-radius"));
            elem.setAtomicRadius(PeriodicTable.findDoubleValue(nl, "atomic-radius"));
            elem.setMeltingPoint(PeriodicTable.findDoubleValue(nl, "melting-point"));
            elem.setBoilingPoint(PeriodicTable.findDoubleValue(nl, "boiling-point"));
            elem.setDensity(PeriodicTable.findDoubleValue(nl, "density"));
            elem.setSpecificHeat(PeriodicTable.findDoubleValue(nl, "specific-heat"));
            elem.setElectricalConductivity(PeriodicTable.findDoubleValue(nl, "electrical-conductivity"));
            elem.setThermalConductivity(PeriodicTable.findDoubleValue(nl, "thermal-conductivity"));
            return elem;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
    }

    private static String findStringValue(NodeList nl, String name) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if (!item.getNodeName().equals(name)) continue;
            return item.getFirstChild().getNodeValue();
        }
        return "";
    }

    private static double findDoubleValue(NodeList nl, String name) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if (!item.getNodeName().equals(name)) continue;
            return Double.parseDouble(item.getFirstChild().getNodeValue());
        }
        return Double.NaN;
    }
}

