/*
 * Decompiled with CFR 0.152.
 */
package jsci.chemistry;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jsci.chemistry.Atom;
import jsci.chemistry.Element;
import jsci.chemistry.PeriodicTable;
import jsci.physics.Particle;

public class Molecule
extends Particle {
    private final Set atoms = new HashSet();

    public Molecule(String formula) {
        int count;
        int endPos;
        if (formula == null || formula.length() == 0) {
            throw new IllegalArgumentException("Formula cannot be null or empty.");
        }
        int startPos = 0;
        boolean isNumber = false;
        String symbol = null;
        for (int i = 1; i < formula.length(); ++i) {
            char ch = formula.charAt(i);
            if (Character.isUpperCase(ch)) {
                endPos = i;
                if (isNumber) {
                    count = Integer.parseInt(formula.substring(startPos, endPos));
                    isNumber = false;
                } else {
                    symbol = formula.substring(startPos, endPos);
                    count = 1;
                }
                String name = PeriodicTable.getName(symbol);
                if (name != null) {
                    Element element = PeriodicTable.getElement(name);
                    for (int j = 0; j < count; ++j) {
                        this.atoms.add(new Atom(element));
                    }
                }
                startPos = endPos;
                continue;
            }
            if (isNumber || !Character.isDigit(ch)) continue;
            isNumber = true;
            endPos = i;
            symbol = formula.substring(startPos, endPos);
            startPos = endPos;
        }
        endPos = formula.length();
        if (isNumber) {
            count = Integer.parseInt(formula.substring(startPos, endPos));
            isNumber = false;
        } else {
            symbol = formula.substring(startPos, endPos);
            count = 1;
        }
        String name = PeriodicTable.getName(symbol);
        if (name != null) {
            Element element = PeriodicTable.getElement(name);
            for (int j = 0; j < count; ++j) {
                this.atoms.add(new Atom(element));
            }
        }
    }

    public Molecule(Atom a, Atom b) {
        this.atoms.add(a);
        this.atoms.add(b);
    }

    public Molecule(Atom[] a) {
        for (int i = 0; i < a.length; ++i) {
            this.atoms.add(a[i]);
        }
    }

    public Set getAtoms() {
        return Collections.unmodifiableSet(this.atoms);
    }

    public Molecule bind(Atom a) {
        this.atoms.add(a);
        return this;
    }

    public Molecule bind(Molecule m) {
        this.atoms.addAll(m.atoms);
        return this;
    }
}

