/*
 * Decompiled with CFR 0.152.
 */
package jsci;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;

public final class Version
implements Serializable {
    public final int major;
    public final int minor;
    public final String platform;
    public final String home;

    public static Version getCurrent() {
        ResourceBundle bundle = ResourceBundle.getBundle("JSci.Bundle");
        int major = Integer.parseInt(bundle.getString("version.major"));
        int minor = Integer.parseInt(bundle.getString("version.minor"));
        String platform = bundle.getString("version.platform");
        String home = bundle.getString("version.home");
        return new Version(major, minor, home, platform);
    }

    public static Version getLatest() throws IOException {
        Version latest = null;
        try {
            URL serurl = new URL(Version.getCurrent().home + "version.ser");
            ObjectInputStream in = new ObjectInputStream(serurl.openStream());
            latest = (Version)in.readObject();
            in.close();
        }
        catch (MalformedURLException murle) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return latest;
    }

    private Version(int major, int minor, String home, String platform) {
        this.major = major;
        this.minor = minor;
        this.home = home;
        this.platform = platform;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version ver = (Version)o;
        return this.major == ver.major && this.minor == ver.minor && this.platform.equals(ver.platform);
    }

    public int hashCode() {
        return 37 * (37 * (629 + this.major) + this.minor) + this.platform.hashCode();
    }

    public String toString() {
        return new StringBuffer().append(this.major).append('.').append(this.minor).toString();
    }

    public boolean isLater(Version ver) {
        return this.major > ver.major || this.major == ver.major && this.minor > ver.minor;
    }
}

