/*
 * Decompiled with CFR 0.152.
 */
package joptima.functions;

import joptima.Function;
import joptima.Function2D;
import joptima.Parameter;

public class Sum2D
implements Function2D {
    Function m_xfunction = null;
    Function m_yfunction = null;
    String m_name = null;

    public Sum2D(Function xfunction, Function yfunction) {
        this.m_xfunction = xfunction;
        this.m_yfunction = yfunction;
    }

    @Override
    public double calculate(double x, double y) {
        double value = 0.0;
        if (null != this.m_xfunction) {
            value += this.m_xfunction.calculate(x);
        }
        if (null != this.m_yfunction) {
            value += this.m_yfunction.calculate(y);
        }
        return value;
    }

    @Override
    public Parameter[] getParameters() {
        int i;
        int nparams = 0;
        if (null != this.m_xfunction) {
            nparams += this.m_xfunction.getParameters().length;
        }
        if (null != this.m_yfunction) {
            nparams += this.m_yfunction.getParameters().length;
        }
        Parameter[] ret = new Parameter[nparams];
        int counter = 0;
        if (null != this.m_xfunction) {
            for (i = 0; i < this.m_xfunction.getParameters().length; ++i) {
                ret[counter++] = this.m_xfunction.getParameters()[i];
            }
        }
        if (null != this.m_yfunction) {
            for (i = 0; i < this.m_yfunction.getParameters().length; ++i) {
                ret[counter++] = this.m_yfunction.getParameters()[i];
            }
        }
        return ret;
    }

    @Override
    public double calculate(double x) {
        throw new UnsupportedOperationException("Don't know what to calculate from a single parameter.");
    }

    @Override
    public String getName() {
        if (null != this.m_name) {
            return this.m_name;
        }
        StringBuffer ret = new StringBuffer();
        if (null != this.m_xfunction) {
            ret.append(this.m_xfunction.getName());
        }
        if (null != this.m_xfunction && null != this.m_yfunction) {
            ret.append(" + ");
        }
        if (null != this.m_yfunction) {
            ret.append(this.m_yfunction.getName());
        }
        return ret.toString();
    }

    @Override
    public void setName(String newname) {
        this.m_name = newname;
    }
}

